# Condition - Acute Bronchitis (Encounter Diagnosis) - Health Care Surveys Reporting v2.0.0

## Example Condition: Condition - Acute Bronchitis (Encounter Diagnosis)

Language: en

Profile: [US Core Condition Encounter Diagnosis Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-condition-encounter-diagnosis.html)

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Encounter Diagnosis

**code**: Acute bronchitis

**subject**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**encounter**: [Ambulatory Office Visit](Encounter-encounter-ambulatory.md)

**onset**: 2023-01-02

**recordedDate**: 2023-01-02

**recorder**: [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md)

**asserter**: [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md)



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "condition-encounter-diagnosis-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|6.1.0"
    ]
  },
  "language" : "en",
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
          "code" : "encounter-diagnosis",
          "display" : "Encounter Diagnosis"
        }
      ],
      "text" : "Encounter Diagnosis"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "10509002",
        "display" : "Acute bronchitis (disorder)"
      }
    ],
    "text" : "Acute bronchitis"
  },
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "encounter" : {
    "reference" : "Encounter/encounter-ambulatory",
    "display" : "Ambulatory Office Visit"
  },
  "onsetDateTime" : "2023-01-02",
  "recordedDate" : "2023-01-02",
  "recorder" : {
    "reference" : "Practitioner/practitioner-nichols"
  },
  "asserter" : {
    "reference" : "Practitioner/practitioner-nichols"
  }
}

```
