# Composition - National Healthcare Surveys Report - Health Care Surveys Reporting v2.0.0

## Example Composition: Composition - National Healthcare Surveys Report

Language: en

Profile: [Health Care Surveys Composition](StructureDefinition-hcs-composition.md)

**identifier**: c03eab8c-11e8-4d0c-ad2a-b385395e27db

**status**: Final

**type**: National Health Care Surveys report

**encounter**: [Ambulatory Office Visit](Encounter-encounter-ambulatory.md)

**date**: 2023-01-02 22:13:23+0000

**author**: [Nicholas Joseph](Practitioner-practitioner-nichols.md)

**title**: National Health Care Surveys report



## Resource Content

```json
{
  "resourceType" : "Composition",
  "id" : "hcs-composition-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/health-care-surveys-reporting/StructureDefinition/hcs-composition"
    ]
  },
  "language" : "en",
  "identifier" : {
    "value" : "c03eab8c-11e8-4d0c-ad2a-b385395e27db"
  },
  "status" : "final",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "75619-7"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "encounter" : {
    "reference" : "Encounter/encounter-ambulatory",
    "display" : "Ambulatory Office Visit"
  },
  "date" : "2023-01-02T22:13:23Z",
  "author" : [
    {
      "reference" : "Practitioner/practitioner-nichols",
      "display" : "Nicholas Joseph"
    }
  ],
  "title" : "National Health Care Surveys report",
  "section" : [
    {
      "title" : "Reason for Visit Section",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "29299-5",
            "display" : "Reason for visit Narrative"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Reason for Visit: Bad cough</p></div>"
      }
    },
    {
      "title" : "Problems Section",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "11450-4",
            "display" : "Problem list - Reported"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Single liveborn, born in hospital</p><p>Acute bronchitis</p></div>"
      },
      "entry" : [
        {
          "reference" : "Condition/condition-problem-liveborn-example"
        },
        {
          "reference" : "Condition/condition-encounter-diagnosis-example"
        }
      ]
    },
    {
      "title" : "Allergies Section",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48765-2",
            "display" : "Allergies and adverse reactions Document"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Allergy to Sulfonide</p></div>"
      },
      "entry" : [
        {
          "reference" : "AllergyIntolerance/allergyintolerance-sulfonamide-example"
        }
      ]
    },
    {
      "title" : "Medications Section",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "10160-0",
            "display" : "History of Medication use Narrative"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Taking Lantus</div>"
      },
      "entry" : [
        {
          "reference" : "MedicationAdministration/medicationadministrationone-example"
        },
        {
          "reference" : "MedicationRequest/MedicationRequest-example"
        }
      ]
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "30954-2",
            "display" : "Relevant diagnostic tests/laboratory data note"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>CBC Results: WBC 6.8, RBC 4.2, Hgb 14.0, Hct 41.0, Plt 210</p><p>CMP Results: Glucose 98, BUN 14, Cr 0.8, Na 140, K 3.8, Cl 102</p></div>"
      },
      "entry" : [
        {
          "reference" : "Observation/observation-clinical-example"
        },
        {
          "reference" : "DiagnosticReport/diagnosticreport-lab-example"
        }
      ]
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "28650-0",
            "display" : "Clinical notes and chart sections Set"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Patient presented with one week history of cough and low-grade fever. Lungs clear on examination. No lymphadenopathy.</p></div>"
      },
      "entry" : [
        {
          "reference" : "DocumentReference/documentreference-example"
        },
        {
          "reference" : "DiagnosticReport/diagnosticreport-note-example"
        }
      ]
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "51847-2",
            "display" : "Evaluation + Plan note"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><ul><li>Referral to social worker for housing assistance</li></ul><p>Continue symptomatic treatment. Return if symptoms worsen or fail to improve within 5 days.</p></div>"
      },
      "entry" : [
        {
          "reference" : "Observation/observation-screening-example"
        }
      ]
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "11369-6",
            "display" : "History of Immunization note"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Influenza vaccine administered 10/15/2024</p><p>COVID-19 vaccine: Last dose received 06/20/2024</p></div>"
      },
      "entry" : [
        {
          "reference" : "Immunization/immunization-example"
        }
      ]
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "47519-4",
            "display" : "History of Procedures Document"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>service request for a CT chest evaluation procedure for acute viral pharyngitis</p></div>"
      },
      "entry" : [
        {
          "reference" : "Procedure/procedure-example"
        },
        {
          "reference" : "ServiceRequest/servicerequest-example"
        }
      ]
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8716-3",
            "display" : "Vital signs note"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>BP: 120/80 mmHg</p><p>HR: 70 bpm</p><p>Temp: 37.0 C</p><p>RR: 16</p><p>SpO2: 98%</p><p>Weight: 68 kg</p><p>Height: 170 cm</p><p>BMI: 23.5 kg/m²</p></div>"
      },
      "entry" : [
        {
          "reference" : "Observation/observation-bp-example"
        },
        {
          "reference" : "Observation/observation-weight-example"
        },
        {
          "reference" : "Observation/observation-height-example"
        },
        {
          "reference" : "Observation/observation-heartrate-example"
        },
        {
          "reference" : "Observation/observation-oximetry-example"
        },
        {
          "reference" : "Observation/observation-temperature-example"
        },
        {
          "reference" : "Observation/observation-resprate-example"
        }
      ]
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "29762-2",
            "display" : "Social history note"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Patient is a non-smoker</p><p>Occupation: Certified Nursing Assistant (CNA) [Nursing Assistants]</p><p>Industry: Home nursing services</p></div>"
      },
      "entry" : [
        {
          "reference" : "Observation/observation-occupation-example"
        }
      ]
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "46264-8",
            "display" : "History of medical device use"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Implantable device: Pacemaker Model X1000</p></div>"
      },
      "entry" : [
        {
          "reference" : "Device/device-example"
        }
      ]
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "85847-2",
            "display" : "Patient Care team information"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Primary Care Provider: Dr. Nicholas Joseph</p><p>Pulmonologist: Dr. Sarah Chen</p></div>"
      },
      "entry" : [
        {
          "reference" : "CareTeam/careteam-example"
        }
      ]
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "61146-7",
            "display" : "Goals"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Resolve acute bronchitis</p><p>Improve sleep quality</p></div>"
      },
      "entry" : [
        {
          "reference" : "Goal/goal-example"
        }
      ]
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "90767-5",
            "display" : "Pregnancy summary Document"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Patient is not currently pregnant</p></div>"
      },
      "entry" : [
        {
          "reference" : "Observation/observation-pregnancy-status-example"
        },
        {
          "reference" : "Observation/observation-pregnancy-intent-example"
        }
      ]
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "48768-6",
            "display" : "Payment sources Document"
          }
        ]
      },
      "text" : {
        "status" : "generated",
        "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Primary Insurance: Blue Cross Blue Shield</p><p>ID: XYZ123456789</p><p>Group: ABC987</p></div>"
      },
      "entry" : [
        {
          "reference" : "Coverage/coverage-bcbs-example"
        }
      ]
    }
  ]
}

```
