<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile NatlDirExInsurancePlan
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>InsurancePlan.meta</sch:title>
    <sch:rule context="f:InsurancePlan/f:meta">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.meta.extension</sch:title>
    <sch:rule context="f:InsurancePlan/f:meta/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.meta.versionId</sch:title>
    <sch:rule context="f:InsurancePlan/f:meta/f:versionId">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.meta.lastUpdated</sch:title>
    <sch:rule context="f:InsurancePlan/f:meta/f:lastUpdated">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.meta.source</sch:title>
    <sch:rule context="f:InsurancePlan/f:meta/f:source">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.meta.profile</sch:title>
    <sch:rule context="f:InsurancePlan/f:meta/f:profile">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.meta.security</sch:title>
    <sch:rule context="f:InsurancePlan/f:meta/f:security">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.meta.tag</sch:title>
    <sch:rule context="f:InsurancePlan/f:meta/f:tag">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.implicitRules</sch:title>
    <sch:rule context="f:InsurancePlan/f:implicitRules">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.language</sch:title>
    <sch:rule context="f:InsurancePlan/f:language">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.text</sch:title>
    <sch:rule context="f:InsurancePlan/f:text">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.extension</sch:title>
    <sch:rule context="f:InsurancePlan/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.modifierExtension</sch:title>
    <sch:rule context="f:InsurancePlan/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.identifier</sch:title>
    <sch:rule context="f:InsurancePlan/f:identifier">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.status</sch:title>
    <sch:rule context="f:InsurancePlan/f:status">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.type</sch:title>
    <sch:rule context="f:InsurancePlan/f:type">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.name</sch:title>
    <sch:rule context="f:InsurancePlan/f:name">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.alias</sch:title>
    <sch:rule context="f:InsurancePlan/f:alias">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.period</sch:title>
    <sch:rule context="f:InsurancePlan/f:period">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.ownedBy</sch:title>
    <sch:rule context="f:InsurancePlan/f:ownedBy">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.administeredBy</sch:title>
    <sch:rule context="f:InsurancePlan/f:administeredBy">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.coverageArea</sch:title>
    <sch:rule context="f:InsurancePlan/f:coverageArea">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.contact</sch:title>
    <sch:rule context="f:InsurancePlan/f:contact">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.contact.extension</sch:title>
    <sch:rule context="f:InsurancePlan/f:contact/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.contact.modifierExtension</sch:title>
    <sch:rule context="f:InsurancePlan/f:contact/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.contact.purpose</sch:title>
    <sch:rule context="f:InsurancePlan/f:contact/f:purpose">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.contact.name</sch:title>
    <sch:rule context="f:InsurancePlan/f:contact/f:name">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.contact.telecom</sch:title>
    <sch:rule context="f:InsurancePlan/f:contact/f:telecom">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.contact.address</sch:title>
    <sch:rule context="f:InsurancePlan/f:contact/f:address">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.endpoint</sch:title>
    <sch:rule context="f:InsurancePlan/f:endpoint">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.network</sch:title>
    <sch:rule context="f:InsurancePlan/f:network">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.coverage.extension</sch:title>
    <sch:rule context="f:InsurancePlan/f:coverage/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.coverage.modifierExtension</sch:title>
    <sch:rule context="f:InsurancePlan/f:coverage/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.coverage.type</sch:title>
    <sch:rule context="f:InsurancePlan/f:coverage/f:type">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.coverage.network</sch:title>
    <sch:rule context="f:InsurancePlan/f:coverage/f:network">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.coverage.benefit.extension</sch:title>
    <sch:rule context="f:InsurancePlan/f:coverage/f:benefit/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.coverage.benefit.modifierExtension</sch:title>
    <sch:rule context="f:InsurancePlan/f:coverage/f:benefit/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.coverage.benefit.type</sch:title>
    <sch:rule context="f:InsurancePlan/f:coverage/f:benefit/f:type">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.coverage.benefit.requirement</sch:title>
    <sch:rule context="f:InsurancePlan/f:coverage/f:benefit/f:requirement">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.coverage.benefit.limit</sch:title>
    <sch:rule context="f:InsurancePlan/f:coverage/f:benefit/f:limit">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.coverage.benefit.limit.extension</sch:title>
    <sch:rule context="f:InsurancePlan/f:coverage/f:benefit/f:limit/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.coverage.benefit.limit.modifierExtension</sch:title>
    <sch:rule context="f:InsurancePlan/f:coverage/f:benefit/f:limit/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.coverage.benefit.limit.value</sch:title>
    <sch:rule context="f:InsurancePlan/f:coverage/f:benefit/f:limit/f:value">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.coverage.benefit.limit.code</sch:title>
    <sch:rule context="f:InsurancePlan/f:coverage/f:benefit/f:limit/f:code">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.extension</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.modifierExtension</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.identifier</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:identifier">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.type</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:type">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.coverageArea</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:coverageArea">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.network</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:network">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.generalCost</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:generalCost">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.generalCost.extension</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:generalCost/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.generalCost.modifierExtension</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:generalCost/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.generalCost.type</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:generalCost/f:type">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.generalCost.groupSize</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:generalCost/f:groupSize">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.generalCost.cost</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:generalCost/f:cost">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.generalCost.comment</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:generalCost/f:comment">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.specificCost</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:specificCost">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.specificCost.extension</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:specificCost/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.specificCost.modifierExtension</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:specificCost/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.specificCost.category</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:specificCost/f:category">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.specificCost.benefit</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:specificCost/f:benefit">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.specificCost.benefit.extension</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:specificCost/f:benefit/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.specificCost.benefit.modifierExtension</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:specificCost/f:benefit/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.specificCost.benefit.type</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:specificCost/f:benefit/f:type">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.specificCost.benefit.cost</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:specificCost/f:benefit/f:cost">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.specificCost.benefit.cost.extension</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:specificCost/f:benefit/f:cost/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.specificCost.benefit.cost.modifierExtension</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:specificCost/f:benefit/f:cost/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.specificCost.benefit.cost.type</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:specificCost/f:benefit/f:cost/f:type">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.specificCost.benefit.cost.applicability</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:specificCost/f:benefit/f:cost/f:applicability">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.specificCost.benefit.cost.qualifiers</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:specificCost/f:benefit/f:cost/f:qualifiers">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>InsurancePlan.plan.specificCost.benefit.cost.value</sch:title>
    <sch:rule context="f:InsurancePlan/f:plan/f:specificCost/f:benefit/f:cost/f:value">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
