<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile AdverseEvent
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:AdverseEvent</sch:title>
    <sch:rule context="f:AdverseEvent">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/ae-research-ig/StructureDefinition/caused-subject-to-discontinue-study']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/ae-research-ig/StructureDefinition/caused-subject-to-discontinue-study': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/ae-research-ig/StructureDefinition/ae-severity']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/ae-research-ig/StructureDefinition/ae-severity': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/ae-research-ig/StructureDefinition/ae-grade']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/ae-research-ig/StructureDefinition/ae-grade': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:seriousness) &gt;= 1">seriousness: minimum cardinality of 'seriousness' is 1</sch:assert>
      <sch:assert test="count(f:outcome) &gt;= 1">outcome: minimum cardinality of 'outcome' is 1</sch:assert>
      <sch:assert test="count(f:outcome) &lt;= 1">outcome: maximum cardinality of 'outcome' is 1</sch:assert>
      <sch:assert test="count(f:study) &gt;= 1">study: minimum cardinality of 'study' is 1</sch:assert>
      <sch:assert test="count(f:study) &lt;= 1">study: maximum cardinality of 'study' is 1</sch:assert>
      <sch:assert test="count(f:preventiveAction) &lt;= 0">preventiveAction: maximum cardinality of 'preventiveAction' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:AdverseEvent/f:suspectEntity</sch:title>
    <sch:rule context="f:AdverseEvent/f:suspectEntity">
      <sch:assert test="count(f:causality) &gt;= 1">causality: minimum cardinality of 'causality' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
