# V1.5 Change Log - Clinical Quality Language Specification v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Changes**](changes.md)
* **V1.5 Change Log**

## V1.5 Change Log

| | |
| :--- | :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): N/A |

**1.5 Change Log**

### Ballot Changes (v.1.5.0)

#### Normative Changes

##### Compatible, Substantive

* [STU4#1877](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1877): Added support for modular arithmetic for quantities
* [STU4#1896](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1896): Added an overload of expand to take a single interval
* [STU4#1917](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1917): Added a text/cql.identifier media type to support referencing the name of a defined CQL expression

##### Non-Substantive

* [STU4#1909](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1909): Added guidance on local terminology identifiers
* [STU4#1911](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1911): Clarified that unit conversion is supported with ConvertQuantity
* [STU4#1912](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1912): Clarified representation of seconds and milliseconds as a Decimal for the purposes of comparison
* [STU4#1916](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1916): Added guidance on direct-reference code usage

##### Errata

* [STU3#1875](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1875): Corrected error in Exists documentation
* [STU4#1857](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1857): Corrected error in ToString documentation
* [STU4#1858](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1858): Clarified relationship between CQL calendar duration units and UCUM definite-duration units
* [STU4#1862](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1862): Corrected rendering of formatting strings footnote throughout
* [STU4#1863](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1863): Clarified role of date and time token definitions in the grammar
* [STU4#1864](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1864): Updated typographical conventions for formatting strings throughout
* [STU4#1865](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1865): Clarified ranges for date/time formatting strings
* [STU4#1866](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1866): Clarified date/time arithmetic conversion semantics between UCUM and calendar duration units
* [STU4#1867](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1867): Clarified date/time arithmetic semantics for precisions above seconds
* [STU4#1869](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1869): Clarified date/time literal rules for timezoneoffset
* [STU4#1876](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1876): Fixed test for exists
* [STU4#1878](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1878): Clarified collapse and expand semantics with respect to per argument and interval boundary alignment
* [STU4#1881](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1881): Added point keyword to appropriate keyword lists
* [STU4#1882](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1882): Clarified semantics and behavior of terminology comparisons in retrieves
* [STU4#1883](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1883): Clarified inconsistent null semantics for point and singleton overloads of includes and included in as synonyms for in and contains
* [STU4#1884](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1884): Documented ToConcept(List`) overload`
* [STU4#1897](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1897): Clarified semantics and behavior of interval in and contains in the presence of interval boundaries that are both open and null
* [STU4#1913](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1913): Removed note about timezoneoffset in Time ELM operator
* [STU4#1914](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1914): Fixed rendering of footnote to formatting strings throughout
* [STU4#1915](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1915): Added guidance on local identifiers for code system, value set, and code declarations (duplicate of STU4#1909)
* [STU4#1919](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1919): Added missing Description header in documentation of ConvertQuantity and HighBoundary operators

#### Trial-Use Ballot Changes

##### Compatible, Substantive

* [STU4#1907](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1907): Added an aggregate clause to the query construct
* [STU4#1908](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1908): Added the ability to pass value sets and code systems as reference-type arguments
* [STU4#1910](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1910): Added support for specifying search paths in the Retrieve
* [STU4#1918](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1918): Added support for comment annotations that result in tags in the ELM output
* [STU4#1920](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1920): Added a fluent keyword to support fluent-style function invocation
* [STU4#1921](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1921): Added support for specifying include and reverseInclude elements in the Retrieve
* [STU4#1923](http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1923): Added System.Long to support 64-bit integers

### Release Changes (v1.5.1)

#### Normative Changes

##### Non-substantive

* [J#FHIR-27058](https://jira.hl7.org/browse/FHIR-27058): Clarified allowed terminology operations in the terminology target of a retrieve [View changes](https://github.com/HL7/cql/search?q=27058&type=commits)
* [J#FHIR-27059](https://jira.hl7.org/browse/FHIR-27059): Clarified equality and equivalent behavior between UCUM and calendar units [View changes](https://github.com/HL7/cql/search?q=adea3ea&type=commits)
* [J#FHIR-27060](https://jira.hl7.org/browse/FHIR-27060): Added discussion of quantity equivalent, equivalent, and comparison operators with respect to calendar and definite quantity duration units to the Appendix B reference documentation and logical specification. [View changes](https://github.com/HL7/cql/search?q=27060&type=commits)
* [J#FHIR-27062](https://jira.hl7.org/browse/FHIR-27062): Added implementer's note about models that may define implicit conversions from UCUM time-valued durations to CQL calendar durations [View changes](https://github.com/HL7/cql/search?q=27062&type=commits)
* [J#FHIR-27076](https://jira.hl7.org/browse/FHIR-27076): Allowed declarations in any order [View changes](https://github.com/HL7/cql/search?q=27076&type=commits)
* [J#FHIR-27081](https://jira.hl7.org/browse/FHIR-27081): Updated test reference specification to 1.5 [View changes](https://github.com/HL7/cql/search?q=27081&type=commits)
* [J#FHIR-27090](https://jira.hl7.org/browse/FHIR-27090): Added descriptions to the lists of tables and figures [View changes](https://github.com/HL7/cql/search?q=27090&type=commits)
* [J#FHIR-27099](https://jira.hl7.org/browse/FHIR-27099): Additional examples of time interval calculations to better illustrate semantics [View changes](https://github.com/HL7/cql/search?q=27099&type=commits)
* [J#FHIR-27440](https://jira.hl7.org/browse/FHIR-27440): Clarified description of tokens [View changes](https://github.com/HL7/cql/search?q=27440&type=commits)
* [J#FHIR-27448](https://jira.hl7.org/browse/FHIR-27448): Clarified description of escaping [View changes](https://github.com/HL7/cql/search?q=27448&type=commits)
* [J#FHIR-27450](https://jira.hl7.org/browse/FHIR-27450): Clarified description of date and time literals [View changes](https://github.com/HL7/cql/search?q=27450&type=commits)
* [J#FHIR-27452](https://jira.hl7.org/browse/FHIR-27452): Clarified description of binding [View changes](https://github.com/HL7/cql/search?q=27452&type=commits)
* [J#FHIR-27453](https://jira.hl7.org/browse/FHIR-27453): Clarified description of value set names [View changes](https://github.com/HL7/cql/search?q=27453&type=commits)
* [J#FHIR-27454](https://jira.hl7.org/browse/FHIR-27454): Clarified description of code systems [View changes](https://github.com/HL7/cql/search?q=27454&type=commits)
* [J#FHIR-27455](https://jira.hl7.org/browse/FHIR-27455): Clarified description of structured value selector semantics [View changes](https://github.com/HL7/cql/search?q=27455&type=commits)
* [J#FHIR-27456](https://jira.hl7.org/browse/FHIR-27456): Clarified description of point from semantics [View changes](https://github.com/HL7/cql/search?q=27456&type=commits)
* [J#FHIR-27457](https://jira.hl7.org/browse/FHIR-27457): Clarified return types in Table 2-H [View changes](https://github.com/HL7/cql/search?q=27457&type=commits)
* [J#FHIR-27458](https://jira.hl7.org/browse/FHIR-27458): Clarified description of duration units [View changes](https://github.com/HL7/cql/search?q=27458&type=commits)
* [J#FHIR-27459](https://jira.hl7.org/browse/FHIR-27459): Clarified description of calendar semantics [View changes](https://github.com/HL7/cql/search?q=27459&type=commits)
* [J#FHIR-27461](https://jira.hl7.org/browse/FHIR-27461): Clarified description of calendar months [View changes](https://github.com/HL7/cql/search?q=27461&type=commits)
* [J#FHIR-27466](https://jira.hl7.org/browse/FHIR-27466): Clarified description of quoted identifiers [View changes](https://github.com/HL7/cql/search?q=27466&type=commits)
* [J#FHIR-27467](https://jira.hl7.org/browse/FHIR-27467): Clarified description or return clause [View changes](https://github.com/HL7/cql/search?q=27467&type=commits)
* [J#FHIR-27468](https://jira.hl7.org/browse/FHIR-27468): Clarified description of sort clause [View changes](https://github.com/HL7/cql/search?q=27468&type=commits)
* [J#FHIR-27469](https://jira.hl7.org/browse/FHIR-27469): Added reference to Arithmetic Operators section [View changes](https://github.com/HL7/cql/search?q=27469&type=commits)
* [J#FHIR-27488](https://jira.hl7.org/browse/FHIR-27488): Clarified library containership semantics [View changes](https://github.com/HL7/cql/search?q=27488&type=commits)
* [J#FHIR-27489](https://jira.hl7.org/browse/FHIR-27489): Clarified context definition scope [View changes](https://github.com/HL7/cql/search?q=27489&type=commits)
* [J#FHIR-27490](https://jira.hl7.org/browse/FHIR-27490): Clarified description of function definitions [View changes](https://github.com/HL7/cql/search?q=27490&type=commits)
* [J#FHIR-27503](https://jira.hl7.org/browse/FHIR-27503): Clarified description of expression semantics [View changes](https://github.com/HL7/cql/search?q=27503&type=commits)
* [J#FHIR-27505](https://jira.hl7.org/browse/FHIR-27505): Document justification for called syntax [View changes](https://github.com/HL7/cql/search?q=27505&type=commits)
* [J#FHIR-27508](https://jira.hl7.org/browse/FHIR-27508): Clarified description of context declaration [View changes](https://github.com/HL7/cql/search?q=27508&type=commits)
* [J#FHIR-27510](https://jira.hl7.org/browse/FHIR-27510): Added links to and definition of symbols introduced in the retrieve terminology discussion. [View changes](https://github.com/HL7/cql/search?q=27510&type=commits)
* [J#FHIR-27511](https://jira.hl7.org/browse/FHIR-27511): Improved documentation of retrieve evaluation semantics [View changes](https://github.com/HL7/cql/search?q=27511&type=commits)
* [J#FHIR-27512](https://jira.hl7.org/browse/FHIR-27512): Clarified best practice for context declarations and cross-context expression references [View changes](https://github.com/HL7/cql/search?q=27512&type=commits)
* [J#FHIR-27513](https://jira.hl7.org/browse/FHIR-27513): Clarified retrieve expression documentation [View changes](https://github.com/HL7/cql/search?q=27513&type=commits)
* [J#FHIR-27515](https://jira.hl7.org/browse/FHIR-27515): Clarified description of null comparison semantics [View changes](https://github.com/HL7/cql/search?q=27515&type=commits)
* [J#FHIR-27516](https://jira.hl7.org/browse/FHIR-27516): Clarified description of distinct semantics [View changes](https://github.com/HL7/cql/search?q=27516&type=commits)
* [J#FHIR-27517](https://jira.hl7.org/browse/FHIR-27517): Clarified description of unsorted semantics [View changes](https://github.com/HL7/cql/search?q=27517&type=commits)
* [J#FHIR-27518](https://jira.hl7.org/browse/FHIR-27518): Clarified null sorting behavior documentation [View changes](https://github.com/HL7/cql/search?q=27518&type=commits)
* [J#FHIR-27520](https://jira.hl7.org/browse/FHIR-27520): Added reference to Timing Relationships discussion [View changes](https://github.com/HL7/cql/search?q=27520&type=commits)
* [J#FHIR-27943](https://jira.hl7.org/browse/FHIR-27943): Clarify decimal precision implementation expectations [View changes](https://github.com/HL7/cql/search?q=27943&type=commits)
* [J#FHIR-28072](https://jira.hl7.org/browse/FHIR-28072): Same as 27060 [View changes](https://github.com/HL7/cql/search?q=e5074be&type=commits)
* [J#FHIR-28074](https://jira.hl7.org/browse/FHIR-28074): Clarified decimal comparison semantics [View changes](https://github.com/HL7/cql/search?q=48d8635&type=commits)
* [J#FHIR-28113](https://jira.hl7.org/browse/FHIR-28113): Clarified timezone offset normalization behavior for date extractors [View changes](https://github.com/HL7/cql/search?q=28113&type=commits)

#### Trial-Use Changes

##### Non-substantive

* [J#FHIR-27067](https://jira.hl7.org/browse/FHIR-27067): Changed text for multi-line comments to not use the @@ delimiter [View changes](https://github.com/HL7/cql/search?q=27067&type=commits)
* [J#FHIR-27073](https://jira.hl7.org/browse/FHIR-27073): Simplified and expanded aggregate clause discussion [View changes](https://github.com/HL7/cql/search?q=27073&type=commits)
* [J#FHIR-27074](https://jira.hl7.org/browse/FHIR-27074): Expanded documentation of the aggregate clause [View changes](https://github.com/HL7/cql/search?q=27074&type=commits)
* [J#FHIR-27075](https://jira.hl7.org/browse/FHIR-27075): Clarified documentation of multiple-argument fluent functions [View changes](https://github.com/HL7/cql/search?q=27075&type=commits)
* [J#FHIR-27077](https://jira.hl7.org/browse/FHIR-27077): Expanded search path documentation [View changes](https://github.com/HL7/cql/search?q=27077&type=commits)
* [J#FHIR-27078](https://jira.hl7.org/browse/FHIR-27078): Clarified that search parameter elements are Trial-Use [View changes](https://github.com/HL7/cql/search?q=655b234&type=commits)
* [J#FHIR-27079](https://jira.hl7.org/browse/FHIR-27079): Clarified that include and reverseInclude are Trial-Use [View changes](https://github.com/HL7/cql/search?q=655b234&type=commits)
* [J#FHIR-27102](https://jira.hl7.org/browse/FHIR-27102): Expanded documentation of fluent functions [View changes](https://github.com/HL7/cql/search?q=27102&type=commits)

#### Informative Changes

##### Non-substantive

* [J#FHIR-27080](https://jira.hl7.org/browse/FHIR-27080): Clarified trial-use vs normative changes in the change log [View changes](https://github.com/HL7/cql/search?q=27080&type=commits)
* [J#FHIR-27439](https://jira.hl7.org/browse/FHIR-27439): Updated reference implementation references [View changes](https://github.com/HL7/cql/search?q=27439&type=commits)
* [J#FHIR-27441](https://jira.hl7.org/browse/FHIR-27441): Clarified description of expressions [View changes](https://github.com/HL7/cql/search?q=27441&type=commits)
* [J#FHIR-27442](https://jira.hl7.org/browse/FHIR-27442): Clarified description of organization [View changes](https://github.com/HL7/cql/search?q=27442&type=commits)
* [J#FHIR-27444](https://jira.hl7.org/browse/FHIR-27444): Clarified description of clauses [View changes](https://github.com/HL7/cql/search?q=c2139a4&type=commits)
* [J#FHIR-27445](https://jira.hl7.org/browse/FHIR-27445): Clarified description of meaningful [View changes](https://github.com/HL7/cql/search?q=27445&type=commits)
* [J#FHIR-27446](https://jira.hl7.org/browse/FHIR-27446): Added references to Comparison and Logical operators [View changes](https://github.com/HL7/cql/search?q=27446&type=commits)
* [J#FHIR-27447](https://jira.hl7.org/browse/FHIR-27447): Added references to Arithmetic operators [View changes](https://github.com/HL7/cql/search?q=27447&type=commits)
* [J#FHIR-27465](https://jira.hl7.org/browse/FHIR-27465): Clarified description of terminology example [View changes](https://github.com/HL7/cql/search?q=27465&type=commits)
* [J#FHIR-27473](https://jira.hl7.org/browse/FHIR-27473): Added libraryId and libraryVersion to error annotation information [View changes](https://github.com/HL7/cql/search?q=b0dbd73&type=commits)
* [J#FHIR-27476](https://jira.hl7.org/browse/FHIR-27476): Improved image resolution of Figure 1-A [View changes](https://github.com/HL7/cql/search?q=27476&type=commits)
* [J#FHIR-27479](https://jira.hl7.org/browse/FHIR-27479): Documented community adoption and added language capabilities listing [View changes](https://github.com/HL7/cql/search?q=27479&type=commits)
* [J#FHIR-27480](https://jira.hl7.org/browse/FHIR-27480): Added captions for tables and figures throughout [View changes](https://github.com/HL7/cql/search?q=27480&type=commits)
* [J#FHIR-27482](https://jira.hl7.org/browse/FHIR-27482): Improved quality of Figure 1-A [View changes](https://github.com/HL7/cql/search?q=f18392f&type=commits)
* [J#FHIR-27484](https://jira.hl7.org/browse/FHIR-27484): Clarified documentation of target scope [View changes](https://github.com/HL7/cql/search?q=27484&type=commits)
* [J#FHIR-27485](https://jira.hl7.org/browse/FHIR-27485): Added missing link to HQMF specification [View changes](https://github.com/HL7/cql/search?q=27485&type=commits)
* [J#FHIR-27486](https://jira.hl7.org/browse/FHIR-27486): Added description of ANTLR4 [View changes](https://github.com/HL7/cql/search?q=27486&type=commits)
* [J#FHIR-27487](https://jira.hl7.org/browse/FHIR-27487): Added missing links to referenced specifications [View changes](https://github.com/HL7/cql/search?q=27487&type=commits)
* [J#FHIR-27492](https://jira.hl7.org/browse/FHIR-27492): Added example data model with version [View changes](https://github.com/HL7/cql/search?q=27492&type=commits)
* [J#FHIR-27494](https://jira.hl7.org/browse/FHIR-27494): Clarified description of terminology example [View changes](https://github.com/HL7/cql/search?q=27494&type=commits)
* [J#FHIR-27495](https://jira.hl7.org/browse/FHIR-27495): Clarified reference to QUICK and QI-Core [View changes](https://github.com/HL7/cql/search?q=27495&type=commits)
* [J#FHIR-27496](https://jira.hl7.org/browse/FHIR-27496): Clarified documentation of target domain [View changes](https://github.com/HL7/cql/search?q=27496&type=commits)
* [J#FHIR-27497](https://jira.hl7.org/browse/FHIR-27497): Clarified documentation of architectural layers [View changes](https://github.com/HL7/cql/search?q=27497&type=commits)
* [J#FHIR-27498](https://jira.hl7.org/browse/FHIR-27498): Improved content and documentation of Figure 1-B [View changes](https://github.com/HL7/cql/search?q=27498&type=commits)
* [J#FHIR-27499](https://jira.hl7.org/browse/FHIR-27499): Improved documentation of justification for ELM [View changes](https://github.com/HL7/cql/search?q=27499&type=commits)
* [J#FHIR-27500](https://jira.hl7.org/browse/FHIR-27500): Clarified justification for parentheses [View changes](https://github.com/HL7/cql/search?q=27500&type=commits)
* [J#FHIR-27502](https://jira.hl7.org/browse/FHIR-27502): Clarified documentation of language background [View changes](https://github.com/HL7/cql/search?q=27502&type=commits)
* [J#FHIR-27504](https://jira.hl7.org/browse/FHIR-27504): Clarified documentation of include declarations [View changes](https://github.com/HL7/cql/search?q=27504&type=commits)
* [J#FHIR-27507](https://jira.hl7.org/browse/FHIR-27507): Added reference to Terminology operators [View changes](https://github.com/HL7/cql/search?q=27507&type=commits)
* [J#FHIR-27509](https://jira.hl7.org/browse/FHIR-27509): Added a diagram to more clearly illustrate the notion of contexts [View changes](https://github.com/HL7/cql/search?q=27059&type=commits)
* [J#FHIR-27514](https://jira.hl7.org/browse/FHIR-27514): Added syntax diagrams as an Appendix and linked throughout [View changes](https://github.com/HL7/cql/search?q=27514&type=commits)
* [J#FHIR-27519](https://jira.hl7.org/browse/FHIR-27519): Added simple patient information model to illustrate example queries [View changes](https://github.com/HL7/cql/search?q=27519&type=commits)
* [J#FHIR-27522](https://jira.hl7.org/browse/FHIR-27522): Added use of quoted-identifiers to examples throughout [View changes](https://github.com/HL7/cql/search?q=27522&type=commits)
* [J#FHIR-27894](https://jira.hl7.org/browse/FHIR-27894): Added target attributes to support additional mapping capabilities in model info [View changes](https://github.com/HL7/cql/search?q=27894&type=commits)

#### Errata

* [J#FHIR-27061](https://jira.hl7.org/browse/FHIR-27061): Same as 28438 [View changes](https://github.com/HL7/cql/search?q=f2e7fb2&type=commits)
* [J#FHIR-27063](https://jira.hl7.org/browse/FHIR-27063): Corrected examples of "last day of month" behavior for date arithmetic [View changes](https://github.com/HL7/cql/search?q=39ca51e&type=commits)
* [J#FHIR-27064](https://jira.hl7.org/browse/FHIR-27064): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27064&type=commits)
* [J#FHIR-27068](https://jira.hl7.org/browse/FHIR-27068): Corrected example [View changes](https://github.com/HL7/cql/search?q=27068&type=commits)
* [J#FHIR-27070](https://jira.hl7.org/browse/FHIR-27070): Updated references to initial patient population to initial population throughout [View changes](https://github.com/HL7/cql/search?q=27070&type=commits)
* [J#FHIR-27100](https://jira.hl7.org/browse/FHIR-27100): Corrected inconsistent timezone offset range [View changes](https://github.com/HL7/cql/search?q=27100&type=commits)
* [J#FHIR-27443](https://jira.hl7.org/browse/FHIR-27443): Fixed comma [View changes](https://github.com/HL7/cql/search?q=27443&type=commits)
* [J#FHIR-27449](https://jira.hl7.org/browse/FHIR-27449): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27449&type=commits)
* [J#FHIR-27451](https://jira.hl7.org/browse/FHIR-27451): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27451&type=commits)
* [J#FHIR-27460](https://jira.hl7.org/browse/FHIR-27460): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27460&type=commits)
* [J#FHIR-27463](https://jira.hl7.org/browse/FHIR-27463): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27463&type=commits)
* [J#FHIR-27464](https://jira.hl7.org/browse/FHIR-27464): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27464&type=commits)
* [J#FHIR-27470](https://jira.hl7.org/browse/FHIR-27470): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27470&type=commits)
* [J#FHIR-27471](https://jira.hl7.org/browse/FHIR-27471): Fixed formatting [View changes](https://github.com/HL7/cql/search?q=27471&type=commits)
* [J#FHIR-27472](https://jira.hl7.org/browse/FHIR-27472): Fixed formatting [View changes](https://github.com/HL7/cql/search?q=27472&type=commits)
* [J#FHIR-27475](https://jira.hl7.org/browse/FHIR-27475): Fixed hyperlinks [View changes](https://github.com/HL7/cql/search?q=27475&type=commits)
* [J#FHIR-27477](https://jira.hl7.org/browse/FHIR-27477): Fixed section reference [View changes](https://github.com/HL7/cql/search?q=27477&type=commits)
* [J#FHIR-27478](https://jira.hl7.org/browse/FHIR-27478): Corrected chapter reference [View changes](https://github.com/HL7/cql/search?q=27478&type=commits)
* [J#FHIR-27481](https://jira.hl7.org/browse/FHIR-27481): Added references to Table 1-A [View changes](https://github.com/HL7/cql/search?q=27481&type=commits)
* [J#FHIR-27483](https://jira.hl7.org/browse/FHIR-27483): Fixed typo [View changes](https://github.com/HL7/cql/search?q=27483&type=commits)
* [J#FHIR-27493](https://jira.hl7.org/browse/FHIR-27493): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27493&type=commits)
* [J#FHIR-27506](https://jira.hl7.org/browse/FHIR-27506): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27506&type=commits)
* [J#FHIR-27521](https://jira.hl7.org/browse/FHIR-27521): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27521&type=commits)
* [J#FHIR-27523](https://jira.hl7.org/browse/FHIR-27523): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27523&type=commits)
* [J#FHIR-27524](https://jira.hl7.org/browse/FHIR-27524): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27524&type=commits)
* [J#FHIR-27525](https://jira.hl7.org/browse/FHIR-27525): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27525&type=commits)
* [J#FHIR-27526](https://jira.hl7.org/browse/FHIR-27526): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27526&type=commits)
* [J#FHIR-27527](https://jira.hl7.org/browse/FHIR-27527): Fixed capitalization [View changes](https://github.com/HL7/cql/search?q=27527&type=commits)
* [J#FHIR-27528](https://jira.hl7.org/browse/FHIR-27528): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27528&type=commits)
* [J#FHIR-27529](https://jira.hl7.org/browse/FHIR-27529): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27529&type=commits)
* [J#FHIR-27530](https://jira.hl7.org/browse/FHIR-27530): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27530&type=commits)
* [J#FHIR-27531](https://jira.hl7.org/browse/FHIR-27531): Fixed spelling [View changes](https://github.com/HL7/cql/search?q=27531&type=commits)
* [J#FHIR-28438](https://jira.hl7.org/browse/FHIR-28438): Aligned with FHIRPath to consider calendar durations above weeks, rather than above seconds, uncomparable with definite-time duration [View changes](https://github.com/HL7/cql/search?q=f2e7fb2&type=commits)
* [J#FHIR-29552](https://jira.hl7.org/browse/FHIR-29552): Provided example of access to interval properties [View changes](https://github.com/HL7/cql/search?q=29552&type=commits)
* [J#FHIR-29931](https://jira.hl7.org/browse/FHIR-29931): Corrected media types for cql.identifier and cql.expression to cql-identifier and cql-expression based on IANA feedback [View changes](https://github.com/HL7/cql/search?q=29931&type=commits)
* [J#FHIR-29932](https://jira.hl7.org/browse/FHIR-29932): Fixed backwards compatibility for TimezoneFrom [View changes](https://github.com/HL7/cql/search?q=29932&type=commits)
* [J#FHIR-29934](https://jira.hl7.org/browse/FHIR-29934): Corrected type of target attribute in model info [View changes](https://github.com/HL7/cql/search?q=29934&type=commits)

### Errata 1 Changes (v1.5.2)

#### Trial-Use Changes

##### Compatible, Substantive

* [FHIR-32666](https://jira.hl7.org/browse/FHIR-32666): Add version parameter for media types
* [FHIR-34804](https://jira.hl7.org/browse/FHIR-34804): Improve backwards compatibility support for terminology types

#### Normative Changes

##### Non-substantive

* [FHIR-35869](https://jira.hl7.org/browse/FHIR-35869): Inconsistent description of ToDateTime operator
* [FHIR-32951](https://jira.hl7.org/browse/FHIR-32951): Function-style invocation of keyword operators is not documented
* [FHIR-32950](https://jira.hl7.org/browse/FHIR-32950): Interval overload of between is not documented
* [FHIR-35926](https://jira.hl7.org/browse/FHIR-35926): Clarify Quantity Predecessor/Successor behavior
* [FHIR-35925](https://jira.hl7.org/browse/FHIR-35925): Correct missing quantity overloads in Logical Specification
* [FHIR-35917](https://jira.hl7.org/browse/FHIR-35917): Fix missing IdentifierRef documentation
* [FHIR-35915](https://jira.hl7.org/browse/FHIR-35915): Clarify interval computation semantics with open null boundaries
* [FHIR-35909](https://jira.hl7.org/browse/FHIR-35909): Add a clarifying example to the uncertainty calculation discussion
* [FHIR-35905](https://jira.hl7.org/browse/FHIR-35905): Clarify the result of a DateTime with all null components
* [FHIR-35904](https://jira.hl7.org/browse/FHIR-35904): Clarify equality semantics exception for nulls
* [FHIR-32971](https://jira.hl7.org/browse/FHIR-32971): Use codeSystemEx and valueSetEx elements in value set membership operations

#### Informative Changes

* [FHIR-28127](https://jira.hl7.org/browse/FHIR-28127): Incorrect test case for single-source query sort
* [FHIR-31883](https://jira.hl7.org/browse/FHIR-31883): Diagram of interval operators uses "begins"
* [FHIR-35881](https://jira.hl7.org/browse/FHIR-35881): Document that test cases are built to be run with an evaluation timestamp of UTC
* [FHIR-35918](https://jira.hl7.org/browse/FHIR-35918): Add a best-practice about the use of equivalent rather than equal for terminology comparison
* [FHIR-34199](https://jira.hl7.org/browse/FHIR-34199): Document cql-options that affect language behavior
* [FHIR-32679](https://jira.hl7.org/browse/FHIR-32679): Compile specific behavior differences between 1.3/1.4/1.5
* [FHIR-30081](https://jira.hl7.org/browse/FHIR-30081): Errors in test cases

### Errata 2 Changes (v1.5.3)

#### Non-substantive

* [FHIR-48757](https://jira.hl7.org/browse/FHIR-48757): Corrected precedence of FHIRPath | and infix set operators
* [FHIR-48530](https://jira.hl7.org/browse/FHIR-48530): Clarified timezone offset defaulting semantics in the DateTime type
* [FHIR-48482](https://jira.hl7.org/browse/FHIR-48482): Clarified seconds and milliseconds are a single precision in duration and difference calculations
* [FHIR-46707](https://jira.hl7.org/browse/FHIR-46707): Publication uplift to latest tooling (no material changes)
* [FHIR-46675](https://jira.hl7.org/browse/FHIR-46675): Clarified during operator synonyms in the reference
* [FHIR-46483](https://jira.hl7.org/browse/FHIR-46483): Corrected spelling of descendants operator as specified in FHIRPath
* [FHIR-46437](https://jira.hl7.org/browse/FHIR-46437): Added documentation about accessibility of $this and $index elements in sort expressions
* [FHIR-46436](https://jira.hl7.org/browse/FHIR-46436): Clarified identifier hiding semantics
* [FHIR-46435](https://jira.hl7.org/browse/FHIR-46435): Clarified implicit system model resolution semantics
* [FHIR-46434](https://jira.hl7.org/browse/FHIR-46434): Corrected inconsistent descriptions of combine semantics
* [FHIR-46426](https://jira.hl7.org/browse/FHIR-46426): Added missing mapping for union in FHIRPath
* [FHIR-46363](https://jira.hl7.org/browse/FHIR-46363): Clarified semantics of null for list membership determination in IndexOf and Equal
* [FHIR-46362](https://jira.hl7.org/browse/FHIR-46362): Clarified behavior of equivalent with respect to empty lists and strings
* [FHIR-46360](https://jira.hl7.org/browse/FHIR-46360): Clarified concept equivalence semantics
* [FHIR-46345](https://jira.hl7.org/browse/FHIR-46345): Clarified implicit system model resolution semantics
* [FHIR-46283](https://jira.hl7.org/browse/FHIR-46283): Clarified null behavior for properly includes and included in
* [FHIR-46051](https://jira.hl7.org/browse/FHIR-46051): Corrected description of meets and overlaps operators
* [FHIR-46053](https://jira.hl7.org/browse/FHIR-46053): Clarified semantics of is operator and linked to type testing discussion
* [FHIR-45987](https://jira.hl7.org/browse/FHIR-45987): Clarified round semantics
* [FHIR-45913](https://jira.hl7.org/browse/FHIR-45913): Fixed formatting of implicit conversions table
* [FHIR-45911](https://jira.hl7.org/browse/FHIR-45911): Added missing equivalent and not-equivalent symbols to the symbols table
* [FHIR-44921](https://jira.hl7.org/browse/FHIR-44921): Clarified tuple equality semantics with missing elements
* [FHIR-44830](https://jira.hl7.org/browse/FHIR-44830): Corrected day formatting range (01..31)
* [FHIR-44783](https://jira.hl7.org/browse/FHIR-44783): Clarified type compatibility in conversion precedence
* [FHIR-44780](https://jira.hl7.org/browse/FHIR-44780): Added missing Long overloads for ToQuantity conversions
* [FHIR-44826](https://jira.hl7.org/browse/FHIR-44826): Clarified regular expression matching behavior
* [FHIR-41489](https://jira.hl7.org/browse/FHIR-41489): Corrected inconsistent statements about overflow/underflow with successor and predecessor
* [FHIR-40225](https://jira.hl7.org/browse/FHIR-40225): Clarified query type inference and null evaluation semantics
* [FHIR-36050](https://jira.hl7.org/browse/FHIR-36050): Corrected links to raw g4 grammar files

