# V1.3 Change Log - Clinical Quality Language Specification v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Changes**](changes.md)
* **V1.3 Change Log**

## V1.3 Change Log

| | |
| :--- | :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): N/A |

**1.3 Change Log**

### STU3 Reconciliation Changes

This changelist describes the substantive changes, as well as a handful of more significant changes to the specification as a result of STU 3 comment reconciliation. For a complete list of changes, refer to the repository commit history and the ballot reconciliation spreadsheet.

* #30: Updated terminology identifiers to use URIs in examples throughout
* #36: Added discussion of code and concept declarations and literals
* #42: Specified duration of year as 365 days and month as 30 days when there is no anchor
* #43: Clarified that timezone offset normalization should only apply for time-based precisions
* #47: Added Date overloads for CalculateAge operators in ELM and CQL; AgeInYears and AgeInMonths use Date, AgeInWeeks and finer use DateTime
* #48: Added examples of Date-interval with open/closed boundaries
* #57: Added guidance on use of external functions
* #61: Added examples throughout
* #65: Added documentation of formatting strings
* #67: Clarified behavior of precision with between and other date/time functions
* #72: Added SplitOnMatches operator
* #73: Added discussion of potential pitfalls with uncertainty and date/time arithmetic
* #75: Added Concept overload for Equivalence
* #101: Updated ELM model
* #167: Clarified mixed-type signatures for interval and date/time operators and the semantics for interval promotion/demotion and when they are used
* #207: Added OperatorExpression type in ELM
* #214: Align with the FHIRPath normative ballot
* #215: Remove the ability to extract a week component
* #216: Remove the ability to say "same week as"
* #211: Symbolic date/time comparisons now occur at finest precision specified in either input
* #212: Remove unnecessary overloads of Divide and Multiply
* #217: Added choice-casting and interval promotion/demotion to conversion precedence
* #218: Added discussion of the option to require the from keyword for all queries
* #219: Changed date/time equality/comparison to return null only if the values have different levels of precision
* #220: Changed tuple equality to return null only if the values have different elements specified
* #221: Changed list membership and duplicate detection semantics throughout to use equality instead of equivalence
* #222: Add a per clause to the collapse operator

### STU 3 Ballot Changes

* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1377[1377]: Corrected link to Type Operators section
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1378[1378]: Corrected link to Type Operators section
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1379[1379]: Improved formatting for table 9-E
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1432[1432]: Added signature element to FunctionRef ELM type
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1433[1433]: Clarified that on and same are synonyms in timing phrases
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1434[1434]: Relaxed quantity operation semantics to return null rather than raise an error for invalid quantity operations
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1435[1435]: Exists operator now ignores null elements in lists
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1436[1436]: Clarified aliases are not allowed in sort clauses
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1437[1437]: Added Ratio system-defined type
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1438[1438]: Fixed take() FHIRPath mapping
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1439[1439]: Added difference of and duration between operators
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1440[1440]: Require case-sensitivity for UCUM units
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1441[1441]: Added clarifying guidance regarding date/time calculations involving date/time values with different timezone offsets
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1442[1442]: Division of like quantities results in a quantity with the default UCUM unit ('1')
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1443[1443]: Added implicit conversion from Integer or Decimal to Quantity
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1444[1444]: Added Date system-defined type
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1445[1445]: Clarified singular and UCUM temporal units are allowed for date/time arithmetic
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1446[1446]: Changed conversion of List`to Concept from implicit to explicit`
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1447[1447]: Added overloads of In to support List``
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1475[1475]: Clarified set semantics of intersect and except
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1478[1478]: Clarified timezone offset handling for difference calculations
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1479[1479]: Clarified calendar semantics for date/time arithmetic, even when using UCUM time-period units
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1483[1483]: BinaryExpression and TernaryExpression ELM types are now abstract
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1500[1500]: Union, Intersect, and Except are now NaryExpressions
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1507[1507]: Generalized named type specifier rule to allow for multiple-qualifier type names
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1509[1509]: Clarified case-insensitive behavior of string comparison
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1538[1538]: Clarified instance selector behavior for missing elements
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1539[1539]: Clarified behavior of a quantity with a null unit
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1540[1540]: Corrected ELM documentation for IdentifierRef
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1541[1541]: Added support for Product and GeometricMean aggregate operators
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1542[1542]: Added support for Expand interval set operator
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1549[1549]: Publish CQL as a web-based specification
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1552[1552]: Clarified that ELM and CQL do not prescribe short-circuit evaluation
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1553[1553]: Clarified that parameter defaults must be compile-time evaluable
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1555[1555]: Relaxed semantics of conversion failures to return null instead of run-time errors
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1556[1556]: Clarify semantics for string overload of valueset membership operator (in)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1560[1560]: Corrected population context example
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1561[1561]: Added singleton overloads for included in and includes
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1569[1569]: Corrected missing operators in operator precedence chart
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1574[1574]: Clarified null-handling behavior for in and contains
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1579[1579]: Added FHIRPath changes: Mappings for hasValue, conformsTo, memberOf, subsumes, subsumedBy, toChars, and aggregate; added $index and $total iterators
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1580[1580]: Changed ELM serialization to avoid type clash with JSON serializers

