# CQL Specification - Clinical Quality Language Specification v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **CQL Specification**

## CQL Specification

| | |
| :--- | :--- |
| *Official URL*:http://cql.hl7.org/ImplementationGuide/hl7.cql | *Version*:2.0.0-ballot |
| Active as of 2025-10-24 | *Computable Name*:CQL |

### Clinical Quality Language (CQL)

**HL7 Standard: Clinical Quality Language Specification, Release 2 Trial-Use Ballot (CQL 2.0.0-ballot)**

**HL7 Trial-Use Specification**

> This is a trial-use ballot of the CQL specification that introduces substantive new features, numerous corrections, clarifications, and enhancements, and no breaking changes. Normative elements of the specification remain normative from a maturity perspective (i.e. normative aspects of the specification will not change in backwards-incompatible ways). New content introduced in this trial-use are marked as such, and trial-use content that was introduced in 1.5 remains trial-use in this version.

Clinical Quality Language (CQL) is a high-level, domain-specific language focused on clinical quality and targeted at measure and decision support artifact authors.

In addition, this specification describes a machine-readable canonical representation called Expression Logical Model (ELM) targeted at implementations and designed to enable sharing of clinical knowledge.

> For a complete description of the changes to this version, please review the[version history](http://cql.hl7.org/history.html).

| | | | |
| :--- | :--- | :--- | :--- |
| [Title Page](title.md) | [License](license.md) | [Version History](http://cql.hl7.org/history.html) | [Executive Summary](00-executivesummary.md) |

#### Getting Started

Welcome to the HL7 Clinical Quality Language (CQL) specification!

CQL has matured into a capable and flexible specification for representing clinically-focused logic, and is being used in a broad variety of applications from cohort definition and quality measurement, to clinical decision and cognitive support, computable guidelines, and public health reporting. See the [Examples](examples.md) page for examples of these various usages, and be sure to visit the [Reference Implementations](10-c-referenceimplementations.md) page for a description of the available tooling and resources, as well as a link to community projects.

To join the active and growing community of CQL authors and implementers, subscribe to the [CQL stream](https://chat.fhir.org/#narrow/stream/179220-cql) on the FHIR Zulip. As with any HL7 specification, we welcome continued feedback and are constantly striving to improve. If you have comments or suggestions, or even just notice a typo, please let us know by submitting an issue via the [HL7 JIRA](http://jira.hl7.org), just set the "Project" to FHIR and the "Specification" to "Clinical Quality Language" in the issue you submit.

#### Organization of this Specification

The organization of this specification follows the outline of the perspectives discussed in the Approach section—conceptual, logical, and physical. Below is a listing of the chapters with a short summary of the content of each.

[Chapter 1](01-introduction.md) – Introduction provides introductory and background material for the specification.

[Chapter 2](02-authorsguide.md) – Author’s Guide provides a high-level discussion of the Clinical Quality Language syntax. This discussion is a self-contained introduction to the language targeted at clinical quality authors.

[Chapter 3](03-developersguide.md) – Developer’s Guide provides a more in-depth look at the Clinical Quality Language targeted at developers familiar with typical development languages such as Java, C#, and SQL.

[Chapter 4](04-logicalspecification.md) – Logical Specification provides a complete description of the elements that can be used to represent quality logic. Note that Chapters 2 and 3 describe the same functional capabilities of the language, and that anything that can be expressed in one mechanism can be equivalently expressed in the other.

[Chapter 5](05-languagesemantics.md) – Language Semantics describes the intended semantics of the language, covering topics such as data layer integration and expected run-time behavior.

[Chapter 6](06-translationsemantics.md) – Translation Semantics describes the mapping between CQL and ELM, as well as outlines for how to perform translation from CQL to ELM, and vice versa.

[Chapter 7](07-physicalrepresentation.md) – Physical Representation is reference documentation for the XML schema used to persist ELM.

[Appendix A](08-a-cqlsyntax.md) – CQL Syntax Formal Specification discusses the ANTLR4 grammar for the Clinical Quality Language.

[Appendix B](09-b-cqlreference.md) – CQL Reference provides a complete reference for the types and operators available in CQL, and is intended to be used by authors and developers alike.

[Appendix C](10-c-referenceimplementations.md) – Reference Implementations provides information about where to find reference implementations for a CQL-ELM translator, a CQL Execution Framework for JavaScript, and other related tooling.

[Appendix D](11-d-references.md) – References

[Appendix E](12-e-acronyms.md) – Acronyms

[Appendix F](13-f-glossary.md) – Glossary

[Appendix G](14-g-formattingconventions.md) – Conventions

[Appendix H](15-h-timeintervalcalculations.md) – Timing Interval Calculation Examples

[Appendix I](16-i-fhirpathtranslation.md) – FHIRPath Function Translation

[Appendix J](17-j-listoftables.md) – List Of Tables

[Appendix K](18-k-listoffigures.md) – List Of Figures

[Appendix L](19-l-cqlsyntaxdiagrams.md) - CQL Syntax Diagrams

[Appendix M](20-m-messages.md) - Messages Index

#### Dependencies

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.cql.r4)](package.r4.tgz) and [R4B (hl7.cql.r4b)](package.r4b.tgz) are available.

#### Global Profiles

*There are no Global profiles defined*

