# CQL Message Characteristic Codes - Clinical Quality Language Specification v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CQL Message Characteristic Codes**

## CodeSystem: CQL Message Characteristic Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://cql.hl7.org/CodeSystem/cql-message-characteristic-codes | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CQLMessageCharacteristicCodes |

 
Codes for characteristics of messages returned by applications that process Clinical Quality Language. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CQLMessageCharacteristic](ValueSet-cql-message-characteristic.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cql-message-characteristic-codes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://cql.hl7.org/CodeSystem/cql-message-characteristic-codes",
  "version" : "2.0.0-ballot",
  "name" : "CQLMessageCharacteristicCodes",
  "title" : "CQL Message Characteristic Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-24T16:45:25+00:00",
  "publisher" : "Clinical Decision Support WG",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/dss/index.cfm"
        }
      ]
    }
  ],
  "description" : "Codes for characteristics of messages returned by applications that process Clinical Quality Language.",
  "caseSensitive" : true,
  "valueSet" : "http://cql.hl7.org/ValueSet/cql-message-characteristic",
  "content" : "complete",
  "concept" : [
    {
      "code" : "category",
      "display" : "Category",
      "definition" : "The language area, possible values are codes in the [CQL Message Category Codes](CodeSystem-cql-message-category-codes.html) code system."
    },
    {
      "code" : "severity",
      "display" : "Severity",
      "definition" : "Severity of the issue, possible values are codes in the [CQL Message Severity Codes](CodeSystem-cql-message-severity-codes.html) code system."
    },
    {
      "code" : "source",
      "display" : "Source",
      "definition" : "The source of the issue, providing information about where the issue is originating and how it might be addressed, possible values are codes in the [CQL Message Source Codes](CodeSystem-cql-message-source-codes.html) code system."
    },
    {
      "code" : "example",
      "display" : "Example Message",
      "definition" : "An example message providing a sample of what kinds of actual messages will be returned with this code."
    },
    {
      "code" : "notes",
      "display" : "Notes",
      "definition" : "Notes about the message, especially how to address the issue being identified."
    },
    {
      "code" : "spec-link",
      "display" : "Specification Link",
      "definition" : "A URL to the point in the specification where this message is defined."
    }
  ]
}

```
