# CQL Capability Characteristic Codes - Clinical Quality Language Specification v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CQL Capability Characteristic Codes**

## CodeSystem: CQL Capability Characteristic Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://cql.hl7.org/CodeSystem/cql-capability-characteristic-codes | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CQLCapabilityCharacteristicCodes |

 
Codes for CQL versions. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CQLCapabilityCharacteristicCodes](ValueSet-cql-capability-characteristic-codes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cql-capability-characteristic-codes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://cql.hl7.org/CodeSystem/cql-capability-characteristic-codes",
  "version" : "2.0.0-ballot",
  "name" : "CQLCapabilityCharacteristicCodes",
  "title" : "CQL Capability Characteristic Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-24T16:45:25+00:00",
  "publisher" : "Clinical Decision Support WG",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/dss/index.cfm"
        }
      ]
    }
  ],
  "description" : "Codes for CQL versions.",
  "caseSensitive" : true,
  "valueSet" : "http://cql.hl7.org/ValueSet/cql-capability-characteristic-codes",
  "content" : "complete",
  "concept" : [
    {
      "code" : "version",
      "display" : "Version",
      "definition" : "The version of FHIRPath in which the features being tested were introduced. This should correspond to a published or planned published version of FHIRPath."
    },
    {
      "code" : "versionTo",
      "display" : "VersionTo",
      "definition" : "The last version of the specification in which the features being tested appears."
    },
    {
      "code" : "value",
      "display" : "Value",
      "definition" : "A qualifier value used to provide more detail about the capability."
    },
    {
      "code" : "valueMeaning",
      "display" : "Value Meaning",
      "definition" : "A description of the meaning of qualifier values for the capability."
    },
    {
      "code" : "reference",
      "display" : "Reference",
      "definition" : "A reference to the specification documenting this capability."
    }
  ]
}

```
