# Appendix L - CQL Syntax Diagrams - Clinical Quality Language Specification v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**CQL Specification**](index.md)
* **Appendix L - CQL Syntax Diagrams**

## Appendix L - CQL Syntax Diagrams

| | |
| :--- | :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): N/A |

These diagrams provide an alternative, visual representation of the CQL grammar. Note that the grammar represented here is simplified for the purposes of presentation. Some semantics such as operator precedence are encoded in the full grammar, but omitted here. As such, the contents of this page (and the railroad diagrams included in the rest of the specification) are strictly informative.

| | |
| :--- | :--- |
| #### directive |  |
| #### library |  |
| #### libraryDefinition |  |
| #### definition |  |
| #### usingDefinition |  |
| #### includeDefinition |  |
| #### accessModifier |  |
| #### parameterDefinition |  |
| #### codesystemDefinition |  |
| #### valuesetDefinition |  |
| #### codesystems |  |
| #### codeDefinition |  |
| #### conceptDefinition |  |
| #### typeSpecifier |  |
| #### namedTypeSpecifier |  |
| #### listTypeSpecifier |  |
| #### intervalTypeSpecifier |  |
| #### tupleTypeSpecifier |  |
| #### tupleElementDefinition |  |
| #### choiceTypeSpecifier |  |
| #### statement |  |
| #### expressionDefinition |  |
| #### contextDefinition |  |
| #### functionDefinition |  |
| #### operandList |  |
| #### operandDefinition |  |
| #### functionBody |  |
| #### contextInfoDefinition |  |
| #### typeInfoDefinition |  |
| #### baseTypeSpecifier |  |
| #### typeElements |  |
| #### typeElementDefinition |  |
| #### typeInfo |  |
| #### contextRelationship |  |
| #### conversionInfoDefinition |  |
| #### querySource |  |
| #### aliasedQuerySource |  |
| #### queryInclusionClause |  |
| #### withClause |  |
| #### withoutClause |  |
| #### retrieve |  |
| #### codePath |  |
| #### codeComparator |  |
| #### terminology |  |
| #### query |  |
| #### sourceClause |  |
| #### letClause |  |
| #### letClauseItem |  |
| #### whereClause |  |
| #### returnClause |  |
| #### aggregateClause |  |
| #### startingClause |  |
| #### sortClause |  |
| #### sortDirection |  |
| #### sortByItem |  |
| #### qualifiedIdentifier |  |
| #### simplePath |  |
| #### simpleLiteral |  |
| #### expression |  |
| #### booleanExpression |  |
| #### typeExpression |  |
| #### castExpression |  |
| #### unaryLogicalExpression |  |
| #### comparisonExpression |  |
| #### binaryLogicalExpression |  |
| #### membershipExpression |  |
| #### setExpression |  |
| #### betweenExpression |  |
| #### durationExpression |  |
| #### dateTimePrecision |  |
| #### pluralDateTimePrecision |  |
| #### dateTimeComponent |  |
| #### expressionTerm |  |
| #### unaryIntervalExpressionTerm |  |
| #### invocationExpressionTerm |  |
| #### invocation |  |
| #### indexerExpressionTerm |  |
| #### conversionExpressionTerm |  |
| #### polarityExpressionTerm |  |
| #### dateTimeComponentExpressionTerm |  |
| #### typeExtentExpressionTerm |  |
| #### aggregateExpressionTerm |  |
| #### setAggregateExpressionTerm |  |
| #### binaryArithmeticExpressionTerm |  |
| #### ifExpressionTerm |  |
| #### caseExpressionTerm |  |
| #### caseExpressionItem |  |
| #### dateTimePrecisionSpecifier |  |
| #### relativeQualifier |  |
| #### offsetRelativeQualifier |  |
| #### exclusiveRelativeQualifier |  |
| #### quantityOffset |  |
| #### temporalRelationship |  |
| #### intervalOperatorPhrase |  |
| #### concurrentWithIntervalOperatorPhrase |  |
| #### includesIntervalOperatorPhrase |  |
| #### includedInIntervalOperatorPhrase |  |
| #### beforeOrAfterIntervalOperatorPhrase |  |
| #### withinIntervalOperatorPhrase |  |
| #### meetsOrOverlapsIntervalOperatorPhrase |  |
| #### startsOrEndsIntervalOperatorPhrase |  |
| #### term |  |
| #### iterationIdentifier |  |
| #### function |  |
| #### paramList |  |
| #### selector |  |
| #### literal |  |
| #### quantity |  |
| #### unit |  |
| #### ratio |  |
| #### externalConstant |  |
| #### intervalSelector |  |
| #### tupleSelector |  |
| #### tupleElementSelector |  |
| #### instanceSelector |  |
| #### instanceElementSelector |  |
| #### listSelector |  |
| #### displayClause |  |
| #### codeSelector |  |
| #### conceptSelector |  |
| #### keyword |  |
| #### identifier |  |
| #### QUOTEDIDENTIFIER |  |
| #### DATE |  |
| #### DATETIME |  |
| #### TIME |  |
| #### DATEFORMAT |  |
| #### TIMEFORMAT |  |
| #### TIMEZONEOFFSETFORMAT |  |
| #### IDENTIFIER |  |
| #### DELIMITEDIDENTIFIER |  |
| #### STRING |  |
| #### NUMBER |  |
| #### LONGNUMBER |  |
| #### WS |  |
| #### COMMENT |  |
| #### LINE_COMMENT |  |
| #### ESC |  |
| #### UNICODE |  |
| #### HEX |  |

