# Appendix K - List Of Figures - Clinical Quality Language Specification v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**CQL Specification**](index.md)
* **Appendix K - List Of Figures**

## Appendix K - List Of Figures

| | |
| :--- | :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): N/A |

### Introduction

1. [Figure 1-A](01-introduction.md#figure-1-a): The overall target specification areas involved in clinical quality artifact representation
1. [Figure 1-B](01-introduction.md#figure-1-b): The steps performed by a traditional compiler
1. [Figure 1-C](01-introduction.md#figure-1-c): How the CQL and ELM specifications will be used in the sharing use case

### Author's Guide

1. [Figure 2-A](02-authorsguide.md#figure-2-a): Simplified patient/practitioner information model
1. [Figure 2-B](02-authorsguide.md#figure-2-b): Unfiltered vs patient context
1. [Figure 2-C](02-authorsguide.md#figure-2-c): Simple patient information model
1. [Figure 2-D](02-authorsguide.md#figure-2-d): The union, intersect, and except operators for intervals
1. [Figure 2-E](02-authorsguide.md#figure-2-e): The union, intersect, and except operators for lists
1. [Figure 2-F](02-authorsguide.md#figure-2-f): Example input intervals to illustrate the behavior of thecollapseoperator
1. [Figure 2-G](02-authorsguide.md#figure-2-g): Example output intervals to illustrate the behavior of thecollapseoperator

### Logical Specification

1. [Figure 4-A](04-logicalspecification.md#figure-4-a): A diagram to explain how ELM represents addition of 2 literal values
1. [Figure 4-B](04-logicalspecification.md#figure-4-b): A diagram to explain how ELM represents an equal comparison
1. [Figure 4-C](04-logicalspecification.md#figure-4-c): A diagram to explain how ELM represents a simpleAndexpression
1. [Figure 4-D](04-logicalspecification.md#figure-4-d): A diagram to explain how ELM represents a simpleIfexpression
1. [Figure 4-E](04-logicalspecification.md#figure-4-e): A diagram to explain how ELM represents a complex multi-conditionalCaseexpression
1. [Figure 4-F](04-logicalspecification.md#figure-4-f): A diagram to explain how ELM represents a comparand-baseCaseexpression
1. [Figure 4-G](04-logicalspecification.md#figure-4-g): A diagram to explain how ELM represents a simpleAddexpression
1. [Figure 4-H](04-logicalspecification.md#figure-4-h): A diagram to explain how ELM represents the construction of aTuple
1. [Figure 4-I](04-logicalspecification.md#figure-4-i): A diagram to explain how ELM represents the construction of a structured value using theInstanceclass

