# Appendix J - List Of Tables - Clinical Quality Language Specification v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**CQL Specification**](index.md)
* **Appendix J - List Of Tables**

## Appendix J - List Of Tables

| | |
| :--- | :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): N/A |

### Introduction

1. [Table 1-A](01-introduction.md#table-1-a): Relationship of the current specifications to each component
1. [Table 1-B](01-introduction.md#table-1-b): Major roles that this specification was written for

### Author's Guide

1. [Table 2-A](02-authorsguide.md#table-2-a): Constructs that CQL libraries can contain
1. [Table 2-B](02-authorsguide.md#table-2-b): Elements that define a parameter
1. [Table 2-C](02-authorsguide.md#table-2-c): Typical contexts for CQL
1. [Table 2-D](02-authorsguide.md#table-2-d): Four main clauses for a query construct
1. [Table 2-E](02-authorsguide.md#table-2-e): Types of simple values that CQL supports
1. [Table 2-F](02-authorsguide.md#table-2-f): Elements that make up acodetype
1. [Table 2-G](02-authorsguide.md#table-2-g): Elements that make up aConcepttype
1. [Table 2-H](02-authorsguide.md#table-2-h): The built-in comparison operators that CQL provides
1. [Table 2-I](02-authorsguide.md#table-2-i): Logical operations that CQL provides
1. [Table 2-J](02-authorsguide.md#table-2-j): Arithmetic operations that CQL provides
1. [Table 2-K](02-authorsguide.md#table-2-k): The arguments that theDateTimeoperator takes
1. [Table 2-L](02-authorsguide.md#table-2-l): The arguments that theTimeoperator takes
1. [Table 2-M](02-authorsguide.md#table-2-m): The operators that CQL supports for retrieving the current date and time
1. [Table 2-N](02-authorsguide.md#table-2-n): The precision-based comparison operators forDateandTimecomparisons
1. [Table 2-O](02-authorsguide.md#table-2-o): The valid extraction components for extractingDateandTimecomponents
1. [Table 2-P](02-authorsguide.md#table-2-p): The ISO8601 calendar semantics that should be used for calculations involvingDateandTime
1. [Table 2-Q](02-authorsguide.md#table-2-q): Comparison of two interval values using a complete set of operations
1. [Table 2-R](02-authorsguide.md#table-2-r): The operators that can be used to construct timing phrases
1. [Table 2-S](02-authorsguide.md#table-2-s): The operators that can be used for list comparisons
1. [Table 2-T](02-authorsguide.md#table-2-t): The aggregate operators available in CQL
1. [Table 2-U](02-authorsguide.md#table-2-u): The age related operators available in CQL
1. [Table 2-V](02-authorsguide.md#table-2-v): QDM Data elements and their mapping to QUICK data structures

### Developer's Guide

1. [Table 3-A](03-developersguide.md#table-3-a): The basic lexical elements defined in CQL
1. [Table 3-B](03-developersguide.md#table-3-b): The types of literals supported in CQL
1. [Table 3-C](03-developersguide.md#table-3-c): The escape sequences for string literals in CQL
1. [Table 3-D](03-developersguide.md#table-3-d): The symbols supported by CQL to provide structure to the grammar and allow symbolic invocation of common operators such as addition
1. [Table 3-E](03-developersguide.md#table-3-e): The escape sequences for identifiers in CQL
1. [Table 3-F](03-developersguide.md#table-3-f): The order of operator precedence in CQL
1. [Table 3-G](03-developersguide.md#table-3-g): The primitive types and their ranges supported in CQL
1. [Table 3-H](03-developersguide.md#table-3-h): The structured types to facilitate representation and manipulation of clinical information
1. [Table 3-I](03-developersguide.md#table-3-i): The defined type conversion operators in CQL
1. [Table 3-J](03-developersguide.md#table-3-j): The explicit and implicit conversions supported in CQL

### Logical Specification

### Language Semantics

1. [Table 5-A](05-languagesemantics.md#table-5-a): Description of the data defined by each retrieve
1. [Table 5-B](05-languagesemantics.md#table-5-b): The structure of clinical data descriptors
1. [Table 5-C](05-languagesemantics.md#table-5-c): The categories of nodes and the process for determining the type of each category
1. [Table 5-D](05-languagesemantics.md#table-5-d): The required properties for a cacheable item
1. [Table 5-E](05-languagesemantics.md#table-5-e): The general categories of nodes and the process of evaluation for each
1. [Table 5-F](05-languagesemantics.md#table-5-f): The operations within the expression language are defined with a scope, and the stack to represent this scope
1. [Table 5-G](05-languagesemantics.md#table-5-g): Definitions for the terms involved in dealing withDateandTimevalues
1. [Table 5-H](05-languagesemantics.md#table-5-h): The components used to representDateandTimevalues in CQL
1. [Table 5-I](05-languagesemantics.md#table-5-i): TheQuantitiesand their precision that can be used forDateandTimecalculations in CQL

### Translation Semantics

1. [Table 6-A](06-translationsemantics.md#table-6-a): The ELM equivalent for each CQL declaration
1. [Table 6-B](06-translationsemantics.md#table-6-b): The ELM equivalent for each CQL type-specifier
1. [Table 6-C](06-translationsemantics.md#table-6-c): The ELM equivalent for each CQL Literal
1. [Table 6-D](06-translationsemantics.md#table-6-d): The ELM equivalent for each CQL logical operator
1. [Table 6-E](06-translationsemantics.md#table-6-e): The ELM equivalent for each CQL type operator
1. [Table 6-F](06-translationsemantics.md#table-6-f): The ELM equivalent for each CQL nullological operator
1. [Table 6-G](06-translationsemantics.md#table-6-g): The ELM equivalent for each CQL comparison operator
1. [Table 6-H](06-translationsemantics.md#table-6-h): The ELM equivalent for each CQL arithmetic operator
1. [Table 6-I](06-translationsemantics.md#table-6-i): The ELM equivalent for each CQLStringoperator
1. [Table 6-J](06-translationsemantics.md#table-6-j): The ELM equivalent for each CQLDateandTimeoperator
1. [Table 6-K](06-translationsemantics.md#table-6-k): The ELM equivalent for each CQLIntervaloperator
1. [Table 6-L](06-translationsemantics.md#table-6-l): The ELM equivalent for each CQLListoperator
1. [Table 6-M](06-translationsemantics.md#table-6-m): The ELM equivalent for each CQL aggegrate operator
1. [Table 6-N](06-translationsemantics.md#table-6-n): The ELM equivalent for each CQL clinical operator
1. [Table 6-O](06-translationsemantics.md#table-6-o): The ELM equivalent for each CQL construct

### Physical Representation

1. [Table 7-A](07-physicalrepresentation.md#table-7-a): The schemata that defines the ELM physical representation
1. [Table 7-B](07-physicalrepresentation.md#table-7-b): The data model reference required components
1. [Table 7-C](07-physicalrepresentation.md#table-7-c): The required information for each type available in the data model

### Appendix B - CQL Reference

1. [Table 9-A](09-b-cqlreference.md#table-9-a): The truth table for theAndoperator
1. [Table 9-A1](09-b-cqlreference.md#table-9-a1): The truth table for theImpliesoperator
1. [Table 9-B](09-b-cqlreference.md#table-9-b): The truth table for theNotoperator
1. [Table 9-C](09-b-cqlreference.md#table-9-c): The truth table for theOroperator
1. [Table 9-D](09-b-cqlreference.md#table-9-d): The truth table for theXoroperator
1. [Table 9-E](09-b-cqlreference.md#table-9-e): The conversions supported in CQL
1. [Table 9-F](09-b-cqlreference.md#table-9-f): The string representations that the ToBoolean operator accepts
1. [Table 9-G](09-b-cqlreference.md#table-9-g): The string representations that the ToString operator uses for each data type

### Appendix E - Acronyms

1. [Table 12-A](12-e-acronyms.md#table-12-a): Acronyms used in this specification

