# V1.4 Change Log - Clinical Quality Language Specification v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Changes**](changes.md)
* **V1.4 Change Log**

## V1.4 Change Log

| | |
| :--- | :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): N/A |

**1.4 Change Log**

### STU 4 Reconciliation Changes

* STU4B#21: Extracting a time component now normalizes the date time prior to extraction (Non-Substantive)
* STU4B#22: Added definitional and referential identifier categories to the grammar to resolve ambiguity (Substantive)
* STU4B#23: Updated semantics of list operators to treat null elements as equal for the purposes of membership determination (Substantive)
* STU4B#24: Added schemas and tests to the NPM publication package (Non-Substantive)
* STU4B#25: Documented missing overloads of terminology membership operators (Non-Substantive)
* STU4B#26: Documented missing overloads of terminology membership operators (Non-Substantive)
* STU4B#27: Changed ToDateTime(Date) to leave time components unspecified (Substantive)
* STU4B#28: Enabled search feature in the published specification (Non-Substantive)
* STU4B#29: Added contextTargetRelationship to model information to support identifying target context elements (Substantive)
* STU4B#30: Updated reference implementation and tooling sections (Non-Substantive)
* STU4B#31: Adding warning about string overloads for terminology membership testing (Non-Substantive)
* STU4B#32: Added target element to model information (Substantive)
* STU4B#33: Added uncertainty duration calculation examples (Non-Substantive)
* STU4B#34: Clarified duration calculation formula usage (Non-Substantive)
* STU4B#35: Changed timing phrase translations to add null check when the translation constructs an interval from a nullable element (Substantive)
* STU4B#36: Added Precision, LowBoundary, and HighBoundary operators fro Decimal, DateTime, Time, and DateTime types (Substantive)
* STU4B#37: Allowed ToDate to take full DateTime strings; time portion of the string is ignored (Non-Substantive)
* STU4B#38: Added missing rationale for absence of relative ratio comparison operators (Non-Substantive)
* STU4B#39: Added an example of point extraction from an interval with an open boundary (Non-Substantive)
* STU4B#40: Improved examples throughout (Non-Substantive)
* STU4B#41: Added example of expand with intervals with null boundaries (Non-Substantive)
* STU4B#42: Added result to WidthIsNull example (Non-Substantive)
* STU4B#43: Added example of Width of interval with null boundaries (Non-Substantive)
* STU4B#46: Added expected result for example (Non-Substantive)
* STU4B#47: Corrected use of slash as a separator in the operator precedence tables (Non-Substantive)
* STU4B#48: Corrected distinct example (Non-Substantive)
* STU4B#49: Added expected result for example (Non-Substantive)
* STU4B#50: Defined qualified identifiers prior to usage (Non-Substantive)
* STU4B#51: Defined unqualified identifiers prior to usage (Non-Substantive)
* STU4B#52: Verified correct usage of time literals and formatting strings throughout (Non-Substantive)
* STU4B#53: Added description of seconds and milliseconds precision handling to relative comparison operators throughout (Non-Substantive)
* STU4B#54: Changed language of seconds and milliseconds precision handling to combined rather than considered throughout (Non-Substantive)
* STU4B#58: Updated referenced to XML Schema Reg Ex to PCRE (Non-Substantive)
* STU4B#60: Corrected empty set result to null (Non-Substantive)
* STU4B#63: Added a description of all informative sections of the specification (Non-Substantive)
* STU4B#64: Added removal of T from formatting strings as a breaking change (Non-Substantive)
* STU4B#65: Added description of return type of codes element in retrieve documentation (Non-Substantive)
* STU4B#66: Added description of return type of dateRange element in retrieve documentation (Non-Substantive)
* STU4B#67: Clarified documentation for codeProperty and valueSetProperty in retrieve (Non-Substantive)
* STU4B#68: Added formal description of simple path traversal expression (Non-Substantive)
* STU4B#69: Added example of valueSetProperty usage in retrieve documentation (Non-Substantive)
* STU4B#70: Changed "Unspecified" context name to "Unfiltered" (Substantive)
* STU4B#71: Clarified that model information specifies default context; Unfiltered if no context or default is specified (Non-Substantive)
* STU4B#72: Added documentation to explain why cross-context queries are not supported (Non-Substantive)
* STU4B#73: Clarified example wording (Non-Substantive)
* STU4B#74: Clarified structural versus instance data constraints in data requirements discussion (Non-Substantive)
* STU4B#75: Corrected typo (Non-Substantive)
* STU4B#76: Corrected errors in related context retrieve example (Non-Substantive)
* STU4B#77: Updated related context retrieve example to ensure it is complete (Non-Substantive)
* STU4B#78: Clarified related context retrieve behavior when the context expression results in null (Non-Substantive)
* STU4B#79: Required related context retrieve expression to return a singleton (Substantive)
* STU4B#80: Incorporated test schema into translation tooling (Non-Substantive)
* STU4B#81: Documented test schema attributes (Non-Substantive)
* STU4B#82: Added description element to test cases and groups (Non-Substantive)
* STU4B#83: Added reference element to test cases and groups (Non-Substantive)
* STU4B#84: Added a name element to test cases and groups (Non-Substantive)
* STU4B#85: Documented what portions of the specification are covered by test cases (Non-Substantive)
* STU4B#86: Clarified expand documentation to use intervals of size per rather than unit intervals (Non-Substantive)
* STU4B#87: Added Ratio overload of ToQuantity operator (Substantive)
* STU4B#88: Clarified that local identifiers for included libraries must be unqualified (Non-Substantive)
* STU4B#89: Documented that namespaces are represented in the ELM VersionedIdentifier system element (Non-Substantive)
* STU4B#90: Clarified use of context throughout (Non-Substantive)
* STU4B#91: Clarified use of context throughout (Non-Substantive)
* STU4B#92: Clarified that dateProperty cannot be a Time in the retrieve documentation (Non-Substantive)
* STU4B#93: Relaxed the requirement that both low and high date property elements are present in a retrieve, only one or the other is required, but both are allowed (Non-Substantive)
* STU4B#94: Removed the scope attribute from the Retrieve in ELM (Substantive)
* STU4B#95: Clarified decimal equality semantics throughout (Non-Substantive)
* STU4B#96: Clarified decimal equivalent semantics throughout (Non-Substantive)
* STU4B#97: Reordered documentation of constant offset in minimum operator documentation (Non-Substantive)
* STU4B#98: Reordered documentation of constant offset in maximum operator documentation (Non-Substantive)
* STU4B#99: Clarified default per construction behavior for collapse (Non-Substantive)
* STU4B#100: Clarified default per value versus default per unit (default UCUM unit '1') for collapse (Non-Substantive)
* STU4B#101: Clarified default per value versus default per unit (default UCUM unit '1') for expand (Non-Substantive)
* STU4B#102: Clarified default per constructioni behavior for expand (Non-Substantive)
* STU4B#103: Clarified overlaps before documentation (no longer uses properly to define the behavior) (Non-Substantive)
* STU4B#104: Clarified overlaps after documentation (no longer uses properly to define the behavior) (Non-Substantive)
* STU4B#105: Fixed rendering of calculate age at overloads in logical specification (Non-Substantive)
* STU4B#106: Documented number formatting strings throughout (Non-Substantive)
* STU4B#107: Documented number formatting strings throughout (Non-Substantive)
* STU4B#108: Added related context retrieve documentation to model information discussion (Non-Substantive)
* STU4B#109: Code paths specified in retrieves can now use literal indexers (Substantive)
* STU4B#110: Using Combine on an empty list now results in an empty string, rather than null (Non-Substantive)
* STU4B#111: Changed reference to XML Schema 1.1 Reg Ex to PCRE (Non-Substantive)
* STU4B#112: Corrected expand documentation to describe impact of precision rounding as broadening, rather than narrowing (Non-Substantive)
* STU4B#113: Documented short-circuit behavior for if conditional expression (Non-Substantive)
* STU4B#114: ConvertQuantity operator now throws an error if the implementation does not support the conversion (Substantive)
* STU4B#115: Added examples for Practitioner and Unfiltered context (Non-Substantive)
* STU4B#116: Updated examples for related context retrieves (Non-Substantive)
* STU4B#117: Corrected typo (Non-Substantive)
* STU4B#118: Improved naming of InDemographic expression in examples throughout (Non-Substantive)
* STU4B#120: Added example of size operator on an interval with open boundaries (Non-Substantive)
* STU4B#121: Clarified dofault context selection behavior (Non-Substantive)
* STU4B#125: Corrected readability of some introductory text (Non-Substantive)
* STU4B#126: Added description of the adoption level of CQL to introductory text (Non-Substantive)
* STU4B#127: Added note about conventions being enforced by downstream implementation guides (Non-Substantive)
* STU4B#128: Added note about conventions being enforced by downstream implementation guides (Non-Substantive)
* STU4B#129: Aligned examples with QDM 5.5 data types (Non-Substantive)
* STU4B#131: Expanded test cases (Non-Substantive)
* STU4B#132: Corrected typo (Non-Substantive)
* STU4B#133: Corrected typo (Non-Substantive)
* STU4B#134: Added link to downloaded spec to the downloads page (Non-Substantive)
* STU4B#135: Updated link to QI-Core implementation guide (Non-Substantive)
* STU4B#136: Corrected broken links in introductory text (Non-Substantive)
* STU4B#138: Changed name of Unspecified context to Unfiltered (Substantive)
* STU4B#139: Documented that model information defines relationship of context expression results to the context (Non-Substantive)
* STU4B#140: Added note about conventions being enforced by downstream implementation guides (Non-Substantive)
* STU4B#141: Corrected typo (Non-Substantive)
* STU4B#142: Add clarifying example for relationship clauses versus the where clause (Non-Substantive)
* STU4B#143: Added examples of negative difference and duration calculations (Non-Substantive)
* STU4B#144: Corrected typo (Non-Substantive)
* STU4B#145: Corrected typo (Non-Substantive)
* STU4B#146: Clarified that timing relationships use duration semantics rather than difference (Non-Substantive)
* STU4B#147: Added introductory text describing where to find discussions on more advanced content (Non-Substantive)

### STU 4 Ballot Changes

* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1648[#1648]: ToDate signatures (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1679[#1679]: Ratio clarifications (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1680[#1680]: Ratio comparison (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1683[#1683]: Inconsistent interval notation in examples (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1684[#1684]: Clarify interval operator result examples (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1688[#1688]: ToDate signatures (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1689[#1689]: Clarify Age calculation signatures, behaviors, and descriptions (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1701[#1701]: Correct In(CodeSystem) example (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1702[#1702]: SplitOnMatches signature (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1703[#1703]: Clarify expand semantics (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1705[#1705]: Combine in the presence of nulls (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1706[#1706]: Consistent Width semantics (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1707[#1707]: Size for intervals (Compatible-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1708[#1708]: Expand uses width, not count (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1709[#1709]: Collapse uses width, not count (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1710[#1710]: Code equivalence for post-coordinated expressions (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1711[#1711]: Fix operator precedence of expand (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1712[#1712]: Align string equivalence with FHIRPath (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1713[#1713]: Clarify distinct in the presence of nulls (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1714[#1714]: Clarify type inference for singleton queries (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1715[#1715]: Fix Ratio as a child rather than its own section (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1716[#1716]: Non-patient context (Non-Compatible, substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1717[#1717]: CQL test suite (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1719[#1719]: Namespaces for libraries (Compatible, substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1720[#1720]: Qualifiers in retrieve code paths (Compatible, substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1721[#1721]: Consistent referenced library versions (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1722[#1722]: Update FHIRPath usage and translation sections (Non-compatible)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1723[#1723]: Define seconds as a Decimal (Non-compatible)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1724[#1724]: Removed timezone offset from Time; Changed timezone keyword to timezoneoffset (Non-compatible)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1725[#1725]: Update recommended regex flavor to PCRE (Non-Substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1726[#1726]: Note that implies allows short-circuit evaluation (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1727[#1727]: Add unit conversion for quantities (Compatible, substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1728[#1728]: Divide-by-zero and arithmetic overflow/underflow semantics (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1731[#1731]: Overlaps with open null boundaries (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1732[#1732]: Maximum/Minimum insufficiently specified (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1734[#1734]: Overlaps logical descriptions (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1751[#1751]: Clarify semantics for partial ordering (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1761[#1761]: DateMax example is incorrect (Non-substantive)
* http://www.hl7.org/dstucomments/showdetail_comment.cfm?commentid=1766[#1766]: Add valuesetProperty element to Retrieve (Compatible, Substantive)
* Added support for related-context queries (Compatible, Substantive)

