# V1.2 Change Log - Clinical Quality Language Specification v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Changes**](changes.md)
* **V1.2 Change Log**

## V1.2 Change Log

| | |
| :--- | :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): N/A |

**1.2 Change Log**

Update 2 Changes:

Adopted the FHIRPath.g4 grammar as the base expression grammar for the language

Expanded semantics to enable FHIRPath expressions:

* Added ability to invoke property accessors on a list
* Added $ and % identifier scopes
* Added implies operator
*  

| | |
| :--- | :--- |
| Added | as a synonym for union |

 
* Added & string concatenation operator
* Added promotion and demotion of lists
* Added options to support enabling aspects of FHIRPath functionality
* Added “method-style” invocation syntax
* Added rewrite rules for FHIRPath operations
* Added Repeat, Slice, StartsWith, EndsWith, Matches, ReplaceMatches, LastPositionOf, Children, and Descendents operations
* Applied “treat null as empty list” semantics for list operators (e.g. exists (null) now returns false, not null)
* Added ToList operator to support efficient list promotion

Corrected String concatenation mapping

Clarified runtime behavior for options on quantities with incompatible units

Clarifications and errata throughout based on ballot comments

#824: Fixed Substring declarations in ELM

#991: Clarified semantics for conditional expressions

#1009: Clarified semantics and usage of retrieve with codes and terminologies

#1013: Changed semantics of set operators to distinct

#1031: Clarified semantics of decimal equality (trailing zeroes are ignored)

#1057: Added CQL and ELM Media Types and URL.

#1064: Added support for declaration-only libraries

#1102: Clarified quoted-identifier semantics

#1105: Added version header to CQL grammar file

#1111: Clarified semantics of time-based quantities

#1114: Clarified calculations involving weeks

#1116: Specified semantics for CQL versioning within libraries

#1120: Clarified semantics of date/time arithmetic with timezones

#1122: Added choice types

#1196: Clarified semantics of multiple with/without clauses in a query

#1197: Clarified semantics of weeks for date/time operations

#1221: Added warnings for decimal truncation of time-valued quantities

#1223: Added external function definitions to support import of external libraries

#1229: Clarified subtype vs proper subtype definition

#1232: Fixed incorrect IndexOf documentation

#1233: Fixed Implies signature

#1235: Clarified semantics for Upper and Lower operators

#1236: Clarified semantics for Min and Max aggregate operators

#1237: Clarified semantics for Age in a population context

#1287: Clarified rules for interval construction

#1309: Called clause in the include definition is now optional

#1310: Added source locator information to ELM

#1311: Added result type information to ELM

#1312: Specified JSON format for ELM

#1313: Added less than/more than qualifiers to interval operator phrases

#1314: Provided examples for time interval calculations

#1315: Clarified type inference rules for queries

#1316: Added EndsWith operator

#1317: Fixed an error with escape characters not parsing correctly

#1336: Clarified semantics for before/after timing phrases

#1337: Added on or/or on qualifier to timing phrases to enable inclusive before/after

#1339: Clarified sort behavior in the presence of nulls

#1340: Added Message operators to support errors, warnings, messages and tracing

#1341: Relaxed syntactic restriction on terminology expression in retrieves

#1345: Corrected interpretation of timing phrases

#1348: Clarified let semantics and added documentation for the let clause

Errata:

#1407: Corrected signature for Interval Intersect

#1426: Corrected signature for Same or Before

#1427: Corrected capitalization of is in keywords list

#1431: Relaxed equivalence semantics for Code values to ignore code system version

