# Artifacts Summary - Clinical Quality Language Specification v2.0.0-ballot

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [CQL Capability Characteristic Codes](ValueSet-cql-capability-characteristic-codes.md) | Capability characteristic codes for CQL. |
| [CQL Language Capability](ValueSet-cql-language-capability.md) | Codes for CQL language capabilities. |
| [CQL Message Category](ValueSet-cql-message-category.md) | Codes for categorization of messages returned by applications that process Clinical Quality Language, whether as part of authoring or evaluating. This is the 'all system' value set for the CQL Message Category Codes code system. |
| [CQL Message Characteristic](ValueSet-cql-message-characteristic.md) | Codes for characteristics of messages returned by applications that process Clinical Quality Language. This is the 'all system' value set for the CQL Message Characteristic Codes code system. |
| [CQL Message Code](ValueSet-cql-message-code.md) | Codes for messages returned by applications that process Clinical Quality Language, whether as part of authoring or evaluating. This code system is intended to be a place to identify codes for messages that are indicated by the specification itself. Implementation-specific, application-specific, and content-specific codes may be provided with codes from other code systems, but should ideally map to some code (possibly a more general code) in this code system. This is the 'all system' value set for the CQL Message Codes code system. |
| [CQL Message Severity](ValueSet-cql-message-severity.md) | Codes for severity of messages returned by applications that process Clinical Quality Language, indicating what level of processing should occur for the message. This is the 'all system' value set for the CQL Message Severity code system. |
| [CQL Message Source](ValueSet-cql-message-source.md) | Codes for the source of messages returned by applications that process Clinical Quality Language, indicating generally where the message originated, as well as who or what might be able to potentially address the issue. This is the 'all system' value set for the CQL Message Source Codes code system. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [CQL Capability Characteristic Codes](CodeSystem-cql-capability-characteristic-codes.md) | Codes for CQL versions. |
| [CQL Language Capability Codes](CodeSystem-cql-language-capabilities.md) | Codes for CQL language capabilities. |
| [CQL Message Category Codes](CodeSystem-cql-message-category-codes.md) | Codes for categorization of messages returned by applications that process Clinical Quality Language, whether as part of authoring or evaluating. |
| [CQL Message Characteristic Codes](CodeSystem-cql-message-characteristic-codes.md) | Codes for characteristics of messages returned by applications that process Clinical Quality Language. |
| [CQL Message Codes](CodeSystem-cql-message-codes.md) | Codes for messages returned by applications that process Clinical Quality Language, whether as part of authoring or evaluating. This code system is intended to be a place to identify codes for messages that are indicated by the specification itself. Implementation-specific, application-specific, and content-specific codes may be provided with codes from other code systems, but should ideally map to some code (possibly a more general code) in this code system. |
| [CQL Message Severity Codes](CodeSystem-cql-message-severity-codes.md) | Codes for severity of messages returned by applications that process Clinical Quality Language, indicating what level of processing should occur for the message. |
| [CQL Message Source Codes](CodeSystem-cql-message-source-codes.md) | Codes for the source of messages returned by applications that process Clinical Quality Language, indicating generally where the message originated, as well as who or what might be able to potentially address the issue. |

