# CQL Message Characteristic - Clinical Quality Language Specification v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CQL Message Characteristic**

## ValueSet: CQL Message Characteristic 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://cql.hl7.org/ValueSet/cql-message-characteristic | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CQLMessageCharacteristic |

 
Codes for characteristics of messages returned by applications that process Clinical Quality Language. This is the 'all system' value set for the CQL Message Characteristic Codes code system. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

* Include all codes defined in [`http://cql.hl7.org/CodeSystem/cql-message-characteristic-codes`](CodeSystem-cql-message-characteristic-codes.md)version 📦2.0.0-ballot

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cql-message-characteristic",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://cql.hl7.org/ValueSet/cql-message-characteristic",
  "version" : "2.0.0-ballot",
  "name" : "CQLMessageCharacteristic",
  "title" : "CQL Message Characteristic",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-24T16:45:25+00:00",
  "publisher" : "Clinical Decision Support WG",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/dss/index.cfm"
        }
      ]
    }
  ],
  "description" : "Codes for characteristics of messages returned by applications that process Clinical Quality Language. This is the 'all system' value set for the CQL Message Characteristic Codes code system.",
  "immutable" : true,
  "compose" : {
    "include" : [
      {
        "system" : "http://cql.hl7.org/CodeSystem/cql-message-characteristic-codes"
      }
    ]
  }
}

```
