# CQL Message Codes - Clinical Quality Language Specification v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CQL Message Codes**

## CodeSystem: CQL Message Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://cql.hl7.org/CodeSystem/cql-message-codes | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CQLMessageCodes |

 
Codes for messages returned by applications that process Clinical Quality Language, whether as part of authoring or evaluating. This code system is intended to be a place to identify codes for messages that are indicated by the specification itself. Implementation-specific, application-specific, and content-specific codes may be provided with codes from other code systems, but should ideally map to some code (possibly a more general code) in this code system. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CQLMessageCode](ValueSet-cql-message-code.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cql-message-codes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://cql.hl7.org/CodeSystem/cql-message-codes",
  "version" : "2.0.0-ballot",
  "name" : "CQLMessageCodes",
  "title" : "CQL Message Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-24T16:45:25+00:00",
  "publisher" : "Clinical Decision Support WG",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/dss/index.cfm"
        }
      ]
    }
  ],
  "description" : "Codes for messages returned by applications that process Clinical Quality Language, whether as part of authoring or evaluating. This code system is intended to be a place to identify codes for messages that are indicated by the specification itself. Implementation-specific, application-specific, and content-specific codes may be provided with codes from other code systems, but should ideally map to some code (possibly a more general code) in this code system.",
  "caseSensitive" : true,
  "valueSet" : "http://cql.hl7.org/ValueSet/cql-message-code",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://cql.hl7.org/ValueSet/cql-message-category"
        }
      ],
      "code" : "category",
      "uri" : "http://cql.hl7.org/CodeSystem/cql-message-characteristic-codes#category",
      "description" : "The language area, possible values are codes in the [CQL Message Category Codes](CodeSystem-cql-message-category-codes.html) code system",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://cql.hl7.org/ValueSet/cql-message-severity"
        }
      ],
      "code" : "severity",
      "uri" : "http://cql.hl7.org/CodeSystem/cql-message-characteristic-codes#severity",
      "description" : "Severity of the issue, possible values are codes in the [CQL Message Severity Codes](CodeSystem-cql-message-severity-codes.html) code system",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://cql.hl7.org/ValueSet/cql-message-source"
        }
      ],
      "code" : "source",
      "uri" : "http://cql.hl7.org/CodeSystem/cql-message-characteristic-codes#source",
      "description" : "The source of the issue, providing information about where the issue is originating and how it might be addressed, possible values are codes in the [CQL Message Source Codes](CodeSystem-cql-message-source-codes.html) code system",
      "type" : "code"
    },
    {
      "code" : "example",
      "uri" : "http://cql.hl7.org/CodeSystem/cql-message-characteristic-codes#example",
      "description" : "An example message providing a sample of what kinds of actual messages will be returned with this code.",
      "type" : "string"
    },
    {
      "code" : "notes",
      "uri" : "http://cql.hl7.org/CodeSystem/cql-message-characteristic-codes#notes",
      "description" : "Notes about the message, especially how to address the issue being identified",
      "type" : "string"
    },
    {
      "code" : "spec-link",
      "uri" : "http://cql.hl7.org/CodeSystem/cql-message-characteristic-codes#spec-link",
      "description" : "A URL to the point in the specification where this message is defined",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "code" : "000-00000",
      "display" : "Internal",
      "definition" : "Internal translator error",
      "property" : [
        {
          "code" : "category",
          "valueCode" : "compile-time"
        },
        {
          "code" : "severity",
          "valueCode" : "error"
        },
        {
          "code" : "source",
          "valueCode" : "content"
        },
        {
          "code" : "example",
          "valueString" : "Internal translator error"
        },
        {
          "code" : "notes",
          "valueString" : "This message code typically indicates an unexpected error was encountered while attempting to compile CQL."
        },
        {
          "code" : "spec-link",
          "valueString" : "20-m-messages.html#messages"
        }
      ]
    },
    {
      "code" : "001-00000",
      "display" : "Lexical",
      "definition" : "Lexical error",
      "property" : [
        {
          "code" : "category",
          "valueCode" : "lexical"
        },
        {
          "code" : "severity",
          "valueCode" : "error"
        },
        {
          "code" : "source",
          "valueCode" : "content"
        },
        {
          "code" : "example",
          "valueString" : "Lexical error"
        },
        {
          "code" : "notes",
          "valueString" : "This is a general message code for lexical errors encountered while processing CQL. The actual message will typically contain more detailed information about the issue and how to address it."
        },
        {
          "code" : "spec-link",
          "valueString" : "20-m-messages.html#messages"
        }
      ]
    },
    {
      "code" : "002-00000",
      "display" : "Syntax",
      "definition" : "Syntax error",
      "property" : [
        {
          "code" : "category",
          "valueCode" : "syntax"
        },
        {
          "code" : "severity",
          "valueCode" : "error"
        },
        {
          "code" : "source",
          "valueCode" : "content"
        },
        {
          "code" : "example",
          "valueString" : "Syntax error"
        },
        {
          "code" : "notes",
          "valueString" : "This is a general message code for syntax errors encountered while processing CQL. The actual message will typically contain more detailed information about the issue and how to address it."
        },
        {
          "code" : "spec-link",
          "valueString" : "20-m-messages.html#messages"
        }
      ]
    },
    {
      "code" : "003-00000",
      "display" : "Semantic",
      "definition" : "Semantic error",
      "property" : [
        {
          "code" : "category",
          "valueCode" : "semantic"
        },
        {
          "code" : "severity",
          "valueCode" : "error"
        },
        {
          "code" : "source",
          "valueCode" : "content"
        },
        {
          "code" : "example",
          "valueString" : "Semantic error"
        },
        {
          "code" : "notes",
          "valueString" : "This is a general message code for semantic errors encountered while processing CQL. The actual message will typically contain more detailed information about the issue and how to address it."
        },
        {
          "code" : "spec-link",
          "valueString" : "20-m-messages.html#messages"
        }
      ]
    },
    {
      "code" : "003-10000",
      "display" : "Conditional expression resulted in a choice type",
      "definition" : "Indicates that a conditional expression resulted in a choice type when none of the branches of the conditional were choice types. This can indicate a mistake and should be reviewed.",
      "property" : [
        {
          "code" : "category",
          "valueCode" : "semantic"
        },
        {
          "code" : "severity",
          "valueCode" : "warning"
        },
        {
          "code" : "source",
          "valueCode" : "content"
        },
        {
          "code" : "example",
          "valueString" : "Conditional expression resulted in a choice type `Choice<Boolean, List<Integer>`"
        },
        {
          "code" : "notes",
          "valueString" : "This message may be suppressed with the @suppressWarning tag"
        },
        {
          "code" : "spec-link",
          "valueString" : "03-developersguide.html#type-inference-of-conditional-expressions"
        }
      ]
    },
    {
      "code" : "100-00000",
      "display" : "Run-time",
      "definition" : "Runtime error",
      "property" : [
        {
          "code" : "category",
          "valueCode" : "run-time"
        },
        {
          "code" : "severity",
          "valueCode" : "error"
        },
        {
          "code" : "source",
          "valueCode" : "content"
        },
        {
          "code" : "example",
          "valueString" : "Run-time error"
        },
        {
          "code" : "notes",
          "valueString" : "This is a general message code for run-time errors encountered while attempting to evaluate CQL. The actual message will typically contain more detailed information about the issue and how to address it."
        },
        {
          "code" : "spec-link",
          "valueString" : "20-m-messages.html#messages"
        }
      ]
    }
  ]
}

```
