# CQL Message Category Codes - Clinical Quality Language Specification v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CQL Message Category Codes**

## CodeSystem: CQL Message Category Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://cql.hl7.org/CodeSystem/cql-message-category-codes | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CQLMessageCategoryCodes |

 
Codes for categorization of messages returned by applications that process Clinical Quality Language, whether as part of authoring or evaluating. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CQLMessageCategory](ValueSet-cql-message-category.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cql-message-category-codes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://cql.hl7.org/CodeSystem/cql-message-category-codes",
  "version" : "2.0.0-ballot",
  "name" : "CQLMessageCategoryCodes",
  "title" : "CQL Message Category Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-24T16:45:25+00:00",
  "publisher" : "Clinical Decision Support WG",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/dss/index.cfm"
        }
      ]
    }
  ],
  "description" : "Codes for categorization of messages returned by applications that process Clinical Quality Language, whether as part of authoring or evaluating.",
  "caseSensitive" : true,
  "valueSet" : "http://cql.hl7.org/ValueSet/cql-message-category",
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "concept" : [
    {
      "code" : "compile-time",
      "display" : "Compile-Time",
      "definition" : "The message is associated with compile-time (or authoring) processing, such as a lexical, syntactic, or semantic error.",
      "concept" : [
        {
          "code" : "lexical",
          "display" : "Lexical",
          "definition" : "The message is associated with lexical processing, such as an invalid token."
        },
        {
          "code" : "syntax",
          "display" : "Syntax",
          "definition" : "The message is associated with syntactic processing of CQL, such as an unexpected keyword."
        },
        {
          "code" : "semantic",
          "display" : "Semantic",
          "definition" : "The message is associated with semantic processing of CQL, such as an unresolvable function call."
        }
      ]
    },
    {
      "code" : "run-time",
      "display" : "Run-Time",
      "definition" : "The message is associated with run-time (or evaluation) processing of CQL, such as a duplicate value."
    }
  ]
}

```
