# CQL Language Capability Codes - Clinical Quality Language Specification v2.0.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CQL Language Capability Codes**

## CodeSystem: CQL Language Capability Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://cql.hl7.org/CodeSystem/cql-language-capabilities | *Version*:2.0.0-ballot | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CQLLanguageCapabilityCodes |

 
Codes for CQL language capabilities. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CQLLanguageCapability](ValueSet-cql-language-capability.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cql-language-capabilities",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://cql.hl7.org/CodeSystem/cql-language-capabilities",
  "version" : "2.0.0-ballot",
  "name" : "CQLLanguageCapabilityCodes",
  "title" : "CQL Language Capability Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-24T16:45:25+00:00",
  "publisher" : "Clinical Decision Support WG",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/dss/index.cfm"
        }
      ]
    }
  ],
  "description" : "Codes for CQL language capabilities.",
  "caseSensitive" : true,
  "valueSet" : "http://cql.hl7.org/ValueSet/cql-language-capability",
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "version",
      "uri" : "http://cql.hl7.org/CodeSystem/cql-capability-characteristic-codes#version",
      "description" : "The version in which the capability was introduced in the specification",
      "type" : "string"
    },
    {
      "code" : "versionTo",
      "uri" : "http://cql.hl7.org/CodeSystem/cql-capability-characteristic-codes#versionTo",
      "description" : "The last version in which the capability was included in the specification",
      "type" : "string"
    },
    {
      "code" : "value",
      "uri" : "http://cql.hl7.org/CodeSystem/cql-capability-characteristic-codes#value",
      "description" : "A qualifier value used to provide more detail about the capability",
      "type" : "string"
    },
    {
      "code" : "valueMeaning",
      "uri" : "http://cql.hl7.org/CodeSystem/cql-capability-characteristic-codes#valueMeaning",
      "description" : "A description of the meaning of qualifier values for the capability",
      "type" : "string"
    },
    {
      "code" : "reference",
      "uri" : "http://cql.hl7.org/CodeSystem/cql-capability-characteristic-codes#reference",
      "description" : "A reference to the specification documenting this capability",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "code" : "decimal-precision-and-scale",
      "display" : "Decimal precision and scale",
      "definition" : "How many total digits (precision) and how many digits to the right of the decimal point (scale) the implementation supports for Decimal values.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "value",
          "valueString" : "28,8"
        },
        {
          "code" : "valueMeaning",
          "valueString" : "The supported precision and scale of decimal values"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#decimal"
        }
      ]
    },
    {
      "code" : "datetime-precision-and-scale",
      "display" : "Datetime precision and scale",
      "definition" : "The finest granularity (precision) and smallest increment (scale) supported for date/time values.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#datetime"
        }
      ]
    },
    {
      "code" : "ucum-unit-conversion-support",
      "display" : "UCUM unit conversion support",
      "definition" : "Whether and how the engine can automatically convert between units of measure using UCUM.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#convertquantity"
        }
      ]
    },
    {
      "code" : "regex-dialect",
      "display" : "Regex dialect",
      "definition" : "Which flavor of regular expressions the implementation supports.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#matches"
        }
      ]
    },
    {
      "code" : "supported-data-models",
      "display" : "Supported data models",
      "definition" : "Which external models the engine can evaluate against.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#data-model"
        }
      ]
    },
    {
      "code" : "expand-operator",
      "display" : "Expand operator",
      "definition" : "Expand on ValueSet/Interval.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.3"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#collapse-and-expand-operators"
        }
      ]
    },
    {
      "code" : "fhirpath-support",
      "display" : "FHIRPath Support",
      "definition" : "Ability to evaluate/translate FHIRPath within CQL.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.3"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/16-i-fhirpathtranslation.html"
        }
      ]
    },
    {
      "code" : "precision-operators-for-decimal-and-date-time-types",
      "display" : "Precision operators for Decimal and Date/Time types",
      "definition" : "Operators that adjust/control precision.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.4"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#precision"
        }
      ]
    },
    {
      "code" : "model-defined-contexts",
      "display" : "Model-defined contexts",
      "definition" : "Contexts defined by the data model.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.4"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#context-support"
        }
      ]
    },
    {
      "code" : "library-namespaces",
      "display" : "Library namespaces",
      "definition" : "Organize libraries into namespaces.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.4"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/07-physicalrepresentation.html#media-types-and-namespaces"
        }
      ]
    },
    {
      "code" : "related-context-retrieves",
      "display" : "Related-context retrieves",
      "definition" : "Context-relative retrieve operations.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.4"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#retrieve-paths"
        }
      ]
    },
    {
      "code" : "unit-conversion-support",
      "display" : "Unit conversion support",
      "definition" : "Convert between compatible UCUM units.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.4"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#conversions"
        }
      ]
    },
    {
      "code" : "modular-arithmetic-for-quantities",
      "display" : "Modular arithmetic for quantities",
      "definition" : "Modulo/remainder with Quantity.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.5"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#quantity-arithmetic"
        }
      ]
    },
    {
      "code" : "expand-a-single-interval",
      "display" : "Expand a single interval",
      "definition" : "Expand applied to a single Interval.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.5"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#expand"
        }
      ]
    },
    {
      "code" : "aggregate-clause",
      "display" : "Aggregate clause",
      "definition" : "Query clause for aggregation.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.5"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#aggregate-clause"
        }
      ]
    },
    {
      "code" : "include-retrieves",
      "display" : "Include retrieves",
      "definition" : "Retrieve that follows model references.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.5"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#retrieve-paths"
        }
      ]
    },
    {
      "code" : "searchpath-retrieves",
      "display" : "Searchpath retrieves",
      "definition" : "Retrieve using a search path expression.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.5"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#retrieve-paths"
        }
      ]
    },
    {
      "code" : "id-retrieves",
      "display" : "Id retrieves",
      "definition" : "Retrieve by unique identifier.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.5"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#retrieve-paths"
        }
      ]
    },
    {
      "code" : "system-data-types",
      "display" : "System Data Types",
      "definition" : "Primitive, structured, and collection types defined by the System namespace.",
      "property" : [
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#types"
        }
      ],
      "concept" : [
        {
          "code" : "system.integer",
          "display" : "System.Integer",
          "definition" : "Whole numbers with no fractional component.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#integer"
            }
          ]
        },
        {
          "code" : "system.long",
          "display" : "System.Long",
          "definition" : "64-bit signed integers.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.5"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#long"
            }
          ]
        },
        {
          "code" : "system.decimal",
          "display" : "System.Decimal",
          "definition" : "Numbers with fractional precision and scale.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#decimal"
            }
          ]
        },
        {
          "code" : "system.string",
          "display" : "System.String",
          "definition" : "Sequence of text characters.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#string"
            }
          ]
        },
        {
          "code" : "system.boolean",
          "display" : "System.Boolean",
          "definition" : "Logical truth values.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#boolean"
            }
          ]
        },
        {
          "code" : "system.date",
          "display" : "System.Date",
          "definition" : "Calendar date without time.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.3"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#date"
            }
          ]
        },
        {
          "code" : "system.time",
          "display" : "System.Time",
          "definition" : "Time of day without date.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#time"
            }
          ]
        },
        {
          "code" : "system.datetime",
          "display" : "System.DateTime",
          "definition" : "Date and time point (optional offset).",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#datetime"
            }
          ]
        },
        {
          "code" : "system.quantity",
          "display" : "System.Quantity",
          "definition" : "Numeric value with unit.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#quantity"
            }
          ]
        },
        {
          "code" : "system.ratio",
          "display" : "System.Ratio",
          "definition" : "Fractional relationship between two Quantities.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.3"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#ratio"
            }
          ]
        },
        {
          "code" : "system.interval",
          "display" : "System.Interval",
          "definition" : "Range over an ordered type.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#interval-operators-3"
            }
          ]
        },
        {
          "code" : "system.list",
          "display" : "System.List",
          "definition" : "Ordered collection of elements of a type.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/63-expressionlanguagesemantics.html#collection-types"
            }
          ]
        },
        {
          "code" : "system.tuple",
          "display" : "System.Tuple",
          "definition" : "Structured type with named elements.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/63-expressionlanguagesemantics.html#structured-types"
            }
          ]
        },
        {
          "code" : "system.choice",
          "display" : "System.Choice",
          "definition" : "Value of one among several types.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/63-expressionlanguagesemantics.html#choice-types"
            }
          ]
        },
        {
          "code" : "system.codesystem",
          "display" : "System.CodeSystem",
          "definition" : "Reference to an external code system.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.5"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#codesystem"
            }
          ]
        },
        {
          "code" : "system.valueset",
          "display" : "System.ValueSet",
          "definition" : "Reference to a set of codes.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.5"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#valueset"
            }
          ]
        },
        {
          "code" : "system.vocabulary",
          "display" : "System.Vocabulary",
          "definition" : "Base type for vocabulary-related types.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.5"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#vocabulary"
            }
          ]
        }
      ]
    },
    {
      "code" : "logical-operators",
      "display" : "Logical Operators",
      "definition" : "and, or, not, implies under 3-valued logic.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#logical-operators"
        }
      ],
      "concept" : [
        {
          "code" : "logical-operators.and",
          "display" : "Logical Operator and",
          "definition" : "The and operator returns true if both its arguments are true. If either argument is false, the result is false. Otherwise, the result is null.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#and"
            }
          ]
        },
        {
          "code" : "logical-operators.or",
          "display" : "Logical Operator or",
          "definition" : "The or operator returns true if either of its arguments are true. If both arguments are false, the result is false. Otherwise, the result is null.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#or"
            }
          ]
        },
        {
          "code" : "logical-operators.not",
          "display" : "Logical Operator not",
          "definition" : "The not operator returns true if the argument is false and false if the argument is true. Otherwise, the result is null.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#not"
            }
          ]
        },
        {
          "code" : "logical-operators.xor",
          "display" : "Logical Operator xor",
          "definition" : "The xor (exclusive or) operator returns true if one argument is true and the other is false. If both arguments are true or both arguments are false, the result is false. Otherwise, the result is null.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#xor"
            }
          ]
        },
        {
          "code" : "logical-operators.implies",
          "display" : "Logical Operator implies",
          "definition" : "The implies operator returns the logical implication of its arguments. This means that if the left operand evaluates to true, this operator returns the boolean evaluation of the right operand. If the left operand evaluates to false, this operator returns true. Otherwise, this operator returns true if the right operand evaluates to true, and null otherwise",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#implies"
            }
          ]
        }
      ]
    },
    {
      "code" : "type-operators",
      "display" : "Type Operators",
      "definition" : "Type inspection and conversion operators.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#type-operators"
        }
      ],
      "concept" : [
        {
          "code" : "type-operators.as",
          "display" : "Type Operator as",
          "definition" : "The as operator allows the result of an expression to be cast as a given target type. This allows expressions to be written that are statically typed against the expected run-time type of the argument.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#as"
            }
          ]
        },
        {
          "code" : "type-operators.cast-as",
          "display" : "Type Operator as",
          "definition" : "(See the as operator in addition) The cast prefix indicates that if the argument is not of the specified type at run-time then an exception is thrown.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#as"
            }
          ]
        },
        {
          "code" : "type-operators.is",
          "display" : "Type Operator is",
          "definition" : "The is operator allows the type of a result to be tested. If the run-time type of the argument is the same as or derived from the type being tested, the result of the operator is true; otherwise, the result is false.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#is"
            }
          ]
        },
        {
          "code" : "type-operators.children",
          "display" : "Type Operator children",
          "definition" : "For structured types, the Children operator returns a list of all the values of the elements of the type. List-valued elements are expanded and added to the result individually, rather than as a single list.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#children"
            }
          ]
        },
        {
          "code" : "type-operators.descendants",
          "display" : "Type Operator descendants",
          "definition" : "or structured types, the Descendants operator returns a list of all the values of the elements of the type, recursively. List-valued elements are expanded and added to the result individually, rather than as a single list.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#descendants"
            }
          ]
        },
        {
          "code" : "type-operators.convert-quantity",
          "display" : "Type Operator convert-quantity",
          "definition" : "The convert operator converts a value to a specific type. The result of the operator is the value of the argument converted to the target type, if possible. If there is no valid conversion from the actual value to the target type, the result is null.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#convert"
            }
          ]
        },
        {
          "code" : "type-operators.to-boolean",
          "display" : "Type Operator to-boolean",
          "definition" : "The ToBoolean operator converts the value of its argument to a Boolean value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#toboolean"
            }
          ]
        },
        {
          "code" : "type-operators.to-integer",
          "display" : "Type Operator to-integer",
          "definition" : "The ToInteger operator converts the value of its argument to an Integer value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#tointeger"
            }
          ]
        },
        {
          "code" : "type-operators.to-long",
          "display" : "Type Operator to-long",
          "definition" : "The ToLong operator converts the value of its argument to a Long value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.5"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#tolong"
            }
          ]
        },
        {
          "code" : "type-operators.to-decimal",
          "display" : "Type Operator to-decimal",
          "definition" : "The ToDecimal operator converts the value of its argument to a Decimal value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#todecimal"
            }
          ]
        },
        {
          "code" : "type-operators.to-quantity",
          "display" : "Type Operator to-quantity",
          "definition" : "The ToQuantity operator converts the value of its argument to a Quantity value. The operation does not perform any unit conversion, that capability is supported by the ConvertQuantity operator.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#toquantity"
            }
          ]
        },
        {
          "code" : "type-operators.to-ratio",
          "display" : "Type Operator to-ratio",
          "definition" : "The ToRatio operator converts the value of its argument to a Ratio value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#toratio"
            }
          ]
        },
        {
          "code" : "type-operators.to-date",
          "display" : "Type Operator to-date",
          "definition" : "The ToDate operator converts the value of its argument to a Date value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#todate"
            }
          ]
        },
        {
          "code" : "type-operators.to-datetime",
          "display" : "Type Operator to-datetime",
          "definition" : "The ToDateTime operator converts the value of its argument to a DateTime value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#todatetime"
            }
          ]
        },
        {
          "code" : "type-operators.to-time",
          "display" : "Type Operator to-time",
          "definition" : "The ToTime operator converts the value of its argument to a Time value. The operator expects the string to be formatted using ISO-8601 time representation.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#totime"
            }
          ]
        },
        {
          "code" : "type-operators.to-string",
          "display" : "Type Operator to-string",
          "definition" : "The ToString operator converts the value of its argument to a String value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#tostring"
            }
          ]
        },
        {
          "code" : "type-operators.converts-to-boolean",
          "display" : "Type Operator converts-to-boolean",
          "definition" : "The ConvertsToBoolean operator returns true if its argument is or can be converted to a Boolean value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#convertstoboolean"
            }
          ]
        },
        {
          "code" : "type-operators.converts-to-integer",
          "display" : "Type Operator converts-to-integer",
          "definition" : "The ConvertsToInteger operator returns true if its argument is or can be converted to an Integer value. See the ToInteger operator for a description of the supported conversions.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#convertstointeger"
            }
          ]
        },
        {
          "code" : "type-operators.converts-to-long",
          "display" : "Type Operator converts-to-long",
          "definition" : "The ConvertsToLong operator returns true if its argument is or can be converted to a Long value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.5"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#convertstolong"
            }
          ]
        },
        {
          "code" : "type-operators.converts-to-decimal",
          "display" : "Type Operator converts-to-decimal",
          "definition" : "The ToDecimal operator returns true if its argument is or can be converted to a Decimal value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#convertstodecimal"
            }
          ]
        },
        {
          "code" : "type-operators.converts-to-quantity",
          "display" : "Type Operator converts-to-quantity",
          "definition" : "The ConvertsToQuantity operator returns true if its argument is or can be converted to a Quantity value. See the ToQuantity operator for a description of the supported conversions.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#convertstoquantity"
            }
          ]
        },
        {
          "code" : "type-operators.converts-to-ratio",
          "display" : "Type Operator converts-to-ration",
          "definition" : "The ConvertsToRatio operator returns true if its argument is or can be converted to a Ratio value",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#convertstoratio"
            }
          ]
        },
        {
          "code" : "type-operators.converts-to-date",
          "display" : "Type Operator converts-to-date",
          "definition" : "The ConvertsToDate operator returns true if its argument is or can be converted to a Date value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#convertstodate"
            }
          ]
        },
        {
          "code" : "type-operators.converts-to-datetime",
          "display" : "Type Operator converts-to-datetime",
          "definition" : "The ConvertsToDateTime operator returns true if its argument is or can be converted to a DateTime value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#convertstodatetime"
            }
          ]
        },
        {
          "code" : "type-operators.converts-to-time",
          "display" : "Type Operator converts-to-time",
          "definition" : "The ConvertsToTime operator returns true if its argument is or can be converted to a Time value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#convertstotime"
            }
          ]
        },
        {
          "code" : "type-operators.converts-to-string",
          "display" : "Type Operator converts-to-string",
          "definition" : "The ConvertsToString operator returns true if its argument is or can be converted to a String value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#convertstostring"
            }
          ]
        }
      ]
    },
    {
      "code" : "nullological-operators",
      "display" : "Nullological Operators",
      "definition" : "Operators dealing with null/missing information.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#nullological-operators"
        }
      ],
      "concept" : [
        {
          "code" : "nullological-operators.coalesce",
          "display" : "Nullological Operators coalesce",
          "definition" : "The Coalesce operator returns the first non-null result in a list of arguments. If all arguments evaluate to null, the result is null.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#coalesce"
            }
          ]
        },
        {
          "code" : "nullological-operators.is-null",
          "display" : "Nullological Operators is-null",
          "definition" : "The is null operator determines whether or not its argument evaluates to null. If the argument evaluates to null, the result is true; otherwise, the result is false.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#isnull"
            }
          ]
        },
        {
          "code" : "nullological-operators.is-true",
          "display" : "Nullological Operators coalesce",
          "definition" : "The is true operator determines whether or not its argument evaluates to true. If the argument evaluates to true, the result is true; otherwise, the result is false.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#istrue"
            }
          ]
        },
        {
          "code" : "nullological-operators.is-false",
          "display" : "Nullological Operators is-false",
          "definition" : "The is false operator determines whether or not its argument evaluates to false. If the argument evaluates to false, the result is true; otherwise, the result is false.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#isfalse"
            }
          ]
        }
      ]
    },
    {
      "code" : "comparison-operators",
      "display" : "Comparison Operators",
      "definition" : "Equal, not equal, <, <=, >, >=, in/not in, etc.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#comparison-operators"
        }
      ],
      "concept" : [
        {
          "code" : "comparison-operators.equal",
          "display" : "Comparison Operators equal",
          "definition" : "The equal (=) operator returns true if the arguments are equal; false if the arguments are known unequal, and null otherwise. Equality semantics are defined to be value-based.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#equal"
            }
          ]
        },
        {
          "code" : "comparison-operators.equivalent",
          "display" : "Comparison Operators equivalent",
          "definition" : "The equivalent (~) operator returns true if the arguments are equivalent in value, or if they are both null; and false otherwise.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#equivalent"
            }
          ]
        },
        {
          "code" : "comparison-operators.greater",
          "display" : "Comparison Operators greater",
          "definition" : "The greater (>) operator returns true if the first argument is greater than the second argument.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#greater"
            }
          ]
        },
        {
          "code" : "comparison-operators.greater-or-equal",
          "display" : "Comparison Operators greater or equal",
          "definition" : "The greater or equal (>=) operator returns true if the first argument is greater than or equal to the second argument.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#greater-or-equal"
            }
          ]
        },
        {
          "code" : "comparison-operators.less",
          "display" : "Comparison Operators less",
          "definition" : "The less (<) operator returns true if the first argument is less than the second argument.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#less"
            }
          ]
        },
        {
          "code" : "comparison-operators.less-or-equal",
          "display" : "Comparison Operators less-or-equal",
          "definition" : "The less or equal (<=) operator returns true if the first argument is less than or equal to the second argument.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#less-or-equal"
            }
          ]
        },
        {
          "code" : "comparison-operators.not-equal",
          "display" : "Comparison Operators not-equal",
          "definition" : "The not equal (!=) operator returns true if its arguments are not the same value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#not-equal"
            }
          ]
        },
        {
          "code" : "comparison-operators.not-equivalent",
          "display" : "Comparison Operators not-equivalent",
          "definition" : "The not equivalent (!~) operator returns true if its arguments are not equivalent.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#not-equivalent"
            }
          ]
        },
        {
          "code" : "comparison-operators.between",
          "display" : "Comparison Operators between",
          "definition" : "The between operator determines whether the first argument is within a given range, inclusive. If the first argument is greater than or equal to the low argument, and less than or equal to the high argument, the result is true, otherwise, the result is false.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#between"
            }
          ]
        }
      ]
    },
    {
      "code" : "arithmetic-operators",
      "display" : "Arithmetic Operators",
      "definition" : "Add, subtract, multiply, divide, mod, round, etc.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#arithmetic-operators"
        }
      ],
      "concept" : [
        {
          "code" : "arithmetic-operators.abs",
          "display" : "Arithmetic Operators abs",
          "definition" : "The Abs operator returns the absolute value of its argument.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#abs"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.add",
          "display" : "Arithmetic Operators add",
          "definition" : "The add (+) operator performs numeric addition of its arguments.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#add"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.ceiling",
          "display" : "Arithmetic Operators ceiling",
          "definition" : "The Ceiling operator returns the first integer greater than or equal to the argument.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#ceiling"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.divide",
          "display" : "Arithmetic Operators divide",
          "definition" : "The divide (/) operator performs numeric division of its arguments. Note that this operator is Decimal division; for Integer division, use the truncated divide (div) operator.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#string-operators"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.floor",
          "display" : "Arithmetic Operators floor",
          "definition" : "The Floor operator returns the first integer less than or equal to the argument.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#floor"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.exp",
          "display" : "Arithmetic Operators exp",
          "definition" : "The Exp operator raises e to the power of its argument.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#exp"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.highboundary",
          "display" : "Arithmetic Operators highboundary",
          "definition" : "The HighBoundary function returns the greatest possible value of the input to the specified precision.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.5"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#highboundary"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.log",
          "display" : "Arithmetic Operators log",
          "definition" : "The Log operator computes the logarithm of its first argument, using the second argument as the base.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#log"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.lowboundary",
          "display" : "Arithmetic Operators lowboundary",
          "definition" : "The LowBoundary function returns the least possible value of the input to the specified precision.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.5"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#lowboundary"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.ln",
          "display" : "Arithmetic Operators ln",
          "definition" : "The Ln operator computes the natural logarithm of its argument.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#ln"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.maximum",
          "display" : "Arithmetic Operators maximum",
          "definition" : "The maximum operator returns the maximum representable value for the given type, defined for the Integer, Long, Decimal, Quantity, Date, DateTime, and Time types.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#maximum"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.minimum",
          "display" : "Arithmetic Operators minimum",
          "definition" : "The minimum operator returns the minimum representable value for the given type, defined for the Integer, Long, Decimal, Quantity, Date, DateTime, and Time types.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#minimum"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.mod",
          "display" : "Arithmetic Operators mod",
          "definition" : "The mod operator computes the remainder of the division of its arguments.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#mod"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.multiply",
          "display" : "Arithmetic Operators multiply",
          "definition" : "The multiply (*) operator performs numeric multiplication of its arguments.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#multiply"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.negate",
          "display" : "Arithmetic Operators negate",
          "definition" : "The negate (-) operator returns the negative of its argument.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#negate"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.precision",
          "display" : "Arithmetic Operators precision",
          "definition" : "The Precision function returns the number of digits of precision in the input value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.5"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#precision"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.predecessor",
          "display" : "Arithmetic Operators predecessor",
          "definition" : "The predecessor operator returns the predecessor of the argument. For example, the predecessor of 2 is 1. If the argument is already the minimum value for the type, a null is returned.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#predecessor"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.power",
          "display" : "Arithmetic Operators power",
          "definition" : "The power (^) operator raises the first argument to the power given by the second argument.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#power"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.round",
          "display" : "Arithmetic Operators round",
          "definition" : "The Round operator returns the nearest whole number to its argument. The semantics of round are defined as a traditional round (i.e. to the nearest whole number), meaning that a decimal value greater than or equal to 0.5 and less than 1.0 will round to 1, and a decimal value less than or equal to -0.5 and greater than -1.0 will round to -1.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#round"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.subtract",
          "display" : "Arithmetic Operators subtract",
          "definition" : "The subtract (-) operator performs numeric subtraction of its arguments.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#subtract"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.successor",
          "display" : "Arithmetic Operators successor",
          "definition" : "The successor operator returns the successor of the argument. For example, the successor of 1 is 2. If the argument is already the maximum value for the type, a null is returned.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#successor"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.truncate",
          "display" : "Arithmetic Operators truncate",
          "definition" : "The Truncate operator returns the integer component of its argument.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#truncate"
            }
          ]
        },
        {
          "code" : "arithmetic-operators.div",
          "display" : "Arithmetic Operators div",
          "definition" : "The div operator performs truncated division of its arguments.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#div"
            }
          ]
        }
      ]
    },
    {
      "code" : "string-operators",
      "display" : "String Operators",
      "definition" : "Length, substring, startsWith, endsWith, matches, replaceMatches, etc.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#string-operators"
        }
      ],
      "concept" : [
        {
          "code" : "string-operators.combine",
          "display" : "String Operators combine",
          "definition" : "The Combine operator combines a list of strings, optionally separating each string with the given separator.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#combine"
            }
          ]
        },
        {
          "code" : "string-operators.concatenate",
          "display" : "String Operators concatenate",
          "definition" : "The concatenate (+ or &) operator performs string concatenation of its arguments.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#concatenate"
            }
          ]
        },
        {
          "code" : "string-operators.endwith",
          "display" : "String Operators endwith",
          "definition" : "The EndsWith operator returns true if the given string ends with the given suffix.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#endwith"
            }
          ]
        },
        {
          "code" : "string-operators.indexer",
          "display" : "String Operators indexer",
          "definition" : "The indexer ([]) operator returns the character at the indexth position in a string.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#indexer"
            }
          ]
        },
        {
          "code" : "string-operators.lastpositionof",
          "display" : "String Operators lastpositionof",
          "definition" : "The LastPositionOf operator returns the 0-based index of the last appearance of the given pattern in the given string.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#lastpositionof"
            }
          ]
        },
        {
          "code" : "string-operators.length",
          "display" : "String Operators length",
          "definition" : "The Length operator returns the number of characters in a string.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#length"
            }
          ]
        },
        {
          "code" : "string-operators.lower",
          "display" : "String Operators lower",
          "definition" : "The Lower operator returns the given string with all characters converted to their lower case equivalents.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#lower"
            }
          ]
        },
        {
          "code" : "string-operators.matches",
          "display" : "String Operators matches",
          "definition" : "The Matches operator returns true if the given string matches the given regular expression pattern. Regular expressions should function consistently, regardless of any culture- and locale-specific settings in the environment, should be case-sensitive, use partial matching, use single line mode, and allow Unicode characters. The start/end of line markers ^ and $ can be used to match the entire string.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#matches"
            }
          ]
        },
        {
          "code" : "string-operators.positionof",
          "display" : "String Operators positionof",
          "definition" : "The PositionOf operator returns the 0-based index of the given pattern in the given string.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#positionof"
            }
          ]
        },
        {
          "code" : "string-operators.replacematches",
          "display" : "String Operators replacematches",
          "definition" : "The ReplaceMatches operator matches the given string using the given regular expression pattern, replacing each match with the given substitution. The substitution string may refer to identified match groups in the regular expression. Regular expressions should function consistently, regardless of any culture- and locale-specific settings in the environment, should be case-sensitive, use partial matching, use single line mode, and allow Unicode characters. The start and end of line markers ^, $ can be used to match the entire string.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#replacematches"
            }
          ]
        },
        {
          "code" : "string-operators.split",
          "display" : "String Operators split",
          "definition" : "The Split operator splits a string into a list of strings using a separator.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#split"
            }
          ]
        },
        {
          "code" : "string-operators.splitonmatches",
          "display" : "String Operators splitonmatches",
          "definition" : "The SplitOnMatches operator splits a string into a list of strings using a separator that is defined by a regular expression pattern.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.3"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#splitonmatches"
            }
          ]
        },
        {
          "code" : "string-operators.startswith",
          "display" : "String Operators startswith",
          "definition" : "The StartsWith operator returns true if the given string starts with the given prefix.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#startswith"
            }
          ]
        },
        {
          "code" : "string-operators.substring",
          "display" : "String Operators substring",
          "definition" : "The Substring operator returns the string within stringToSub, starting at the 0-based index startIndex, and consisting of length characters.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#substring"
            }
          ]
        },
        {
          "code" : "string-operators.upper",
          "display" : "String Operators upper",
          "definition" : "The Upper operator returns the given string with all characters converted to their upper case equivalents.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#upper"
            }
          ]
        }
      ]
    },
    {
      "code" : "date-and-time-operators",
      "display" : "Date and Time Operators",
      "definition" : "Date/time arithmetic, components, now/today, comparisons, etc.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#date-and-time-operators"
        }
      ],
      "concept" : [
        {
          "code" : "date-and-time-operators.add",
          "display" : "Date and Time Operators add",
          "definition" : "The add (+) operator returns the value of the first argument, incremented by the time-valued quantity, respecting variable length periods for calendar years and months.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#add"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.after",
          "display" : "Date and Time Operators after",
          "definition" : "The after-precision-of operator compares two Date, DateTime, or Time values to the specified precision to determine whether the first argument is the after the second argument. The comparison is performed by considering each precision in order, beginning with years (or hours for time values). If the values are the same, comparison proceeds to the next precision; if the first value is greater than the second, the result is true; if the first value is less than the second, the result is false; if either input has no value for the precision, the comparison stops and the result is null; if the specified precision has been reached, the comparison stops and the result is false.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#after"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.before",
          "display" : "Date and Time Operators before",
          "definition" : "The before-precision-of operator compares two Date, DateTime, or Time values to the specified precision to determine whether the first argument is the before the second argument. The comparison is performed by considering each precision in order, beginning with years (or hours for time values). If the values are the same, comparison proceeds to the next precision; if the first value is less than the second, the result is true; if the first value is greater than the second, the result is false; if either input has no value for the precision, the comparison stops and the result is null; if the specified precision has been reached, the comparison stops and the result is false.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#before"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.date",
          "display" : "Date and Time Operators date",
          "definition" : "The Date operator constructs a date value from the given components.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#date"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.datetime",
          "display" : "Date and Time Operators datetime",
          "definition" : "The DateTime operator constructs a DateTime value from the given components.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#datetime"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.from",
          "display" : "Date and Time Operators from",
          "definition" : "The component-from operator returns the specified component of the argument.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#from"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.difference",
          "display" : "Date and Time Operators difference",
          "definition" : "The difference-between operator returns the number of boundaries crossed for the specified precision between the first and second arguments. If the first argument is after the second argument, the result is negative. The result of this operation is always an integer; any fractional boundaries are dropped.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#difference"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.duration",
          "display" : "Date and Time Operators duration",
          "definition" : "The duration-between operator returns the number of whole calendar periods for the specified precision between the first and second arguments. If the first argument is after the second argument, the result is negative. The result of this operation is always an integer; any fractional periods are dropped.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#duration"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.now",
          "display" : "Date and Time Operators now",
          "definition" : "The Now operator returns the date and time of the start timestamp associated with the evaluation request.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#now"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.on-or-after",
          "display" : "Date and Time Operators on or after",
          "definition" : "The on or after operator for Date, DateTime, and Time values is a synonym for the same or after operator and is supported to enable natural phrasing. See the description of the Same Or After (Date, DateTime, or Time) operator.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#on-or-after"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.on-or-before",
          "display" : "Date and Time Operators on or before",
          "definition" : "The on or before operator for Date, DateTime, and Time values is a synonym for the same or before operator and is supported to enable natural phrasing. See the description of the Same Or Before (Date, DateTime, or Time) operator.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#on-or-before"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.same-as",
          "display" : "Date and Time Operators same as",
          "definition" : "The same-precision-as operator compares two Date, DateTime, or Time values to the specified precision for equality. The comparison is performed by considering each precision in order, beginning with years (or hours for time values). If the values are the same, comparison proceeds to the next precision; if the values are different, the comparison stops and the result is false; if either input has no value for the precision, the comparison stops and the result is null; if the specified precision has been reached, the comparison stops and the result is true.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#same-as"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.same-or-after",
          "display" : "Date and Time Operators same or after",
          "definition" : "The same-precision-or after operator compares two Date, DateTime, or Time values to the specified precision to determine whether the first argument is the same or after the second argument. The comparison is performed by considering each precision in order, beginning with years (or hours for time values). If the values are the same, comparison proceeds to the next precision; if the first value is greater than the second, the result is true; if the first value is less than the second, the result is false; if either input has no value for the precision, the comparison stops and the result is null; if the specified precision has been reached, the comparison stops and the result is true.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#same-or-after"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.same-or-before",
          "display" : "Date and Time Operators same or before",
          "definition" : "The same-precision-or before operator compares two Date, DateTime, or Time values to the specified precision to determine whether the first argument is the same or before the second argument. The comparison is performed by considering each precision in order, beginning with years (or hours for time values). If the values are the same, comparison proceeds to the next precision; if the first value is less than the second, the result is true; if the first value is greater than the second, the result is false; if either input has no value for the precision, the comparison stops and the result is null; if the specified precision has been reached, the comparison stops and the result is true.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#same-or-before"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.subtract",
          "display" : "Date and Time Operators subtract",
          "definition" : "The subtract (-) operator returns the value of the given Date, DateTime, or Time, decremented by the time-valued quantity, respecting variable length periods for calendar years and months.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#subtract"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.time",
          "display" : "Date and Time Operators time",
          "definition" : "The Time operator constructs a time value from the given components.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#time"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.timeofday",
          "display" : "Date and Time Operators timeofday",
          "definition" : "The TimeOfDay operator returns the time of day of the start timestamp associated with the evaluation request. See the Now operator for more information on the rationale for defining the TimeOfDay operator in this way.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#timeofday"
            }
          ]
        },
        {
          "code" : "date-and-time-operators.today",
          "display" : "Date and Time Operators today",
          "definition" : "The Today operator returns the date of the start timestamp associated with the evaluation request. See the Now operator for more information on the rationale for defining the Today operator in this way.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#today"
            }
          ]
        }
      ]
    },
    {
      "code" : "interval-operators",
      "display" : "Interval Operators",
      "definition" : "contains, in, union, intersect, width, expand, etc.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#interval-operators-3"
        }
      ],
      "concept" : [
        {
          "code" : "interval-operators.after",
          "display" : "Interval Operators after",
          "definition" : "The after operator for intervals returns true if the first interval starts after the second one ends. In other words, if the starting point of the first interval is greater than the ending point of the second interval.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#after"
            }
          ]
        },
        {
          "code" : "interval-operators.before",
          "display" : "Interval Operators before",
          "definition" : "The before operator for intervals returns true if the first interval ends before the second one starts. In other words, if the ending point of the first interval is less than the starting point of the second interval.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#before"
            }
          ]
        },
        {
          "code" : "interval-operators.collapse",
          "display" : "Interval Operators collapse",
          "definition" : "The collapse operator returns the unique set of intervals that completely covers the ranges present in the given list of intervals. In other words, adjacent intervals within a sorted list are merged if they either overlap or meet.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#collapse"
            }
          ]
        },
        {
          "code" : "interval-operators.contains",
          "display" : "Interval Operators contains",
          "definition" : "The contains operator for intervals returns true if the given point is equal to the starting or ending point of the interval, or greater than the starting point and less than the ending point. For open interval boundaries, exclusive comparison operators are used. For closed interval boundaries, if the interval boundary is null, the result of the boundary comparison is considered true.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#contains"
            }
          ]
        },
        {
          "code" : "interval-operators.end",
          "display" : "Interval Operators end",
          "definition" : "The End operator returns the ending point of an interval.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#end"
            }
          ]
        },
        {
          "code" : "interval-operators.ends",
          "display" : "Interval Operators ends",
          "definition" : "The ends operator returns true if the first interval ends the second. More precisely, if the starting point of the first interval is greater than or equal to the starting point of the second, and the ending point of the first interval is equal to the ending point of the second.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#ends"
            }
          ]
        },
        {
          "code" : "interval-operators.equal",
          "display" : "Interval Operators equal",
          "definition" : "The equal (=) operator for intervals returns true if and only if the intervals are over the same point type, and they have the same value for the starting and ending points of the intervals as determined by the Start and End operators",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#"
            }
          ]
        },
        {
          "code" : "interval-operators.equivalent",
          "display" : "Interval Operators equivalent",
          "definition" : "The equivalent (~) operator for intervals returns true if and only if the intervals are over the same point type, and the starting and ending points of the intervals as determined by the Start and End operators are equivalent.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#equivalent"
            }
          ]
        },
        {
          "code" : "interval-operators.except",
          "display" : "Interval Operators except",
          "definition" : "The except operator for intervals returns the set difference of two intervals. More precisely, this operator returns the portion of the first interval that does not overlap with the second. Note that to avoid returning an improper interval, if the second argument is properly contained within the first and does not start or end it, this operator returns null.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#except"
            }
          ]
        },
        {
          "code" : "interval-operators.expand",
          "display" : "Interval Operators expand",
          "definition" : "The expand operator returns the set of intervals of size per for all the intervals in the input, or the list of points covering the range of the given interval, if invoked on a single interval.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#expand"
            }
          ]
        },
        {
          "code" : "interval-operators.in",
          "display" : "Interval Operators in",
          "definition" : "The in operator (can also be invoked using during) for intervals returns true if the given point is equal to the starting or ending point of the interval, or greater than the starting point and less than the ending point. For open interval boundaries, exclusive comparison operators are used. For closed interval boundaries, if the interval boundary is null, the result of the boundary comparison is considered true.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#in"
            }
          ]
        },
        {
          "code" : "interval-operators.includes",
          "display" : "Interval Operators includes",
          "definition" : "The includes operator for intervals returns true if the first interval completely includes the second. More precisely, if the starting point of the first interval is less than or equal to the starting point of the second interval, and the ending point of the first interval is greater than or equal to the ending point of the second interval.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#includes"
            }
          ]
        },
        {
          "code" : "interval-operators.included-in",
          "display" : "Interval Operators included in",
          "definition" : "The included in (or during) operator for intervals returns true if the first interval is completely included in the second. More precisely, if the starting point of the first interval is greater than or equal to the starting point of the second interval, and the ending point of the first interval is less than or equal to the ending point of the second interval.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#included-in"
            }
          ]
        },
        {
          "code" : "interval-operators.intersect",
          "display" : "Interval Operators intersect",
          "definition" : "The intersect operator for intervals returns the intersection of two intervals. More precisely, the operator returns the interval that defines the overlapping portion of both arguments. If the arguments do not overlap, this operator returns null.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#intersect"
            }
          ]
        },
        {
          "code" : "interval-operators.meets",
          "display" : "Interval Operators meets",
          "definition" : "The meets operator returns true if the first interval ends immediately before the second interval starts, or if the first interval starts immediately after the second interval ends. In other words, if the ending point of the first interval is equal to the predecessor of the starting point of the second, or if the starting point of the first interval is equal to the successor of the ending point of the second.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#meets"
            }
          ]
        },
        {
          "code" : "interval-operators.not-equal",
          "display" : "Interval Operators not equal",
          "definition" : "The not equal (!=) operator for intervals returns true if its arguments are not the same value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#not-equal"
            }
          ]
        },
        {
          "code" : "interval-operators.not-equivalent",
          "display" : "Interval Operators not equivalent",
          "definition" : "The not equivalent (!~) operator for intervals returns true if its arguments are not equivalent.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#not-equivalent"
            }
          ]
        },
        {
          "code" : "interval-operators.on-or-after",
          "display" : "Interval Operators on or after",
          "definition" : "The on or after operator for intervals is a synonym for the same or after operator and is supported to enable natural phrasing. See the description of the Same Or After (Intervals) operator.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#on-or-after"
            }
          ]
        },
        {
          "code" : "interval-operators.on-or-before",
          "display" : "Interval Operators on or before",
          "definition" : "The on or before operator for Date-, DateTime-, or Time-based intervals is a synonym for the same or before operator and is supported to enable natural phrasing. See the description of the Same Or Before (Intervals) operator.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#on-or-before"
            }
          ]
        },
        {
          "code" : "interval-operators.overlaps",
          "display" : "Interval Operators overlaps",
          "definition" : "The overlaps operator returns true if the first interval overlaps the second. More precisely, if the starting or ending point of either interval is in the other, or if the ending point of the first interval is greater than or equal to the starting point of the second interval, and the starting point of the first interval is less than or equal to the ending point of the second interval.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#overlaps"
            }
          ]
        },
        {
          "code" : "interval-operators.point-from",
          "display" : "Interval Operators point from",
          "definition" : "The point from operator extracts the single point from a unit interval. If the argument is not a unit interval, a run-time error is thrown.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#point-from"
            }
          ]
        },
        {
          "code" : "interval-operators.properly-includes",
          "display" : "Interval Operators properly includes",
          "definition" : "The properly includes operator for intervals returns true if the first interval completely includes the second and the first interval is strictly larger than the second. More precisely, if the starting point of the first interval is less than or equal to the starting point of the second interval, and the ending point of the first interval is greater than or equal to the ending point of the second interval, and they are not the same interval.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#properly-includes"
            }
          ]
        },
        {
          "code" : "interval-operators.properly-included-in",
          "display" : "Interval Operators properly included in",
          "definition" : "The properly included in (or properly during) operator for intervals returns true if the first interval is completely included in the second and the first interval is strictly smaller than the second. More precisely, if the starting point of the first interval is greater than or equal to the starting point of the second interval, and the ending point of the first interval is less than or equal to the ending point of the second interval, and they are not the same interval.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#included-in"
            }
          ]
        },
        {
          "code" : "interval-operators.same-as",
          "display" : "Interval Operators same as",
          "definition" : "The same-precision-as operator for intervals returns true if the two intervals start and end at the same value, using the semantics described in the Start and End operators to determine interval boundaries, and for Date, DateTime, or Time value, performing the comparisons at the specified precision, as described in the Same As operator for Date, DateTime, or Time values.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#same-as"
            }
          ]
        },
        {
          "code" : "interval-operators.same-or-after",
          "display" : "Interval Operators same or after",
          "definition" : "The same-precision-or after operator for intervals returns true if the first interval starts on or after the second one ends, using the semantics described in the Start and End operators to determine interval boundaries, and for Date, DateTime, or Time values, performing the comparisons at the specified precision, as described in the Same or After (Date, DateTime, or Time) operator for Date, DateTime, or Time values.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#same-or-after"
            }
          ]
        },
        {
          "code" : "interval-operators.same-or-before",
          "display" : "Interval Operators same or before",
          "definition" : "The same-precision-or before operator returns true if the first interval ends on or before the second one starts, using the semantics described in the Start and End operators to determine interval boundaries, and for Date, DateTime, or Time values, performing the comparisons at the specified precision, as described in the Same or Before (Date, DateTime, or Time) operator for Date, DateTime, or Time values.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#same-or-before"
            }
          ]
        },
        {
          "code" : "interval-operators.size",
          "display" : "Interval Operators size",
          "definition" : "The Size operator returns the size of an interval. The result of this operator is equivalent to invoking: (end of argument – start of argument) + point-size, where point-size is determined by successor of minimum T - minimum T.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#size"
            }
          ]
        },
        {
          "code" : "interval-operators.start",
          "display" : "Interval Operators start",
          "definition" : "The Start operator returns the starting point of an interval.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#start"
            }
          ]
        },
        {
          "code" : "interval-operators.starts",
          "display" : "Interval Operators starts",
          "definition" : "The starts operator returns true if the first interval starts the second. More precisely, if the starting point of the first is equal to the starting point of the second interval and the ending point of the first interval is less than or equal to the ending point of the second interval.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#starts"
            }
          ]
        },
        {
          "code" : "interval-operators.union",
          "display" : "Interval Operators union",
          "definition" : "The union operator for intervals returns the union of the intervals. More precisely, the operator returns the interval that starts at the earliest starting point in either argument, and ends at the latest starting point in either argument. If the arguments do not overlap or meet, this operator returns null.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#union"
            }
          ]
        },
        {
          "code" : "interval-operators.width",
          "display" : "Interval Operators width",
          "definition" : "The width operator returns the width of an interval. The result of this operator is equivalent to invoking: (end of argument – start of argument).",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#width"
            }
          ]
        }
      ]
    },
    {
      "code" : "list-operators",
      "display" : "List Operators",
      "definition" : "size, first/last, contains, union/intersect/except, map/filter/distinct, sort/reverse/zip, etc.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#list-operators"
        }
      ],
      "concept" : [
        {
          "code" : "list-operators.contains",
          "display" : "List Operators contains",
          "definition" : "The contains operator for lists returns true if the given element is in the list using equality semantics, with the exception that null elements are considered equal.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#contains"
            }
          ]
        },
        {
          "code" : "list-operators.distinct",
          "display" : "List Operators distinct",
          "definition" : "The distinct operator returns the given list with duplicates eliminated using equality semantics.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#distinct"
            }
          ]
        },
        {
          "code" : "list-operators.equal",
          "display" : "List Operators equal",
          "definition" : "The equal (=) operator for lists returns true if and only if the lists have the same element type, and have the same elements by value, in the same order.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#equal"
            }
          ]
        },
        {
          "code" : "list-operators.equivalent",
          "display" : "List Operators equivalent",
          "definition" : "The equivalent (~) operator for lists returns true if and only if the lists contain elements of the same type, have the same number of elements, and for each element in the lists, in order, the elements are equivalent.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#equivalent"
            }
          ]
        },
        {
          "code" : "list-operators.except",
          "display" : "List Operators except",
          "definition" : "The except operator returns the set difference of two lists. More precisely, the operator returns a list with the elements that appear in the first operand that do not appear in the second operand.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#except"
            }
          ]
        },
        {
          "code" : "list-operators.exists",
          "display" : "List Operators exists",
          "definition" : "The exists operator returns true if the list contains any non-null elements.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#exists"
            }
          ]
        },
        {
          "code" : "list-operators.flatten",
          "display" : "List Operators flatten",
          "definition" : "The flatten operator flattens a list of lists into a single list.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#flatten"
            }
          ]
        },
        {
          "code" : "list-operators.first",
          "display" : "List Operators first",
          "definition" : "The First operator returns the first element in a list. The operator is equivalent to invoking the indexer with an index of 0.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#first"
            }
          ]
        },
        {
          "code" : "list-operators.in",
          "display" : "List Operators in",
          "definition" : "The in operator for lists returns true if the given element is in the given list using equality semantics, with the exception that null elements are considered equal.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#in"
            }
          ]
        },
        {
          "code" : "list-operators.includes",
          "display" : "List Operators includes",
          "definition" : "The includes operator for lists returns true if the first list contains every element of the second list using equality semantics, with the exception that null elements are considered equal.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#includes"
            }
          ]
        },
        {
          "code" : "list-operators.included_in",
          "display" : "List Operators included in",
          "definition" : "The included in operator for lists returns true if every element of the first list is in the second list using equality semantics.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#included-in"
            }
          ]
        },
        {
          "code" : "list-operators.indexer",
          "display" : "List Operators indexer",
          "definition" : "The indexer ([]) operator returns the element at the indexth position in a list.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#indexer"
            }
          ]
        },
        {
          "code" : "list-operators.indexof",
          "display" : "List Operators IndexOf",
          "definition" : "The IndexOf operator returns the 0-based index of the given element in the given source list using equality semantics, with the exception that nulls are considered equal.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#indexof"
            }
          ]
        },
        {
          "code" : "list-operators.intersect",
          "display" : "List Operators intersect",
          "definition" : "The intersect operator for lists returns the intersection of two lists. More precisely, the operator returns a list containing only the elements that appear in both lists.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#intersect"
            }
          ]
        },
        {
          "code" : "list-operators.last",
          "display" : "List Operators last",
          "definition" : "The Last operator returns the last element in a list. In a list of length N, the operator is equivalent to invoking the indexer with an index of N - 1",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#last"
            }
          ]
        },
        {
          "code" : "list-operators.length",
          "display" : "List Operators length",
          "definition" : "The Length operator returns the number of elements in a list.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#length"
            }
          ]
        },
        {
          "code" : "list-operators.not_equal",
          "display" : "List Operators not equal",
          "definition" : "The not equal (!=) operator for lists returns true if its arguments are not the same value.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#not_equal"
            }
          ]
        },
        {
          "code" : "list-operators.not_equivalent",
          "display" : "List Operators not equivalent",
          "definition" : "The not equivalent (!~) operator for lists returns true if its arguments are not equivalent.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#not_equivalent"
            }
          ]
        },
        {
          "code" : "list-operators.properly_includes",
          "display" : "List Operators properly includes",
          "definition" : "The properly includes operator for lists returns true if the first list contains every element of the second list, and the first list is strictly larger than the second list.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#properly_includes"
            }
          ]
        },
        {
          "code" : "list-operators.properly_included_in",
          "display" : "List Operators properly included in",
          "definition" : "The properly included in operator for lists returns true if every element of the first list is in the second list and the first list is strictly smaller than the second list.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#properly_included_in"
            }
          ]
        },
        {
          "code" : "list-operators.singleton_from",
          "display" : "List Operators singleton from",
          "definition" : "The singleton from operator extracts a single element from the source list. If the source list is empty, the result is null. If the source list contains one element, that element is returned. If the list contains more than one element, a run-time error is thrown.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#singleton_from"
            }
          ]
        },
        {
          "code" : "list-operators.skip",
          "display" : "List Operators skip",
          "definition" : "The Skip operator returns the elements in the list, skipping the first number elements. If the list has less number elements, the result is empty.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#skip"
            }
          ]
        },
        {
          "code" : "list-operators.tail",
          "display" : "List Operators tail",
          "definition" : "The Tail operator returns all but the first element from the given list. If the list is empty, the result is empty.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#tail"
            }
          ]
        },
        {
          "code" : "list-operators.take",
          "display" : "List Operators take",
          "definition" : "The Take operator returns the first number elements from the given list. If the list has less than number elements, the result only contains the elements in the list.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#take"
            }
          ]
        },
        {
          "code" : "list-operators.union",
          "display" : "List Operators union",
          "definition" : "The union operator for lists returns a list with all unique elements from both arguments.",
          "property" : [
            {
              "code" : "version",
              "valueString" : "1.0"
            },
            {
              "code" : "reference",
              "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#union"
            }
          ]
        }
      ]
    },
    {
      "code" : "aggregate-functions",
      "display" : "Aggregate Functions",
      "definition" : "count, sum, min, max, average, median, mode, etc.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#aggregate-functions"
        }
      ]
    },
    {
      "code" : "clinical-operators",
      "display" : "Clinical Operators",
      "definition" : "Retrieve/terminology functions; temporal/duration in clinical context.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#clinical-operators"
        }
      ]
    },
    {
      "code" : "diagnostic-operators",
      "display" : "Diagnostic Operators",
      "definition" : "Errors and messaging functions.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#errors-and-messaging"
        }
      ]
    },
    {
      "code" : "single-source-query",
      "display" : "Single source query",
      "definition" : "Query over one source.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/74-queryevaluation.html#evaluate-sources"
        }
      ]
    },
    {
      "code" : "relationships-query",
      "display" : "Relationships query",
      "definition" : "Query involving two or more sources.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/74-queryevaluation.html#evaluate-sources"
        }
      ]
    },
    {
      "code" : "let-clause-query",
      "display" : "Let clause query",
      "definition" : "Introduce local bindings.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/74-queryevaluation.html#let-clause"
        }
      ]
    },
    {
      "code" : "where-clause-query",
      "display" : "Where clause query",
      "definition" : "Filter using Boolean conditions.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/74-queryevaluation.html#where-clause"
        }
      ]
    },
    {
      "code" : "return-clause-query",
      "display" : "Return clause query",
      "definition" : "Specify the shape/content of returned rows.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/74-queryevaluation.html#return-clause"
        }
      ]
    },
    {
      "code" : "aggregate-clause-query",
      "display" : "Aggregate clause query",
      "definition" : "Reduce rows to a summary value.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/74-queryevaluation.html#aggregate-clause"
        }
      ]
    },
    {
      "code" : "multi-source-query",
      "display" : "Multi source query",
      "definition" : "Query using two or more sources.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/74-queryevaluation.html#evaluate-sources"
        }
      ]
    },
    {
      "code" : "unfiltered-context-retrieve",
      "display" : "Unfiltered context retrieve",
      "definition" : "All data of a type in the current context.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#language-capabilities"
        }
      ]
    },
    {
      "code" : "terminology-based-retrieve",
      "display" : "Terminology-based retrieve",
      "definition" : "Retrieve filtered by ValueSet/CodeSystem/Code.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#retrieve-paths"
        }
      ]
    },
    {
      "code" : "valueset-terminology-target-retrieve",
      "display" : "Valueset terminology target retrieve",
      "definition" : "Retrieve filtered by a ValueSet reference.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#retrieve-paths"
        }
      ]
    },
    {
      "code" : "codesystem-terminology-target-retrieve",
      "display" : "CodeSystem terminology target retrieve",
      "definition" : "Retrieve filtered by a CodeSystem.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#retrieve-paths"
        }
      ]
    },
    {
      "code" : "code-terminology-target-retrieve",
      "display" : "Code terminology target retrieve",
      "definition" : "Retrieve filtered by a single Code.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#retrieve-paths"
        }
      ]
    },
    {
      "code" : "searchpath-retrieve",
      "display" : "Searchpath retrieve",
      "definition" : "Retrieve using a search path expression.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#retrieve-paths"
        }
      ]
    },
    {
      "code" : "include-retrieve",
      "display" : "Include retrieve",
      "definition" : "Retrieve that includes related records via references.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#retrieve-paths"
        }
      ]
    },
    {
      "code" : "related-context-retrieve",
      "display" : "Related-context retrieve",
      "definition" : "Retrieve scoped to a related context entity.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/05-languagesemantics.html#retrieve-paths"
        }
      ]
    },
    {
      "code" : "profile-based-retrieve",
      "display" : "Profile-based retrieve",
      "definition" : "Retrieve constrained to a profile.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/42-conformancelevels.html#strict-conformance"
        }
      ]
    },
    {
      "code" : "tuple",
      "display" : "Tuple",
      "definition" : "Structured type with named elements.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/63-expressionlanguagesemantics.html#structured-types"
        }
      ]
    },
    {
      "code" : "choice",
      "display" : "Choice",
      "definition" : "Value that may be one of several specified types.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/63-expressionlanguagesemantics.html#choice-types"
        }
      ]
    },
    {
      "code" : "list<T>",
      "display" : "List<T>",
      "definition" : "Ordered collection of elements of type T.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/63-expressionlanguagesemantics.html#collection-types"
        }
      ]
    },
    {
      "code" : "interval<T>",
      "display" : "Interval<T>",
      "definition" : "Range of values of type T.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#interval-operators-3"
        }
      ]
    },
    {
      "code" : "interval<integer>",
      "display" : "Interval<Integer>",
      "definition" : "Range of integers.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#interval-operators-3"
        }
      ]
    },
    {
      "code" : "interval<decimal>",
      "display" : "Interval<Decimal>",
      "definition" : "Range of decimal numbers.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#interval-operators-3"
        }
      ]
    },
    {
      "code" : "interval<date>",
      "display" : "Interval<Date>",
      "definition" : "Range of dates (no time).",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#interval-operators-3"
        }
      ]
    },
    {
      "code" : "interval<time>",
      "display" : "Interval<Time>",
      "definition" : "Range of times of day (no date).",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#interval-operators-3"
        }
      ]
    },
    {
      "code" : "interval<datetime>",
      "display" : "Interval<DateTime>",
      "definition" : "Range of full date/times.",
      "property" : [
        {
          "code" : "version",
          "valueString" : "1.0"
        },
        {
          "code" : "reference",
          "valueString" : "https://cql.hl7.org/09-b-cqlreference.html#interval-operators-3"
        }
      ]
    }
  ]
}

```
