# Terminology - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Terminology

### Value Sets

* [RTPBC Billing Unit](ValueSet-rtpbc-billing-unit.md)
* [RTPBC Country Code](ValueSet-rtpbc-country-code.md)
* [RTPBC Benefit Restriction](ValueSet-rtpbc-benefit-restriction.md)
* [RTPBC Error Code](ValueSet-rtpbc-error-code.md)
* [RTPBC Event Type](ValueSet-rtpbc-event-type.md)
* [RTPBC Patient Pay Type](ValueSet-rtpbc-patient-pay-type.md)
* [RTPBC Pharmacy Type](ValueSet-rtpbc-pharmacy-type.md)
* [RTPBC Prescribable Product Code](ValueSet-rtpbc-prescribable-product-code.md)
* [RTPBC State and Province Code](ValueSet-rtpbc-state-and-province-code.md)

### Code Systems

**Code systems defined for use in the consumer Real-time Prescription Benefit Check (RTPBC) process**

The following code systems define consumer-friendly insurance coverage concepts for use in RTPBC responses:

* [RTPBC Benefit Restriction](CodeSystem-rtpbc-benefit-restriction.md)
* [RTPBC Event Type](CodeSystem-rtpbc-event-type.md)
* [RTPBC Patient Pay Type](CodeSystem-rtpbc-patient-pay-type.md)

### Code and identifier systems maintained by other organizations

* [NCPDP Provider ID](https://terminology.hl7.org/CodeSystem-NCPDPProviderIdentificationNumber.html)
* [NCPDP Reject Code (511-FB)](https://terminology.hl7.org/CodeSystem-NCPDPRejectCode.html)
* [NCPDP Pharmacy Type (955-HR)](https://terminology.hl7.org/CodeSystem-NCPDPPharmacyType.html)
* [Canada Post Province Code](https://terminology.hl7.org/CodeSystem-CanadaProvinceCodes.html)

