# Profiles - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Profiles

### Profiles

| | |
| :--- | :--- |
| [RTPBC Request Profile (Claim)](StructureDefinition-rtpbc-request-claim.md) | This profile constrains the Claim resource so that it can serve as the RTPBC Request in the consumer real-time pharmacy benefit check process. |
| [RTPBC Response Profile (ClaimResponse)](StructureDefinition-rtpbc-response-claimresponse.md) | This profile constrains the ClaimResponse resource to serve as the RTPBC Response in the consumer real-time pharmacy benefit check process. It uses the ClaimResponse's "predetermination" processing mode. |
| [RTPBC Patient Profile](StructureDefinition-rtpbc-patient.md) | This profile constrains the Patient resource for carrying the limited patient information required in the consumer real-time pharmacy benefit check (RTPBC) process. In RTPBC, the sole purpose of patient information is to enable the responding payer/PBM to locate the patient's insurance information. From there, pricing and coverage information is determined based on the patient's member and coverage information maintained by the payer. |
| [RTPBC Medication Request Profile](StructureDefinition-rtpbc-medicationrequest.md) | This profile constrains the MedicationRequest resource to convey a subset of prescription information required in the consumer real-time pharmacy benefit check (RTPBC) process. The content specifies the prescribed product and quantity, and references the prescribing practitioner and the patients' preferred pharmacy. |
| US Core Practitioner Profile | This implementation guide uses the US Core Practitioner profile with no additional constraints. |
| [RTPBC Pharmacy Profile (Organization)](StructureDefinition-rtpbc-pharmacy-organization.md) | This profile represents a pharmacy as used in the real-time pharmacy benefit check (RTPBC) process. This profile is based on the US Core Organization profile. |
| [RTPBC Coverage Profile](StructureDefinition-rtpbc-coverage.md) | This profile constrains the Coverage resource for conveying the patient's pharmacy benefit information in an RTPBC request to an insurer. |
| [RTPBC Request Message Header Profile](StructureDefinition-rtpbc-request-messageheader.md) | This profile constrains a MessageHeader resource for use in a Real-time Pharmacy Benefit Check (RTPBC) request bundle. |
| [RTPBC Response Message Header Profile](StructureDefinition-rtpbc-response-messageheader.md) | This profile constrains a MessageHeader resource for use in a Real-time Pharmacy Benefit Check (RTPBC) response bundle. |
| [RTPBC Request Bundle Profile](StructureDefinition-rtpbc-request-bundle.md) | This profile constrains a Bundle resource for use as the request in a Real-time Pharmacy Benefit Check (RTPBC) process. |
| [RTPBC Response Bundle Profile](StructureDefinition-rtpbc-response-bundle.md) | This profile constrains a Bundle resource for use as the response in a Real-time Pharmacy Benefit Check (RTPBC) process. |

### Extensions

| | |
| :--- | :--- |
| [RTPBC IsAlternative Extension](StructureDefinition-rtpbc-isAlternative.md) | This extension indicates that an added line item is to be interpreted as one of possibly multiple alternatives to the requested product or service. When isAlternative is true, the added line item is to be considered independently from any other added line items associated with the requested product or service. |
| [RTPBC BenefitRestriction Extension](StructureDefinition-rtpbc-benefitRestriction.md) | This extension conveys benefit restrictions that apply to a prescription product and pharmacy combination. |

### Message Definitions

| | |
| :--- | :--- |
| [RTPBC Request MessageDefinition](MessageDefinition-rtpbc-request.md) | Request for patient cost and coverage information for a prescribed medication |
| [RTPBC Response MessageDefinition](MessageDefinition-rtpbc-response.md) | Response to a request for patient cost and coverage information for a prescribed medication |

