# Home - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Home

> The STU2 version of the Consumer RTPBC guide expands information that clients can retrieve from a patient's insurer and other data sources, provides additional guidance, and refines other aspects based on implementer feedback,

Where possible, new content is highlighted with green text and background. This highlighting will be removed prior to publication.

Sections with additions or adjustments are noted in yellow.

**** To do: Add plain language description. ****

### Overview

This section has be adjusted. *Modifications are italicized.*

This is a guide for implementing a **consumer-focused Real-time Pharmacy Benefit Check** (RTPBC) process using HL7 FHIR® R4.

Using RTPBC, a patient can learn the cost, insurance coverage **and other information** related to medications they've been prescribed. Specifically…

* how a medication will be covered by their insurance, including out of pocket costs and any coverage restrictions or requirements that might apply
* **cash pricing and** discounts available for the medication
* **availability of financial assistance or other support.**

Consumer RTPBC leverages the predetermination process supported by the Claim and ClaimResponse FHIR® resources. Accompanying resources carry information that identifies the patient and their insurance coverage, prescription information and the preferred pharmacy (Patient, Coverage, MedicationRequest, Practitioner and Organization). OperationOutcome is used to communicate exceptions.

Where possible, the profile leverages terminology currently used in US pharmacy benefit processing, to minimize implementation obstacles for stakeholders who operate in that domain. 

### Scope of this guide

**Consumer RTPBC is intended to be used…**

* in the United States (as it reflects unique US pharmacy insurance roles and conventions)
* for medications that are covered under the **pharmacy benefit** portion of the patient's health insurance, which typically excludes medications administered during hospital care or as part of medical procedures
* for commercially available medication products that are not compounded at the pharmacy. **(Support for compounds could potentially be added later)**

**Relationship to the NCPDP provider-focused RTPBC transactions**

This section has be adjusted. *Modifications are italicized.*

**The consumer RTPBC profile seeks to provide a patients with coverage and cost information that's consistent with information made available to their provider through the NCPDP Real Time Prescription Benefit (RTPB) standard.**

**Because this specification focuses on what's most useful and meaningful to patients,** certain content in the provider-centric NCPDP RTPBC standard is not included here. (See [Consumer vs provider RTPBC](consumer_vs_provider_rtpbc.md) for a content comparison.)

**Related information flows outside of consumer RTPBC**

The patient application might gather related information before submitting the consumer RTPBC request, such as prescription information or insurance eligibility. These exchanges are outside the scope of this guide.

**Support for addresses outside the US**

This implementation guide supports military and Canadian addresses for patients and pharmacies, in order to be consistent with other US pharmacy benefit processes. Specifically, the guide enables use of Canada province codes and military 'state' codes (e.g., AE for Armed Forces Europe). 

### Content and Organization

This section is new in STU2

The guide is organized into the following sections:

* [Use Case Overview](use_case.md) describes the RTPBC use case, participants and high-level exchange flows.
* [Information Content](information_content_and_fhir_resources.md) describes what's in the RTPBC request and response.
* [Business Rules](business_rules.md) highlights non-technical content and behavior expectations for requesters and responders.
* [Submission Method](submission_method.md) provides key points about the IG's use of FHIR messaging.
* [Error Handling](error_handling.md) sets expectations on reporting technical and business response errors.
* [Mappings to Related Standards](mappings.md) describes how FHIR content relates to other standards use in the larger PDMP ecosystem.
* [Security](security.md) provides direction on use of SMART on FHIR to secure RTPBC exchanges.
* [Provider vs Consumer RTPBC](consumer_vs_provider_rtpbc.md) provides a comparison of this guide to provider-facing messaging defined in the NCPDP RTPB standard.
* [Artifacts](artifacts.md) contains the FHIR profiles and other artifacts defined in this IG.

### Authors

| | |
| :--- | :--- |
| HL7 Pharmacy Workgroup |  |
| HL7 Financial Management Workgroup |  |
| Frank McKinney | [fm@frankmckinney.com](mailto:fm@frankmckinney.com) |

### Dependencies






### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.us.carin-rtpbc.r4)](../package.r4.tgz) and [R4B (hl7.fhir.us.carin-rtpbc.r4b)](../package.r4b.tgz) are available.

### Global Profiles

*There are no Global profiles defined*

### IP Statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/5.5.0/CodeSystem-ISO3166Part1.html): [ConsumerRealTimePharmacyBenefitCheck](index.md), [RTPBCPrescribableProductCodeValueSet](ValueSet-rtpbc-prescribable-product-code.md)...Show 36 more,[RtbpcBenefitRestrictionValueSet](ValueSet-rtpbc-benefit-restriction.md),[RtbpcBillingUnitValueSet](ValueSet-rtpbc-billing-unit.md),[RtbpcErrorCodeValueSet](ValueSet-rtpbc-error-code.md),[RtbpcEventTypeValueSet](ValueSet-rtpbc-event-type.md),[RtbpcFormularyStatusValueSet](ValueSet-rtpbc-formulary-status.md),[RtbpcPatientPayTypeValueSet](ValueSet-rtpbc-patient-pay-type.md),[RtpbcBenefitRestrictionCodeSystem](CodeSystem-rtpbc-benefit-restriction.md),[RtpbcCountryCodeValueSet](ValueSet-rtpbc-country-code.md),[RtpbcCoverage](StructureDefinition-rtpbc-coverage.md),[RtpbcEventTypeCodeSystem](CodeSystem-rtpbc-event-type.md),[RtpbcExtensionBenefitRestriction](StructureDefinition-rtpbc-benefitRestriction.md),[RtpbcExtensionFormularyStatus](StructureDefinition-rtpbc-formularyStatus.md),[RtpbcExtensionNextAvailableFillDate](StructureDefinition-rtpbc-nextAvailableFillDate.md),[RtpbcExtensionPreferenceLevel](StructureDefinition-rtpbc-preferenceLevel.md),[RtpbcFormularyStatusCodeSystem](CodeSystem-rtpbc-formulary-status.md),[RtpbcIsAlternativeExtension](StructureDefinition-rtpbc-isAlternative.md),[RtpbcMedicationRequest](StructureDefinition-rtpbc-medicationrequest.md),[RtpbcMedicationRequestNonPHI](StructureDefinition-rtpbc-medicationrequest-non-phi.md),[RtpbcPatient](StructureDefinition-rtpbc-patient.md),[RtpbcPatientNonPHI](StructureDefinition-rtpbc-patient-non-phi.md),[RtpbcPatientPayTypeCodeSystem](CodeSystem-rtpbc-patient-pay-type.md),[RtpbcPharmacy](StructureDefinition-rtpbc-pharmacy-organization.md),[RtpbcPharmacyTypeValueSet](ValueSet-rtpbc-pharmacy-type.md),[RtpbcRequest](MessageDefinition-rtpbc-request.md),[RtpbcRequestBundle](StructureDefinition-rtpbc-request-bundle.md),[RtpbcRequestBundleNonPHI](StructureDefinition-rtpbc-request-bundle-non-phi.md),[RtpbcRequestClaim](StructureDefinition-rtpbc-request-claim.md),[RtpbcRequestClaimNonPHI](StructureDefinition-rtpbc-request-claim-non-phi.md),[RtpbcRequestMessageHeader](StructureDefinition-rtpbc-request-messageheader.md),[RtpbcRequesterCapabilityStatement](CapabilityStatement-rtpbc-requester.md),[RtpbcResponderCapabilityStatement](CapabilityStatement-rtpbc-responder.md),[RtpbcResponse](MessageDefinition-rtpbc-response.md),[RtpbcResponseBundle](StructureDefinition-rtpbc-response-bundle.md),[RtpbcResponseClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md),[RtpbcResponseMessageHeader](StructureDefinition-rtpbc-response-messageheader.md)and[RtpbcStateAndProvinceCodeValueSet](ValueSet-rtpbc-state-and-province-code.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/5.5.0/CodeSystem-v3-ucum.html): [RtbpcBillingUnitValueSet](ValueSet-rtpbc-billing-unit.md), [RtpbcMedicationRequest](StructureDefinition-rtpbc-medicationrequest.md)...Show 4 more,[RtpbcMedicationRequestNonPHI](StructureDefinition-rtpbc-medicationrequest-non-phi.md),[RtpbcRequestClaim](StructureDefinition-rtpbc-request-claim.md),[RtpbcRequestClaimNonPHI](StructureDefinition-rtpbc-request-claim-non-phi.md)and[RtpbcResponseClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Claim Type Codes](http://terminology.hl7.org/7.0.1/CodeSystem-claim-type.html): [Bundle/rtpbc-bundle-request-03](Bundle-rtpbc-bundle-request-03.md), [Bundle/rtpbc-bundle-request-non-phi-1](Bundle-rtpbc-bundle-request-non-phi-1.md)...Show 10 more,[Bundle/rtpbc-bundle-request-non-phi-2](Bundle-rtpbc-bundle-request-non-phi-2.md),[Bundle/rtpbc-bundle-request-price-source](Bundle-rtpbc-bundle-request-price-source.md),[Bundle/rtpbc-bundle-response-03](Bundle-rtpbc-bundle-response-03.md),[Bundle/rtpbc-bundle-response-price-source](Bundle-rtpbc-bundle-response-price-source.md),[Claim/rtpbc-claim-03](Claim-rtpbc-claim-03.md),[Claim/rtpbc-claim-non-phi-1](Claim-rtpbc-claim-non-phi-1.md),[Claim/rtpbc-claim-non-phi-2](Claim-rtpbc-claim-non-phi-2.md),[ClaimResponse/rtpbc-claim-response-03](ClaimResponse-rtpbc-claim-response-03.md),[ClaimResponse/rtpbc-claim-response-03-price-source](ClaimResponse-rtpbc-claim-response-03-price-source.md)and[ClaimResponse/rtpbc-claim-response-not-covered](ClaimResponse-rtpbc-claim-response-not-covered.md)
* [Coverage Class Codes](http://terminology.hl7.org/7.0.1/CodeSystem-coverage-class.html): [Bundle/rtpbc-bundle-request-03](Bundle-rtpbc-bundle-request-03.md), [Coverage/rtpbc-coverage-01](Coverage-rtpbc-coverage-01.md) and [RtpbcCoverage](StructureDefinition-rtpbc-coverage.md)
* [Process Priority Codes](http://terminology.hl7.org/7.0.1/CodeSystem-processpriority.html): [Bundle/rtpbc-bundle-request-03](Bundle-rtpbc-bundle-request-03.md), [Bundle/rtpbc-bundle-request-non-phi-1](Bundle-rtpbc-bundle-request-non-phi-1.md)...Show 5 more,[Bundle/rtpbc-bundle-request-non-phi-2](Bundle-rtpbc-bundle-request-non-phi-2.md),[Bundle/rtpbc-bundle-request-price-source](Bundle-rtpbc-bundle-request-price-source.md),[Claim/rtpbc-claim-03](Claim-rtpbc-claim-03.md),[Claim/rtpbc-claim-non-phi-1](Claim-rtpbc-claim-non-phi-1.md)and[Claim/rtpbc-claim-non-phi-2](Claim-rtpbc-claim-non-phi-2.md)
* [SubscriberPolicyholder Relationship Codes](http://terminology.hl7.org/7.0.1/CodeSystem-subscriber-relationship.html): [Bundle/rtpbc-bundle-request-03](Bundle-rtpbc-bundle-request-03.md) and [Coverage/rtpbc-coverage-01](Coverage-rtpbc-coverage-01.md)
* [identifierType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0203.html): [Bundle/rtpbc-bundle-request-03](Bundle-rtpbc-bundle-request-03.md), [Bundle/rtpbc-bundle-request-price-source](Bundle-rtpbc-bundle-request-price-source.md)...Show 5 more,[Bundle/rtpbc-bundle-response-03](Bundle-rtpbc-bundle-response-03.md),[Bundle/rtpbc-bundle-response-price-source](Bundle-rtpbc-bundle-response-price-source.md),[Patient/rtpbc-patient-03](Patient-rtpbc-patient-03.md),[Patient/rtpbc-patient-03ps](Patient-rtpbc-patient-03ps.md)and[RtpbcCoverage](StructureDefinition-rtpbc-coverage.md)


* Using RxNorm codes of type SAB=RXNORM as this specification describes does not require a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right.

* [RxNorm](http://terminology.hl7.org/5.5.0/CodeSystem-v3-rxNorm.html): [Bundle/rtpbc-bundle-request-03](Bundle-rtpbc-bundle-request-03.md), [Bundle/rtpbc-bundle-request-price-source](Bundle-rtpbc-bundle-request-price-source.md)...Show 13 more,[Bundle/rtpbc-bundle-response-03](Bundle-rtpbc-bundle-response-03.md),[Bundle/rtpbc-bundle-response-price-source](Bundle-rtpbc-bundle-response-price-source.md),[Claim/rtpbc-claim-03](Claim-rtpbc-claim-03.md),[ClaimResponse/rtpbc-claim-response-03](ClaimResponse-rtpbc-claim-response-03.md),[ClaimResponse/rtpbc-claim-response-03-price-source](ClaimResponse-rtpbc-claim-response-03-price-source.md),[ClaimResponse/rtpbc-claim-response-not-covered](ClaimResponse-rtpbc-claim-response-not-covered.md),[MedicationRequest/rtpbc-medicationrequest-03](MedicationRequest-rtpbc-medicationrequest-03.md),[RTPBCPrescribableProductCodeValueSet](ValueSet-rtpbc-prescribable-product-code.md),[RtpbcMedicationRequest](StructureDefinition-rtpbc-medicationrequest.md),[RtpbcMedicationRequestNonPHI](StructureDefinition-rtpbc-medicationrequest-non-phi.md),[RtpbcRequestClaim](StructureDefinition-rtpbc-request-claim.md),[RtpbcRequestClaimNonPHI](StructureDefinition-rtpbc-request-claim-non-phi.md)and[RtpbcResponseClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md)


### Expansion Parameters

* Parameter: system-version
  * Value: SNOMED CT[US]

