# RTPBC Prescribable Product Code Value Set - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## ValueSet: RTPBC Prescribable Product Code Value Set 

 
This value set includes codes used to specify prescribed medications in the US: RxNorm codes that specify drug name, strength and dose form (SBD, SCD, BPCK and GPCK term types) and NDC-11 codes (which represent specific packaged products). 

 **References** 

* [RTPBC Medication Request](StructureDefinition-rtpbc-medicationrequest.md)
* [RTPBC Medication Request - Non-PHI](StructureDefinition-rtpbc-medicationrequest-non-phi.md)
* [RTPBC Request Using Claim](StructureDefinition-rtpbc-request-claim.md)
* [RTPBC Request Using Claim - Non-PHI](StructureDefinition-rtpbc-request-claim-non-phi.md)
* [RTPBC Response Using ClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md)

The consumer Real-time Pharmacy Benefit Check (RTPBC) process enables medication products to be specified using either...

* **NDC11.**11-digit normalized NDC--consisting of a 5-digit labeler segment, 4-digit product segment, and 2-digit package segment, with no dashes. Each segment is front-padded with a leading zero if the base NDC's segment has fewer digits than required by the normalized version. 

**Example:**Base NDC**0777-3105-02 =**NDC11**00777310502**
* **RxNorm.**The subset of RxNorm codes that state all of the following product aspects: the product name (distinguishing brand name vs. generic), strength and dose form. This set is composed of the term types, SCD (semantic clinical drug), SBD (semantic branded drug), GPCK (generic pack) and BPCK (brand name pack). 

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "rtpbc-prescribable-product-code",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-prescribable-product-code",
  "version" : "2.0.0",
  "name" : "RTPBCPrescribableProductCodeValueSet",
  "title" : "RTPBC Prescribable Product Code Value Set",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-05-23T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This value set includes codes used to specify prescribed medications in the US: RxNorm codes that specify drug name, strength and dose form (SBD, SCD, BPCK and GPCK term types) and NDC-11 codes (which represent specific packaged products).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/sid/ndc"
      },
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "filter" : [
          {
            "property" : "TTY",
            "op" : "in",
            "value" : "SCD,SBD,GPCK,BPCK"
          }
        ]
      }
    ]
  }
}

```
