# RTPBC Error Code Value Set - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## ValueSet: RTPBC Error Code Value Set 

 
This value set contains the error codes to be used by real-time pharmacy benefit check servers when encountering a data or business condition that prevents processing from completing. Values are defined in the NCPDP-maintained Reject Code (511-FB) code set. 

 **References** 

* [RTPBC Response Using ClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 

### Notes:

﻿All codes are from the licensed NCPDP Reject Code (511-FB) code set, maintained by the National Council for Prescription Drug Programs. See [NCPDP Reject Code (NCPDP ECL: 511-FB)](https://terminology.hl7.org/CodeSystem-NCPDPRejectCode.html)

### Concept examples

The full, up-to-date content of the NCPDP Reject Code (511-FB) code set is only available to NCPDP members.

However, a past version of the code set is publicly available in the AHRQ United States Health Information Knowledgebase (USHIK). Below is a subset of concepts from that public source, for illustration purposes.

* **Code**: PJ
  * **Display**: M/I Request Insurance Segment
* **Code**: 1
  * **Display**: M/I Bin Number
* **Code**: 4
  * **Display**: M/I Processor Control Number
* **Code**: 6
  * **Display**: M/I Group ID
* **Code**: 7
  * **Display**: M/I Cardholder ID
* **Code**: 8
  * **Display**: M/I Person Code
* **Code**: 600
  * **Display**: Coverage Outside Submitted Date Of Transaction
* **Code**: N1
  * **Display**: No Patient Match Found
* **Code**: 99
  * **Display**: Host Processing Error
* **Code**: 92
  * **Display**: System Unavailable/Host Unavailable
* **Code**: R8
  * **Display**: Syntax Error
* **Code**: 21
  * **Display**: M/I Product/Service ID
* **Code**: 77
  * **Display**: Discontinued Product/Service ID Number
* **Code**: ET
  * **Display**: M/I Quantity Prescribed
* **Code**: 26
  * **Display**: M/I Unit Of Measure
* **Code**: PZ
  * **Display**: Non-Matched Unit Of Measure To Product/Service ID
* **Code**: 19
  * **Display**: M/I Days Supply
* **Code**: 22
  * **Display**: M/I Dispense As Written (DAW)/Product Selection Code
* **Code**: PN
  * **Display**: M/I Request Prescriber Segment
* **Code**: DR
  * **Display**: M/I Prescriber Last Name
* **Code**: 25
  * **Display**: M/I Prescriber ID
* **Code**: 56
  * **Display**: Non-Matched Prescriber ID
* **Code**: 71
  * **Display**: Prescriber ID Is Not Covered
* **Code**: Z5
  * **Display**: M/I Service Provider Segment
* **Code**: 5
  * **Display**: M/I Service Provider Number
* **Code**: YK
  * **Display**: M/I Service Provider Name
* **Code**: PK
  * **Display**: M/I Request Patient Segment
* **Code**: CA
  * **Display**: M/I Patient First Name
* **Code**: CB
  * **Display**: M/I Patient Last Name
* **Code**: 9
  * **Display**: M/I Date Of Birth
* **Code**: 10
  * **Display**: M/I Patient Gender Code



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "rtpbc-error-code",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-error-code",
  "version" : "2.0.0",
  "name" : "RtbpcErrorCodeValueSet",
  "title" : "RTPBC Error Code Value Set",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-05-23T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This value set contains the error codes to be used by real-time pharmacy benefit check servers when encountering a data or business condition that prevents processing from completing. Values are defined in the NCPDP-maintained Reject Code (511-FB) code set.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/NCPDPRejectCode"
      }
    ]
  }
}

```
