# RTPBC Billing Unit Value Set - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## ValueSet: RTPBC Billing Unit Value Set 

 
This value set contains the quantity unit of measure to be used when requesting predetermination of benefits for prescription-related products 

 **References** 

* [RTPBC Medication Request](StructureDefinition-rtpbc-medicationrequest.md)
* [RTPBC Medication Request - Non-PHI](StructureDefinition-rtpbc-medicationrequest-non-phi.md)
* [RTPBC Request Using Claim](StructureDefinition-rtpbc-request-claim.md)
* [RTPBC Request Using Claim - Non-PHI](StructureDefinition-rtpbc-request-claim-non-phi.md)
* [RTPBC Response Using ClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "rtpbc-billing-unit",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-billing-unit",
  "version" : "2.0.0",
  "name" : "RtbpcBillingUnitValueSet",
  "title" : "RTPBC Billing Unit Value Set",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-05-23T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This value set contains the quantity unit of measure to be used when requesting predetermination of benefits for prescription-related products",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://unitsofmeasure.org",
        "concept" : [
          {
            "code" : "{Each}",
            "display" : "{Each}"
          },
          {
            "code" : "g",
            "display" : "g"
          },
          {
            "code" : "mL",
            "display" : "mL"
          }
        ]
      }
    ]
  }
}

```
