# RTPBC Response Using ClaimResponse - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Resource Profile: RTPBC Response Using ClaimResponse 

 
This profile constrains the ClaimResponse resource to serve as the RTPBC Response in the consumer real-time pharmacy benefit check process. It uses the ClaimResponse's "predetermination" processing mode 

 Data population is similar to a typical **predetermination** ClaimResponse (where the corresponding Claim.use was set to "predetermination"), with the following key differences:

* in addition to cost and coverage for the requested medication and pharmacy, the responder may also return information about alternative medication + pharmacy combinations. These alternatives are conveyed in one or more ClaimResponse.addItem composites, characterized as independent options using an extension defined in this guide ([isAlternative](StructureDefinition-rtpbc-isAlternative.md))
* the [benefitRestriction](StructureDefinition-rtpbc-benefitRestriction.md) extension is used to communicate the level at which the requested drug and pharmacy are covered, as well as alternative drug/pharmacy combinations (using high-level, pre-defined [benefit restrictions](ValueSet-rtpbc-benefit-restriction.md) tailored to the patient's perspective)
* the processNote element can be used to communicate additional textual information related to the cost or coverage of the requested medication, pharmacy or alternative
* alternative pharmacies are communicated using referenced Organization resources
* certain other elements are fixed to values reflecting a medication-related request… ClaimResponse.type = "pharmacy" ClaimResponse.addItem elements are constrained to product identifiers and quantity units of measure describing medications. 

In this profile, the ClaimResponse references the following supported resources, both of which are profiled in this guide:

* [Patient](StructureDefinition-rtpbc-patient.md) (containing a small amount of identifying information to enable the insurer to locate the patient's records)
* [Organization](StructureDefinition-rtpbc-pharmacy-organization.md) (identifying an alternative pharmacy) 


### Must Support elements in this profile

**Responding systems**

* Responders SHOULD return pricing and coverage information for relevant drug/pharmacy alternatives, in the addItem composite
* Every response must contain either an item composite or an error composite, but not both. The Item composite MUST be populated when sufficient information is received to be able to answer the request. The error composite MUST be populated when the responder cannot complete processing due to insufficient or invalid information in the request
* The benefitRestrictions extension is a conditional element that MUST be populated when the responder is an insurer (or other processor representing the patient's pharmacy benefit). It is not expected to be populated when the responder is a medication pricing source
* The processNote element is a conditional element that MAY be populated when the responder has additional information about costs or coverage related to an .item or .addItem. The noteNumber links an .item or .addItem to its associated processNote
* All elements marked Must Support are essential to communicating patient costs and coverage. The responder MUST ensure that content in these elements is accurate and complete

**Client systems**

* MUST be able to interpret and convey to users all cost and coverage information returned in the response, as appropriate to the application

**Usages:**

* Use this Profile: [RTPBC Response Bundle](StructureDefinition-rtpbc-response-bundle.md)
* Refer to this Profile: [RTPBC Response MessageHeader](StructureDefinition-rtpbc-response-messageheader.md)
* Examples for this Profile: [ClaimResponse/rtpbc-claim-response-03-price-source](ClaimResponse-rtpbc-claim-response-03-price-source.md), [ClaimResponse/rtpbc-claim-response-03](ClaimResponse-rtpbc-claim-response-03.md) and [ClaimResponse/rtpbc-claim-response-not-covered](ClaimResponse-rtpbc-claim-response-not-covered.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.carin-rtpbc|current/StructureDefinition/rtpbc-response-claimresponse)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-rtpbc-response-claimresponse.csv), [Excel](../StructureDefinition-rtpbc-response-claimresponse.xlsx), [Schematron](../StructureDefinition-rtpbc-response-claimresponse.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rtpbc-response-claimresponse",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-response-claimresponse",
  "version" : "2.0.0",
  "name" : "RtpbcResponseClaimResponse",
  "title" : "RTPBC Response Using ClaimResponse",
  "status" : "active",
  "date" : "2020-05-23T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This profile constrains the ClaimResponse resource to serve as the RTPBC Response in the consumer real-time pharmacy benefit check process. It uses the ClaimResponse's \"predetermination\" processing mode",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ClaimResponse",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ClaimResponse",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClaimResponse.id",
        "path" : "ClaimResponse.id",
        "label" : "Unique ClaimResponse Resource Identifier",
        "short" : "Unique ClaimResponse Resource Identifier",
        "definition" : "Unique ClaimResponse Resource Identifier assigned by the responding payer/PBM",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.identifier",
        "path" : "ClaimResponse.identifier",
        "label" : "RTPBC Response Identifier",
        "short" : "RTPBC Response Identifier",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.identifier.value",
        "path" : "ClaimResponse.identifier.value",
        "label" : "Unique RTPBC response ID",
        "short" : "Unique RTPBC response ID",
        "definition" : "An identifier for each RTPBC response that is assigned by and unique to the reponder",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.status",
        "path" : "ClaimResponse.status",
        "label" : "Response status",
        "short" : "Response status",
        "definition" : "The status of this response (active)",
        "comment" : "Value is always 'active'",
        "fixedCode" : "active",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.type",
        "path" : "ClaimResponse.type",
        "label" : "Requested Service Type",
        "short" : "Requested Service Type",
        "definition" : "The type of service for which pricing and coverage predetermination is being requested",
        "comment" : "Value is always 'pharmacy'",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.type.coding",
        "path" : "ClaimResponse.type.coding",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.type.coding.system",
        "path" : "ClaimResponse.type.coding.system",
        "min" : 1,
        "fixedUri" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.type.coding.code",
        "path" : "ClaimResponse.type.coding.code",
        "min" : 1,
        "fixedCode" : "pharmacy",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.type.coding.display",
        "path" : "ClaimResponse.type.coding.display",
        "min" : 1,
        "fixedString" : "Pharmacy",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.use",
        "path" : "ClaimResponse.use",
        "label" : "Processing Mode",
        "short" : "Processing Mode",
        "definition" : "The mode of processing being performed by the payer/PBM",
        "comment" : "Value is always 'predetermination'",
        "fixedCode" : "predetermination",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.patient",
        "path" : "ClaimResponse.patient",
        "label" : "Response Patient Information",
        "short" : "Response Patient Information",
        "definition" : "Limited patient information required in the consumer real-time pharmacy benefit check (RTPBC) process",
        "comment" : "Echo the Patient resource received in the request",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.insurer",
        "path" : "ClaimResponse.insurer",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.insurer.identifier",
        "path" : "ClaimResponse.insurer.identifier",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.insurer.identifier.value",
        "path" : "ClaimResponse.insurer.identifier.value",
        "label" : "Payer ID",
        "short" : "Payer ID",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.request",
        "path" : "ClaimResponse.request",
        "label" : "Submitter's RTPBC Request ID",
        "short" : "Submitter's RTPBC Request ID",
        "definition" : "The RTPBC Request ID contained in the associated request",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.request.identifier",
        "path" : "ClaimResponse.request.identifier",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.request.identifier.value",
        "path" : "ClaimResponse.request.identifier.value",
        "label" : "RTPBC Request ID",
        "short" : "RTPBC Request ID",
        "definition" : "The RTPBC Request ID contained in the associated request",
        "comment" : "Populate with the Claim.identifier.value from the associated request",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.outcome",
        "path" : "ClaimResponse.outcome",
        "label" : "Processing Outcome",
        "short" : "Processing Outcome",
        "definition" : "The outcome of processing. Either 'complete' (finished without errors) or 'error' (processing could not complete). The outcome is 'processed' if processing completes with a coverage determination, including when it is determined that the requested product is not covered. Otherwise, the outcome = 'error'. \n\n**Note: If a system or communication error occurs, an OperationOutcome is returned instead of a ClaimResponse**",
        "comment" : "If the outcome = 'error', the .error composite must be populated.",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.disposition",
        "path" : "ClaimResponse.disposition",
        "label" : "Completed Note",
        "short" : "Completed Note",
        "definition" : "Note providing clarifying information and/or support contact information. Available for both 'completed' and 'error' outcomes.",
        "comment" : "The responding payer/PBM determines when and how to populate.Recommended that a patient help desk phone number be included.",
        "requirements" : "Corresponds to the Help Desk Support elements in the NCPDP RTPBC response message.",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.item",
        "path" : "ClaimResponse.item",
        "label" : "Requested Product and Pharmacy",
        "short" : "Requested Product and Pharmacy",
        "definition" : "Composite containing cost and coverage for the requested product and pharmacy.",
        "comment" : "SHALL be populated when the .outcome = 'complete'.",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.item.extension",
        "path" : "ClaimResponse.item.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "ClaimResponse.item.extension:benefitRestriction",
        "path" : "ClaimResponse.item.extension",
        "sliceName" : "benefitRestriction",
        "short" : "Benefit Restriction (Extension)",
        "definition" : "This extension conveys benefit restrictions that may apply to a prescription product and pharmacy combination.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-benefitRestriction"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.item.extension:formularyStatus",
        "path" : "ClaimResponse.item.extension",
        "sliceName" : "formularyStatus",
        "short" : "Formulary Status (Extension)",
        "definition" : "This extension conveys the formulary status that applies to the product.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-formularyStatus"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.item.extension:preferenceLevel",
        "path" : "ClaimResponse.item.extension",
        "sliceName" : "preferenceLevel",
        "short" : "Preference Level (Extension)",
        "definition" : "This extension conveys the preference level that applies to the product.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-preferenceLevel"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.item.extension:nextAvailableFillDate",
        "path" : "ClaimResponse.item.extension",
        "sliceName" : "nextAvailableFillDate",
        "short" : "Next Available Fill Date (Extension)",
        "definition" : "This extension conveys the date on which a patient prescription will have passed the insurer's minimum consumption requirements and may be considered for dispensing.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-nextAvailableFillDate"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.item.itemSequence",
        "path" : "ClaimResponse.item.itemSequence",
        "definition" : "Indicates that the information in this .item composite relates to the requested product and pharmacy.",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.item.noteNumber",
        "path" : "ClaimResponse.item.noteNumber",
        "label" : "Determination Note Number",
        "short" : "Determination Note Number",
        "definition" : "Number referencing a Determination Note (.processNote) explaining the coverage status for this product + pharmacy combination.",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.item.adjudication",
        "path" : "ClaimResponse.item.adjudication",
        "label" : "Requested Product and Pharmacy Determination",
        "short" : "Requested Product and Pharmacy Determination",
        "definition" : "Patient cost and coverage details for the requested product and pharmacy.",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.item.adjudication.category",
        "path" : "ClaimResponse.item.adjudication.category",
        "label" : "Patient Pay Component",
        "short" : "Patient Pay Component",
        "definition" : "Identifies a component of the patient's financial responsibility for the product cost.",
        "comment" : "At least one .adjudication must contain a .category with the .code value 'total', representing the patient's total financial responsibility for the product. Note that returned balance amounts (e.g., accumulated deductible or remaining deductible) are calculated from the current member balance and reflect only the effect of the associated RTPBC request",
        "requirements" : "Corresponds to NCPDP C95-KQ Patient Pay Component Qualifier.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "RTPBC Patient Pay Categories",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-patient-pay-type"
        }
      },
      {
        "id" : "ClaimResponse.item.adjudication.amount",
        "path" : "ClaimResponse.item.adjudication.amount",
        "label" : "Patient Pay Component Amount",
        "short" : "Patient Pay Component Amount",
        "definition" : "The amount associated with the Patient Pay Component (.adjudication.category).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.item.adjudication.amount.value",
        "path" : "ClaimResponse.item.adjudication.amount.value",
        "label" : "Patient Pay Amount Value",
        "short" : "Patient Pay Amount Value",
        "definition" : "The patient pay component amount in terms of the specified currency.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.item.adjudication.amount.currency",
        "path" : "ClaimResponse.item.adjudication.amount.currency",
        "label" : "Patient Pay Amount Currency",
        "short" : "Patient Pay Amount Currency",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Currencies",
          "valueSet" : "http://hl7.org/fhir/ValueSet/currencies"
        }
      },
      {
        "id" : "ClaimResponse.addItem",
        "path" : "ClaimResponse.addItem",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.extension",
        "path" : "ClaimResponse.addItem.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "ClaimResponse.addItem.extension:isAlternative",
        "path" : "ClaimResponse.addItem.extension",
        "sliceName" : "isAlternative",
        "short" : "Is Alternative (Extension)",
        "definition" : "This extension indicates that this added line item is to be interpreted as one of possibly multiple alternatives to the requested product or service. When isAlternative is true, the added line item is to be considered independently from any other added line items associated with the requested product or service",
        "comment" : "Set to true in all real-time pharmacy benefit check response .addItems.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-isAlternative"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.extension:benefitRestriction",
        "path" : "ClaimResponse.addItem.extension",
        "sliceName" : "benefitRestriction",
        "short" : "Benefit Restriction (Extension)",
        "definition" : "This extension conveys benefit restrictions that may apply to a prescription product and pharmacy combination.",
        "min" : 0,
        "max" : "*",
        "base" : {
          "path" : "DomainResource.extension",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-benefitRestriction"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.extension:formularyStatus",
        "path" : "ClaimResponse.addItem.extension",
        "sliceName" : "formularyStatus",
        "short" : "Formulary Status (Extension)",
        "definition" : "This extension conveys the formulary status that applies to the product.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-formularyStatus"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.extension:preferenceLevel",
        "path" : "ClaimResponse.addItem.extension",
        "sliceName" : "preferenceLevel",
        "short" : "Preference Level (Extension)",
        "definition" : "This extension conveys the preference level that applies to the product.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-preferenceLevel"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.extension:nextAvailableFillDate",
        "path" : "ClaimResponse.addItem.extension",
        "sliceName" : "nextAvailableFillDate",
        "short" : "Next Available Fill Date (Extension)",
        "definition" : "This extension conveys the date on which a patient prescription will have passed the insurer's minimum consumption requirements and may be considered for dispensing.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-nextAvailableFillDate"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.itemSequence",
        "path" : "ClaimResponse.addItem.itemSequence",
        "label" : "Associated request Item Sequence",
        "short" : "Associated request Item Sequence",
        "definition" : "Indicates that the information in this .item composite is an alternative to the requested product and pharmacy.",
        "comment" : "Because a maximum of one product is submitted per request, this value is always '1'.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.provider",
        "path" : "ClaimResponse.addItem.provider",
        "label" : "Priced Pharmacy",
        "short" : "Priced Pharmacy",
        "definition" : "Reference to an Organization resource representing the priced pharmacy",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-pharmacy-organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.provider.reference",
        "path" : "ClaimResponse.addItem.provider.reference",
        "label" : "Reference to Priced Pharmacy",
        "short" : "Reference to Priced Pharmacy",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.productOrService",
        "path" : "ClaimResponse.addItem.productOrService",
        "label" : "Product",
        "short" : "Product",
        "definition" : "A product identifier for the medication. Either an NDC11 or an RxNorm code for a prescribable product (representing drug name, strength and dose form)",
        "comment" : "The NDC11 is an 11-digit normalized format consisting of a 5-digit labeler segment, 4-digit product segment, and 2-digit package segment, with no dashes",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "RTPBC prescribable product codes (NDC11 and RxNorm)",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-prescribable-product-code"
        }
      },
      {
        "id" : "ClaimResponse.addItem.productOrService.coding",
        "path" : "ClaimResponse.addItem.productOrService.coding",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.productOrService.coding.system",
        "path" : "ClaimResponse.addItem.productOrService.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.productOrService.coding.code",
        "path" : "ClaimResponse.addItem.productOrService.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.productOrService.coding.display",
        "path" : "ClaimResponse.addItem.productOrService.coding.display",
        "label" : "Product Description",
        "short" : "Product Description",
        "definition" : "The full prescribable product name, including drug name, strength and dose form. The drug name equals the brand name if the branded product is desired.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.quantity",
        "path" : "ClaimResponse.addItem.quantity",
        "label" : "Priced Quantity",
        "short" : "Priced Quantity",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.quantity.value",
        "path" : "ClaimResponse.addItem.quantity.value",
        "label" : "Quantity in Billing Units",
        "short" : "Quantity in Billing Units",
        "definition" : "The prescribed quantity in terms of the applicable billing unit of measure.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.quantity.unit",
        "path" : "ClaimResponse.addItem.quantity.unit",
        "label" : "Billing unit of measure",
        "short" : "Billing unit of measure",
        "definition" : "Pharmacy metric billing unit: GM (gram), ML (milliliter) or EA (each)",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Billing quantity unit of measure",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-billing-unit"
        }
      },
      {
        "id" : "ClaimResponse.addItem.noteNumber",
        "path" : "ClaimResponse.addItem.noteNumber",
        "label" : "Determination Note Number",
        "short" : "Determination Note Number",
        "definition" : "Number referencing a Determination Note (.processNote) explaining the coverage status for this product + pharmacy combination.",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.adjudication",
        "path" : "ClaimResponse.addItem.adjudication",
        "label" : "Alternative Product and Pharmacy Determination",
        "short" : "Alternative Product and Pharmacy Determination",
        "definition" : "Patient cost and coverage details for an alternative product and pharmacy combination.",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.adjudication.category",
        "path" : "ClaimResponse.addItem.adjudication.category",
        "label" : "Patient Pay Component",
        "short" : "Patient Pay Component",
        "definition" : "Identifies a component of the patient's financial responsibility for the product cost.",
        "comment" : "At least one .adjudication must contain a .category with the .code value 'total', representing the patient's total financial responsibility for the product",
        "requirements" : "Corresponds to NCPDP C95-KQ Patient Pay Component Qualifier.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "RTPBC Patient Pay Categories",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-patient-pay-type"
        }
      },
      {
        "id" : "ClaimResponse.addItem.adjudication.amount",
        "path" : "ClaimResponse.addItem.adjudication.amount",
        "label" : "Patient Pay Component Amount",
        "short" : "Patient Pay Component Amount",
        "definition" : "The amount associated with the Patient Pay Component (.adjudication.category).",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.adjudication.amount.value",
        "path" : "ClaimResponse.addItem.adjudication.amount.value",
        "label" : "Patient Pay Amount Value",
        "short" : "Patient Pay Amount Value",
        "definition" : "The patient pay component amount in terms of the specified currency.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.addItem.adjudication.amount.currency",
        "path" : "ClaimResponse.addItem.adjudication.amount.currency",
        "label" : "Patient Pay Amount Currency",
        "short" : "Patient Pay Amount Currency",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Currencies",
          "valueSet" : "http://hl7.org/fhir/ValueSet/currencies"
        }
      },
      {
        "id" : "ClaimResponse.processNote",
        "path" : "ClaimResponse.processNote",
        "label" : "Determination Note",
        "short" : "Determination Note",
        "definition" : "Additional coverage determination information for a product / pharmacy combination.",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.processNote.number",
        "path" : "ClaimResponse.processNote.number",
        "label" : "Determination Note Number",
        "short" : "Determination Note Number",
        "comment" : "Links to the .noteNumber elements in .item and .addItem",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.processNote.text",
        "path" : "ClaimResponse.processNote.text",
        "label" : "Determination Note Text",
        "short" : "Determination Note Text",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.error",
        "path" : "ClaimResponse.error",
        "label" : "Error Information",
        "short" : "Error Information",
        "comment" : "Must be populated when .outcome = 'error'",
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.error.code",
        "path" : "ClaimResponse.error.code",
        "label" : "Reject Reason",
        "short" : "Reject Reason",
        "definition" : "A code identifying the reason that processing could not be completed.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "description" : "RTPBC Error Codes",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-error-code"
        }
      },
      {
        "id" : "ClaimResponse.error.code.coding",
        "path" : "ClaimResponse.error.code.coding",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.error.code.coding.system",
        "path" : "ClaimResponse.error.code.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.error.code.coding.code",
        "path" : "ClaimResponse.error.code.coding.code",
        "label" : "Reject Code",
        "short" : "Reject Code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.error.code.coding.display",
        "path" : "ClaimResponse.error.code.coding.display",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ClaimResponse.error.code.text",
        "path" : "ClaimResponse.error.code.text",
        "label" : "Reject Message",
        "short" : "Reject Message",
        "definition" : "Clarification of the reject cause.",
        "mustSupport" : true
      }
    ]
  }
}

```
