# RTPBC Request MessageHeader - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Resource Profile: RTPBC Request MessageHeader 

 
This profile constrains a MessageHeader resource for use in a Real-time Pharmacy Benefit Check (RTPBC) request bundle 

This profile constrains the MessageHeader resource for use in a real-time pharmacy benefit check (RTPBC) request bundle.

**Usages:**

* Use this Profile: [RTPBC Request Bundle - Non-PHI](StructureDefinition-rtpbc-request-bundle-non-phi.md) and [RTPBC Request Bundle](StructureDefinition-rtpbc-request-bundle.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.carin-rtpbc|current/StructureDefinition/rtpbc-request-messageheader)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-rtpbc-request-messageheader.csv), [Excel](../StructureDefinition-rtpbc-request-messageheader.xlsx), [Schematron](../StructureDefinition-rtpbc-request-messageheader.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rtpbc-request-messageheader",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-request-messageheader",
  "version" : "2.0.0",
  "name" : "RtpbcRequestMessageHeader",
  "title" : "RTPBC Request MessageHeader",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-05-23T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This profile constrains a MessageHeader resource for use in a Real-time Pharmacy Benefit Check (RTPBC) request bundle",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MessageHeader",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MessageHeader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MessageHeader",
        "path" : "MessageHeader",
        "mustSupport" : false
      },
      {
        "id" : "MessageHeader.event[x]",
        "path" : "MessageHeader.event[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MessageHeader.event[x]:eventCoding",
        "path" : "MessageHeader.event[x]",
        "sliceName" : "eventCoding",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "patternCoding" : {
          "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-event-type",
          "code" : "rtpbc-request",
          "display" : "RTPBC Request"
        },
        "mustSupport" : true
      },
      {
        "id" : "MessageHeader.focus",
        "path" : "MessageHeader.focus",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "MessageHeader.focus:rtpbc-request",
        "path" : "MessageHeader.focus",
        "sliceName" : "rtpbc-request",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Claim"],
            "aggregation" : ["bundled"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MessageHeader.definition",
        "path" : "MessageHeader.definition",
        "min" : 1,
        "fixedCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/MessageDefinition/rtpbc-request",
        "mustSupport" : true
      }
    ]
  }
}

```
