# RTPBC preferenceLevel Extension - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Extension: RTPBC preferenceLevel Extension 

This extension conveys the preference level of a prescription product.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [RTPBC Response Using ClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md)
* Examples for this Extension: [ClaimResponse/rtpbc-claim-response-03](ClaimResponse-rtpbc-claim-response-03.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.carin-rtpbc|current/StructureDefinition/rtpbc-preferenceLevel)

### Formal Views of Extension Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-rtpbc-preferenceLevel.csv), [Excel](../StructureDefinition-rtpbc-preferenceLevel.xlsx), [Schematron](../StructureDefinition-rtpbc-preferenceLevel.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rtpbc-preferenceLevel",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-preferenceLevel",
  "version" : "2.0.0",
  "name" : "RtpbcExtensionPreferenceLevel",
  "title" : "RTPBC preferenceLevel Extension",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-03T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This extension conveys the preference level of a prescription product.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ClaimResponse.item"
    },
    {
      "type" : "element",
      "expression" : "ClaimResponse.addItem"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "RTPBC preferenceLevel Extension",
        "definition" : "This extension conveys the preference level of a prescription product."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-preferenceLevel"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Preference level.",
        "definition" : "Preference level that may apply to a prescription product and pharmacy combination. Values: 1-99, wherre 1 means most preferred and 99 means least preferred.",
        "min" : 1,
        "type" : [
          {
            "code" : "positiveInt"
          }
        ],
        "constraint" : [
          {
            "key" : "rtpbc-1",
            "severity" : "error",
            "human" : "Value must be an integer in the range of 1 through 99",
            "expression" : "$this >= 1 and $this <= 99",
            "source" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-preferenceLevel"
          }
        ]
      }
    ]
  }
}

```
