# RTPBC nextAvailableFillDate Extension - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Extension: RTPBC nextAvailableFillDate Extension 

This extension conveys the date on which a patient prescription will have passed the insurer's minimum consumption requirements and may be considered for dispensing.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [RTPBC Response Using ClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md)
* Examples for this Extension: [ClaimResponse/rtpbc-claim-response-03](ClaimResponse-rtpbc-claim-response-03.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.carin-rtpbc|current/StructureDefinition/rtpbc-nextAvailableFillDate)

### Formal Views of Extension Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-rtpbc-nextAvailableFillDate.csv), [Excel](../StructureDefinition-rtpbc-nextAvailableFillDate.xlsx), [Schematron](../StructureDefinition-rtpbc-nextAvailableFillDate.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rtpbc-nextAvailableFillDate",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-nextAvailableFillDate",
  "version" : "2.0.0",
  "name" : "RtpbcExtensionNextAvailableFillDate",
  "title" : "RTPBC nextAvailableFillDate Extension",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-03T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This extension conveys the date on which a patient prescription will have passed the insurer's minimum consumption requirements and may be considered for dispensing.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ClaimResponse.item"
    },
    {
      "type" : "element",
      "expression" : "ClaimResponse.addItem"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "RTPBC nextAvailableFillDate Extension",
        "definition" : "This extension conveys the date on which a patient prescription will have passed the insurer's minimum consumption requirements and may be considered for dispensing."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-nextAvailableFillDate"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Next available fill date.",
        "definition" : "Date on which a patient prescription will have passed the insurer's minimum consumption requirements and may be considered for dispensing.",
        "min" : 1,
        "type" : [
          {
            "code" : "date"
          }
        ]
      }
    ]
  }
}

```
