# RTPBC Medication Request - Non-PHI - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Resource Profile: RTPBC Medication Request - Non-PHI 

 
This profile provides minimal prescription characteristics for submission in an RTPBC request to data sources that can provide benefit or price information without receiving patient details. 

**Usages:**

* Use this Profile: [RTPBC Request Bundle - Non-PHI](StructureDefinition-rtpbc-request-bundle-non-phi.md)
* Refer to this Profile: [RTPBC Request Using Claim - Non-PHI](StructureDefinition-rtpbc-request-claim-non-phi.md)
* Examples for this Profile: [MedicationRequest/rtpbc-medicationrequest-non-phi-1](MedicationRequest-rtpbc-medicationrequest-non-phi-1.md) and [MedicationRequest/rtpbc-medicationrequest-non-phi-2](MedicationRequest-rtpbc-medicationrequest-non-phi-2.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.carin-rtpbc|current/StructureDefinition/rtpbc-medicationrequest-non-phi)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-rtpbc-medicationrequest-non-phi.csv), [Excel](../StructureDefinition-rtpbc-medicationrequest-non-phi.xlsx), [Schematron](../StructureDefinition-rtpbc-medicationrequest-non-phi.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rtpbc-medicationrequest-non-phi",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-medicationrequest-non-phi",
  "version" : "2.0.0",
  "name" : "RtpbcMedicationRequestNonPHI",
  "title" : "RTPBC Medication Request - Non-PHI",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-12-12T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This profile provides minimal prescription characteristics for submission in an RTPBC request to data sources that can provide benefit or price information without receiving patient details.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest",
        "path" : "MedicationRequest"
      },
      {
        "id" : "MedicationRequest.status",
        "path" : "MedicationRequest.status",
        "label" : "Request Status",
        "short" : "Request Status",
        "definition" : "Status of the request for dispensing",
        "comment" : "Always equals 'draft'",
        "fixedCode" : "draft"
      },
      {
        "id" : "MedicationRequest.intent",
        "path" : "MedicationRequest.intent",
        "definition" : "Intent of the request for dispensing",
        "comment" : "Always equals 'proposal'",
        "fixedCode" : "proposal"
      },
      {
        "id" : "MedicationRequest.medication[x]",
        "path" : "MedicationRequest.medication[x]",
        "label" : "Prescribed Product",
        "short" : "Prescribed Product",
        "definition" : "The prescribed medication. Name + strength + dose form is always provided in the text element. Product identifier is included when known",
        "comment" : "The NDC11 is an 11-digit normalized format consisting of a 5-digit labeler segment, 4-digit product segment, and 2-digit package segment, with no dashes",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "RTPBC prescribable product codes (NDC11 and RxNorm)",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-prescribable-product-code"
        }
      },
      {
        "id" : "MedicationRequest.medication[x].coding.system",
        "path" : "MedicationRequest.medication[x].coding.system",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.medication[x].coding.code",
        "path" : "MedicationRequest.medication[x].coding.code",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.medication[x].text",
        "path" : "MedicationRequest.medication[x].text",
        "label" : "Medication name, strength and dose form",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.subject",
        "path" : "MedicationRequest.subject",
        "label" : "Patient - non-PHI",
        "short" : "Patient - non-PHI",
        "definition" : "Non-PHI representation of patient characteristics. May be omitted"
      },
      {
        "id" : "MedicationRequest.subject.display",
        "path" : "MedicationRequest.subject.display",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.authoredOn",
        "path" : "MedicationRequest.authoredOn",
        "definition" : "The actual or approximate date on which the prescription was written."
      },
      {
        "id" : "MedicationRequest.requester",
        "path" : "MedicationRequest.requester",
        "label" : "Prescriber",
        "short" : "Prescriber",
        "definition" : "The prescriber of the medication being requested",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.reasonCode",
        "path" : "MedicationRequest.reasonCode",
        "label" : "Diagnosis"
      },
      {
        "id" : "MedicationRequest.dispenseRequest",
        "path" : "MedicationRequest.dispenseRequest",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity",
        "path" : "MedicationRequest.dispenseRequest.quantity",
        "label" : "Prescribed Quantity",
        "short" : "Prescribed Quantity",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity.value",
        "path" : "MedicationRequest.dispenseRequest.quantity.value",
        "label" : "Quantity in Billing Units",
        "short" : "Quantity in Billing Units",
        "definition" : "The prescribed quantity in terms of the applicable billing unit of measure",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity.unit",
        "path" : "MedicationRequest.dispenseRequest.quantity.unit",
        "label" : "Billing unit of measure",
        "short" : "Billing unit of measure",
        "definition" : "Pharmacy metric billing unit: GM (gram), ML (milliliter) or EA (each)",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Billing quantity unity of measure",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-billing-unit"
        }
      },
      {
        "id" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "path" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "label" : "Days Supply",
        "short" : "Days Supply",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.expectedSupplyDuration.value",
        "path" : "MedicationRequest.dispenseRequest.expectedSupplyDuration.value",
        "label" : "Days Supply Value",
        "short" : "Days Supply Value",
        "definition" : "The number of days the requested dispense quantity is intended to last",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.performer",
        "path" : "MedicationRequest.dispenseRequest.performer",
        "label" : "Pharmacy",
        "short" : "Pharmacy",
        "definition" : "Proposed dispensing pharmacy.",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.substitution",
        "path" : "MedicationRequest.substitution",
        "label" : "Substitution",
        "short" : "Substitution",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.substitution.allowed[x]",
        "path" : "MedicationRequest.substitution.allowed[x]",
        "label" : "Substitution Allowed",
        "short" : "Substitution Allowed",
        "definition" : "Whether or not the pharmacy may dispense a substitutable generic product instead of a requested branded product",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
