# RTPBC isAlternative Extension - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Extension: RTPBC isAlternative Extension 

This extension indicates that this added line item is to be interpreted as one of possibly multiple alternatives to the requested product or service. When isAlternative is true, the added line item is to be considered independently from any other added line items associated with the requested product or service.

**Context of Use**

A responder to a predetermination request may wish to provide alternative fulfillment options to the requested product or service. This extension indicates that an added line item is to be interpreted as one of possibly multiple alternatives to the requested product or service. When isAlternative is true, the added line item is to be considered independently from any other added line items associated with the requested product or service.

**Usage info**

**Usages:**

* Use this Extension: [RTPBC Response Using ClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md)
* Examples for this Extension: [Bundle/rtpbc-bundle-response-03](Bundle-rtpbc-bundle-response-03.md), [Bundle/rtpbc-bundle-response-price-source](Bundle-rtpbc-bundle-response-price-source.md), [ClaimResponse/rtpbc-claim-response-03-price-source](ClaimResponse-rtpbc-claim-response-03-price-source.md), [ClaimResponse/rtpbc-claim-response-03](ClaimResponse-rtpbc-claim-response-03.md) and [ClaimResponse/rtpbc-claim-response-not-covered](ClaimResponse-rtpbc-claim-response-not-covered.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.carin-rtpbc|current/StructureDefinition/rtpbc-isAlternative)

### Formal Views of Extension Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-rtpbc-isAlternative.csv), [Excel](../StructureDefinition-rtpbc-isAlternative.xlsx), [Schematron](../StructureDefinition-rtpbc-isAlternative.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rtpbc-isAlternative",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-isAlternative",
  "version" : "2.0.0",
  "name" : "RtpbcIsAlternativeExtension",
  "title" : "RTPBC isAlternative Extension",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-05-23T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This extension indicates that this added line item is to be interpreted as one of possibly multiple alternatives to the requested product or service. When isAlternative is true, the added line item is to be considered independently from any other added line items associated with the requested product or service.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ClaimResponse.addItem"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Whether added line item is an independent alternative",
        "definition" : "Whether this added line item is one alternative to the product or service specified in the associated line item in the Claim--to be considered independently of other added line items",
        "comment" : "A responder to a predetermination request may wish to provide alternative fulfillment options to the requested product or service. This extension indicates that an added line item is to be interpreted as one of possibly multiple alternatives to the requested product or service. When isAlternative is true, the added line item is to be considered independently from any other added line items associated with the requested product or service.",
        "max" : "1"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-isAlternative"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      }
    ]
  }
}

```
