# rtpbc-practitioner-03 - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example Practitioner: rtpbc-practitioner-03

### Example RTPBC Prescriber (in Practitioner resource)

The Real-time Pharmacy Benefit Check IG represents the medication prescriber using the US Core Practitioner profile, without further constraints. 

In this example:

* the prescriber's last name is Johnson
* the prescriber's NPI is 1234567890

 <!–

 –>

Language: en

Profile: [US Core Practitioner Profile](http://hl7.org/fhir/us/core/STU8.0.1/StructureDefinition-us-core-practitioner.html)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/5.5.0/NamingSystem-npi.html)/1234567893

**name**: Johnson 



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "rtpbc-practitioner-03",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "1234567893"
    }
  ],
  "name" : [
    {
      "family" : "Johnson"
    }
  ]
}

```
