# rtpbc-organization-03ps - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example Organization: rtpbc-organization-03ps

Language: en

Profile: [RTPBC Pharmacy Organization](StructureDefinition-rtpbc-pharmacy-organization.md)

**identifier**: [NCPDP Provider Identification Number](http://terminology.hl7.org/5.5.0/NamingSystem-NCPDPProviderIdentificationNumber.html)/0999123

**active**: true

**type**: Retail

**name**: Home Drugs

**telecom**: ph: 5556057672

**address**: 101 1st St N Minneapolis MN 55401 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "rtpbc-organization-03ps",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-pharmacy-organization"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "http://terminology.hl7.org/CodeSystem/NCPDPProviderIdentificationNumber",
      "value" : "0999123"
    }
  ],
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/NCPDPPharmacyType",
          "code" : "R",
          "display" : "Retail"
        }
      ]
    }
  ],
  "name" : "Home Drugs",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "5556057672"
    }
  ],
  "address" : [
    {
      "line" : ["101 1st St N"],
      "city" : "Minneapolis",
      "state" : "MN",
      "postalCode" : "55401"
    }
  ]
}

```
