# RTPBC Response Message Definition - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## MessageDefinition: RTPBC Response Message Definition 

 
Response to a request for patient cost and coverage information for a prescribed medication 

### MessageDefinition: Real-time Pharmacy Benefit Check (RTPBC) Response

This MessageDefinition describes the content of a real-time pharmacy benefit check (RTPBC) response, when using FHIR messaging. 

The ClaimResponse resource returns patient pricing and coverage information upon successful processing at the RTPBC source. (An OperationOutcome is returned when an error is encountered) 

**Note: The guide describes two methods for submitting the RTPBC request ($submit operation and FHIR messaging using $process-message), with the intent to elicit comments from potential implementers.**

**StructureDefinition Work Group**: phx

**url**: [MessageDefinition RTPBC Response Message Definition](MessageDefinition-rtpbc-response.md)

**version**: 2.0.0

**name**: RtpbcResponse

**title**: RTPBC Response Message Definition

**status**: Active

**experimental**: false

**date**: 2020-05-23 00:00:00-0500

**publisher**: HL7 International / Pharmacy

**contact**: HL7 International / Pharmacy: [http://www.hl7.org/Special/committees/medication](http://www.hl7.org/Special/committees/medication), Frank McKinney: [fm@frankmckinney.com](mailto:fm@frankmckinney.com)

**description**: 

Response to a request for patient cost and coverage information for a prescribed medication

**jurisdiction**: United States of America

**purpose**: 

Returns patient cost and coverage information for a prescribed medication

**event**: [RTPBC Event Type Code System: rtpbc-response](CodeSystem-rtpbc-event-type.md#rtpbc-event-type-rtpbc-response) (RTPBC Response)

**category**: Notification

### Focus

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Code** | **Profile** | **Min** | **Max** |
| * | ClaimResponse | [RTPBC Response Using ClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md) | 1 | 1 |



## Resource Content

```json
{
  "resourceType" : "MessageDefinition",
  "id" : "rtpbc-response",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/MessageDefinition/rtpbc-response",
  "version" : "2.0.0",
  "name" : "RtpbcResponse",
  "title" : "RTPBC Response Message Definition",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-05-23T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "Response to a request for patient cost and coverage information for a prescribed medication",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "purpose" : "Returns patient cost and coverage information for a prescribed medication",
  "eventCoding" : {
    "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-event-type",
    "code" : "rtpbc-response"
  },
  "category" : "notification",
  "focus" : [
    {
      "code" : "ClaimResponse",
      "profile" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-response-claimresponse",
      "min" : 1,
      "max" : "1"
    }
  ]
}

```
