# RTPBC Request Message Definition - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## MessageDefinition: RTPBC Request Message Definition 

 
Request for patient cost and coverage information for a prescribed medication 

### MessageDefinition: Real-time Pharmacy Benefit Check (RTPBC) Request

This MessageDefinition describes the content of a real-time pharmacy benefit check (RTPBC) request, when using FHIR messaging. 

The Claim resource is the focus in a bundle that also contains other supporting resources referenced by the Claim (Patient, MedicationRequest, Coverage, Practitioner, Organization). 

**Note: The guide describes two methods for submitting the RTPBC request ($submit operation and FHIR messaging using $process-message), with the intent to elicit comments from potential implementers.**

**StructureDefinition Work Group**: phx

**url**: [MessageDefinition RTPBC Request Message Definition](MessageDefinition-rtpbc-request.md)

**version**: 2.0.0

**name**: RtpbcRequest

**title**: RTPBC Request Message Definition

**status**: Active

**experimental**: false

**date**: 2020-05-23 00:00:00-0500

**publisher**: HL7 International / Pharmacy

**contact**: HL7 International / Pharmacy: [http://www.hl7.org/Special/committees/medication](http://www.hl7.org/Special/committees/medication), Frank McKinney: [fm@frankmckinney.com](mailto:fm@frankmckinney.com)

**description**: 

Request for patient cost and coverage information for a prescribed medication

**jurisdiction**: United States of America

**purpose**: 

Requests patient cost and coverage information for a prescribed medication

**event**: [RTPBC Event Type Code System: rtpbc-request](CodeSystem-rtpbc-event-type.md#rtpbc-event-type-rtpbc-request) (RTPBC Request)

**category**: Notification

### Focus

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Code** | **Min** | **Max** |
| * | Claim | 1 | 1 |

### AllowedResponses

| | | |
| :--- | :--- | :--- |
| - | **Message** | **Situation** |
| * | [RTPBC Response Message Definition](MessageDefinition-rtpbc-response.md) | Returned when processing completes without encountering a system error |



## Resource Content

```json
{
  "resourceType" : "MessageDefinition",
  "id" : "rtpbc-request",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/MessageDefinition/rtpbc-request",
  "version" : "2.0.0",
  "name" : "RtpbcRequest",
  "title" : "RTPBC Request Message Definition",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-05-23T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "Request for patient cost and coverage information for a prescribed medication",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "purpose" : "Requests patient cost and coverage information for a prescribed medication",
  "eventCoding" : {
    "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-event-type",
    "code" : "rtpbc-request"
  },
  "category" : "notification",
  "focus" : [
    {
      "code" : "Claim",
      "min" : 1,
      "max" : "1"
    }
  ],
  "allowedResponse" : [
    {
      "message" : "http://hl7.org/fhir/us/carin-rtpbc/MessageDefinition/rtpbc-response",
      "situation" : "Returned when processing completes without encountering a system error"
    }
  ]
}

```
