# rtpbc-medicationrequest-non-phi-2 - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example MedicationRequest: rtpbc-medicationrequest-non-phi-2

Language: en

Profile: [RTPBC Medication Request - Non-PHI](StructureDefinition-rtpbc-medicationrequest-non-phi.md)

**status**: Draft

**intent**: Proposal

**reported**: true

**medication**: Prozac 10mg Capsule

**subject**: unspecified

**authoredOn**: 2025-11-01

### DispenseRequests

| | | |
| :--- | :--- | :--- |
| - | **Quantity** | **Performer** |
| * | 60 {Each} | [Organization Hometown Drug](Organization-rtpbc-organization-03.md) |



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "rtpbc-medicationrequest-non-phi-2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-medicationrequest-non-phi"
    ]
  },
  "language" : "en",
  "status" : "draft",
  "intent" : "proposal",
  "reportedBoolean" : true,
  "medicationCodeableConcept" : {
    "text" : "Prozac 10mg Capsule"
  },
  "subject" : {
    "display" : "unspecified"
  },
  "authoredOn" : "2025-11-01",
  "dispenseRequest" : {
    "quantity" : {
      "value" : 60,
      "unit" : "{Each}"
    },
    "performer" : {
      "reference" : "Organization/rtpbc-organization-03"
    }
  }
}

```
