# rtpbc-medicationrequest-03 - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example MedicationRequest: rtpbc-medicationrequest-03

### Example RTPBC MedicationRequest

In this example:

* the requested medication is Prozac 10mg capsule
* requested quantity is 60 capsules
* requested days supply: 30 day supply
* the prescriber is referenced to a Practitioner resource
* the requested pharmacy is referenced to an Organization resource

 <!–

–>

Language: en

Profile: [RTPBC Medication Request](StructureDefinition-rtpbc-medicationrequest.md)

**status**: Draft

**intent**: Proposal

**reported**: true

**medication**: fluoxetine 10 MG Oral Capsule [Prozac]

**subject**: [Jane Doe Female, DoB: 1975-12-05 ( Patient internal identifier: 30455)](Patient-rtpbc-patient-03.md)

**authoredOn**: 2019-11-01

**requester**: [Practitioner Johnson](Practitioner-rtpbc-practitioner-03.md)

### DosageInstructions

| | |
| :--- | :--- |
| - | **Text** |
| * | Take 2 capsules once a day |

> **dispenseRequest****quantity**: 60 {Each}

### ExpectedSupplyDurations

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Value** | **Unit** | **System** | **Code** |
| * | 30 | days | [http://unitsofmeasure.org](http://terminology.hl7.org/5.5.0/CodeSystem-v3-ucum.html) | d |

**performer**:[Organization Hometown Drug](Organization-rtpbc-organization-03.md)

### Substitutions

| | |
| :--- | :--- |
| - | **Allowed[x]** |
| * | false |



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "rtpbc-medicationrequest-03",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-medicationrequest"
    ]
  },
  "language" : "en",
  "status" : "draft",
  "intent" : "proposal",
  "reportedBoolean" : true,
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "code" : "205535",
        "display" : "fluoxetine 10 MG Oral Capsule [Prozac]"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/rtpbc-patient-03"
  },
  "authoredOn" : "2019-11-01",
  "requester" : {
    "reference" : "Practitioner/rtpbc-practitioner-03"
  },
  "dosageInstruction" : [
    {
      "text" : "Take 2 capsules once a day"
    }
  ],
  "dispenseRequest" : {
    "quantity" : {
      "value" : 60,
      "unit" : "{Each}"
    },
    "expectedSupplyDuration" : {
      "value" : 30,
      "unit" : "days",
      "system" : "http://unitsofmeasure.org",
      "code" : "d"
    },
    "performer" : {
      "reference" : "Organization/rtpbc-organization-03"
    }
  },
  "substitution" : {
    "allowedBoolean" : false
  }
}

```
