# RTPBC Patient Pay Type Code System - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## CodeSystem: RTPBC Patient Pay Type Code System 

 
This code system defines components of a patient's responsibility for a prescription product's cost. 

This Code system is referenced in the definition of the following value sets:

* [RtbpcPatientPayTypeValueSet](ValueSet-rtpbc-patient-pay-type.md)

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "rtpbc-patient-pay-type",
  "meta" : {
    "lastUpdated" : "2019-12-08T00:00:00-05:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
  "version" : "2.0.0",
  "name" : "RtpbcPatientPayTypeCodeSystem",
  "title" : "RTPBC Patient Pay Type Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-05-23T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This code system defines components of a patient's responsibility for a prescription product's cost.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "count" : 13,
  "concept" : [
    {
      "code" : "deductible",
      "display" : "Deductible",
      "definition" : "Amount to be collected from a patient to be applied to a periodic deductible"
    },
    {
      "code" : "accumulated-deductible",
      "display" : "Accumulated deductible",
      "definition" : "Total deductible paid after amount associated with this request"
    },
    {
      "code" : "remaining-deductible",
      "display" : "Remaining deductible",
      "definition" : "Remaining deductible amount after payment associated with this request"
    },
    {
      "code" : "coinsurance",
      "display" : "Per prescription coinsurance",
      "definition" : "Amount to be collected from a patient to satisfy a per prescription coinsurance"
    },
    {
      "code" : "copay",
      "display" : "Copay",
      "definition" : "Amount to be collected from the patient to satisfy a per prescription copay"
    },
    {
      "code" : "tax",
      "display" : "Tax",
      "definition" : "Amount to be collected from the patient for sales tax"
    },
    {
      "code" : "cash-price",
      "display" : "Full product cash price",
      "definition" : "Full product cash price before discounts or coupons"
    },
    {
      "code" : "coupon-discount",
      "display" : "Coupon discount amount",
      "definition" : "Coupon discount reducing the amount to be collected from the patient"
    },
    {
      "code" : "member-discount",
      "display" : "Member discount amount",
      "definition" : "Member discount reducing the amount to be collected from the patient"
    },
    {
      "code" : "other-discount",
      "display" : "Other discount amount",
      "definition" : "Other discount reducing the amount to be collected from the patient"
    },
    {
      "code" : "other-cost",
      "display" : "Other cost",
      "definition" : "Other amount to be collected from the patient"
    },
    {
      "code" : "eligible",
      "display" : "Eligible amount",
      "definition" : "Amount that is considered for adjudication"
    },
    {
      "code" : "total",
      "display" : "Total patient responsibility",
      "definition" : "Amount equalling the total patient responsibility for a prescription product's cost"
    }
  ]
}

```
