# rtpbc-claim-response-not-covered - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example ClaimResponse: rtpbc-claim-response-not-covered

### RTPBC ClaimResponse - requested drug is not covered

In this example:

* the requested medication is not covered by the patient's plan. The Benefit Restriction contains a value of "not-covered" and the adjucation shows an eligible amount of zero dollars.
* the addItem contains an alternative drug that is covered, but with a requirement for prior authorziation and a quantity limit. Details of the quantity limit are conveyed in the processNote element.

Language: en

Profile: [RTPBC Response Using ClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md)

**identifier**: rtpbc-03-response-c-r

**status**: Active

**type**: Pharmacy

**use**: Predetermination

**patient**: [Jane Doe Female, DoB: 1975-12-05 ( Patient internal identifier: 30455)](Patient-rtpbc-patient-03.md)

**created**: 2019-11-01 11:20:59-0500

**insurer**: Identifier: Pharmacy Plans US

**request**: Identifier: rtpbc-03

**outcome**: Processing Complete

**disposition**: Processed successfully

> **item****RTPBC benefitRestriction Extension**:[RTPBC Benefit Restriction Code System: not-covered](CodeSystem-rtpbc-benefit-restriction.md#rtpbc-benefit-restriction-not-covered)(Not covered)**itemSequence**: 1
> **adjudication****category**:Eligible amount

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 0 | United States dollar |



> **addItem****RTPBC isAlternative Extension**: true**RTPBC benefitRestriction Extension**:[RTPBC Benefit Restriction Code System: prior-auth](CodeSystem-rtpbc-benefit-restriction.md#rtpbc-benefit-restriction-prior-auth)(Prior authorization required)**RTPBC benefitRestriction Extension**:[RTPBC Benefit Restriction Code System: quantity-limit](CodeSystem-rtpbc-benefit-restriction.md#rtpbc-benefit-restriction-quantity-limit)(Quantity limit applies)**itemSequence**: 1**provider**:[Organization My Mail Service Pharmacy](Organization-rtpbc-organization-03m.md)**productOrService**:elbasvir 50 MG / grazoprevir 100 MG Oral Tablet [Zepatier]**quantity**: 28 {Each}**noteNumber**: 1
> **adjudication****category**:Copay

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 405 | United States dollar |


> **adjudication****category**:Per prescription coinsurance

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 469 | United States dollar |


> **adjudication****category**:Total patient responsibility

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 874 | United States dollar |



### ProcessNotes

| | | |
| :--- | :--- | :--- |
| - | **Number** | **Text** |
| * | 1 | Quantity limit: 28 tablets per month |



## Resource Content

```json
{
  "resourceType" : "ClaimResponse",
  "id" : "rtpbc-claim-response-not-covered",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-response-claimresponse"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "value" : "rtpbc-03-response-c-r"
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "code" : "pharmacy",
        "display" : "Pharmacy"
      }
    ]
  },
  "use" : "predetermination",
  "patient" : {
    "reference" : "Patient/rtpbc-patient-03"
  },
  "created" : "2019-11-01T11:20:59-05:00",
  "insurer" : {
    "identifier" : {
      "value" : "Pharmacy Plans US"
    }
  },
  "request" : {
    "identifier" : {
      "value" : "rtpbc-03"
    }
  },
  "outcome" : "complete",
  "disposition" : "Processed successfully",
  "item" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-benefitRestriction",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-benefit-restriction",
            "code" : "not-covered",
            "display" : "Not covered"
          }
        }
      ],
      "itemSequence" : 1,
      "adjudication" : [
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "eligible",
                "display" : "Eligible amount"
              }
            ]
          },
          "amount" : {
            "value" : 0,
            "currency" : "USD"
          }
        }
      ]
    }
  ],
  "addItem" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-isAlternative",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-benefitRestriction",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-benefit-restriction",
            "code" : "prior-auth",
            "display" : "Prior authorization required"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-benefitRestriction",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-benefit-restriction",
            "code" : "quantity-limit",
            "display" : "Quantity limit applies"
          }
        }
      ],
      "itemSequence" : [1],
      "provider" : [
        {
          "reference" : "Organization/rtpbc-organization-03m"
        }
      ],
      "productOrService" : {
        "coding" : [
          {
            "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
            "code" : "1734642",
            "display" : "elbasvir 50 MG / grazoprevir 100 MG Oral Tablet [Zepatier]"
          }
        ]
      },
      "quantity" : {
        "value" : 28,
        "unit" : "{Each}"
      },
      "noteNumber" : [1],
      "adjudication" : [
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "copay",
                "display" : "Copay"
              }
            ]
          },
          "amount" : {
            "value" : 405,
            "currency" : "USD"
          }
        },
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "coinsurance",
                "display" : "Per prescription coinsurance"
              }
            ]
          },
          "amount" : {
            "value" : 469,
            "currency" : "USD"
          }
        },
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "total",
                "display" : "Total patient responsibility"
              }
            ]
          },
          "amount" : {
            "value" : 874,
            "currency" : "USD"
          }
        }
      ]
    }
  ],
  "processNote" : [
    {
      "number" : 1,
      "text" : "Quantity limit: 28 tablets per month"
    }
  ]
}

```
