# rtpbc-claim-response-03 - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example ClaimResponse: rtpbc-claim-response-03

### Example RTPBC ClaimResponse (the "RTPBC response")

In this example:

* the requested medication is Prozac 10mg capsule, 60 capsules, and the requested pharmacy is Hometown Drug. Adjudication is returned in the ClaimResponse.item composite
* the .item contains patient costs for the requested drug and pharmacy combination
* the .addItem composite holds an alternative fulfillment (the requested drug at a different pharmacy). Adjudication is returned in the ClaimResponse.addItem composite
* a referenced pharmacy Organization resource describes the alternative pharmacy option identified by the processor
* benefit restriction information (e.g., Covered, Covered but requiring PA) is returned in the .benefitRestriction extensions in the .item and .addItem composites

Language: en

Profile: [RTPBC Response Using ClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md)

**identifier**: rtpbc-03-response

**status**: Active

**type**: Pharmacy

**use**: Predetermination

**patient**: [Jane Doe Female, DoB: 1975-12-05 ( Patient internal identifier: 30455)](Patient-rtpbc-patient-03.md)

**created**: 2025-12-11 11:20:59-0500

**insurer**: Identifier: Pharmacy Plans US

**request**: Identifier: rtpbc-03

**outcome**: Processing Complete

**disposition**: Processed successfully

> **item****RTPBC benefitRestriction Extension**:[RTPBC Benefit Restriction Code System: prior-auth](CodeSystem-rtpbc-benefit-restriction.md#rtpbc-benefit-restriction-prior-auth)(Prior authorization required)**RTPBC formularyStatus Extension**:[RTPBC Formulary Status Code System: O](CodeSystem-rtpbc-formulary-status.md#rtpbc-formulary-status-O)(On Formulary)**RTPBC preferenceLevel Extension**: 2**RTPBC nextAvailableFillDate Extension**: 2025-12-20**itemSequence**: 1
> **adjudication****category**:Copay

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 40 | United States dollar |


> **adjudication****category**:Per prescription coinsurance

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 30 | United States dollar |


> **adjudication****category**:Total patient responsibility

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 70 | United States dollar |



> **addItem****RTPBC isAlternative Extension**: true**RTPBC benefitRestriction Extension**:[RTPBC Benefit Restriction Code System: covered](CodeSystem-rtpbc-benefit-restriction.md#rtpbc-benefit-restriction-covered)(Covered)**RTPBC formularyStatus Extension**:[RTPBC Formulary Status Code System: P](CodeSystem-rtpbc-formulary-status.md#rtpbc-formulary-status-P)(On Formulary/Preferred)**RTPBC preferenceLevel Extension**: 1**itemSequence**: 1**provider**:[Organization My Mail Service Pharmacy](Organization-rtpbc-organization-03m.md)**productOrService**:fluoxetine 10 MG Oral Capsule [Prozac]**quantity**: 180 {Each}
> **adjudication****category**:Remaining deductible

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 305 | United States dollar |


> **adjudication****category**:Per prescription coinsurance

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 30 | United States dollar |


> **adjudication****category**:Total patient responsibility

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 70 | United States dollar |





## Resource Content

```json
{
  "resourceType" : "ClaimResponse",
  "id" : "rtpbc-claim-response-03",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-response-claimresponse"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "value" : "rtpbc-03-response"
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "code" : "pharmacy",
        "display" : "Pharmacy"
      }
    ]
  },
  "use" : "predetermination",
  "patient" : {
    "reference" : "Patient/rtpbc-patient-03"
  },
  "created" : "2025-12-11T11:20:59-05:00",
  "insurer" : {
    "identifier" : {
      "value" : "Pharmacy Plans US"
    }
  },
  "request" : {
    "identifier" : {
      "value" : "rtpbc-03"
    }
  },
  "outcome" : "complete",
  "disposition" : "Processed successfully",
  "item" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-benefitRestriction",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-benefit-restriction",
            "code" : "prior-auth",
            "display" : "Prior authorization required"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-formularyStatus",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-formulary-status",
            "code" : "O",
            "display" : "On Formulary"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-preferenceLevel",
          "valuePositiveInt" : 2
        },
        {
          "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-nextAvailableFillDate",
          "valueDate" : "2025-12-20"
        }
      ],
      "itemSequence" : 1,
      "adjudication" : [
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "copay",
                "display" : "Copay"
              }
            ]
          },
          "amount" : {
            "value" : 40,
            "currency" : "USD"
          }
        },
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "coinsurance",
                "display" : "Per prescription coinsurance"
              }
            ]
          },
          "amount" : {
            "value" : 30,
            "currency" : "USD"
          }
        },
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "total",
                "display" : "Total patient responsibility"
              }
            ]
          },
          "amount" : {
            "value" : 70,
            "currency" : "USD"
          }
        }
      ]
    }
  ],
  "addItem" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-isAlternative",
          "valueBoolean" : true
        },
        {
          "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-benefitRestriction",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-benefit-restriction",
            "code" : "covered",
            "display" : "Covered"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-formularyStatus",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-formulary-status",
            "code" : "P",
            "display" : "On Formulary/Preferred"
          }
        },
        {
          "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-preferenceLevel",
          "valuePositiveInt" : 1
        }
      ],
      "itemSequence" : [1],
      "provider" : [
        {
          "reference" : "Organization/rtpbc-organization-03m"
        }
      ],
      "productOrService" : {
        "coding" : [
          {
            "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
            "code" : "205535",
            "display" : "fluoxetine 10 MG Oral Capsule [Prozac]"
          }
        ]
      },
      "quantity" : {
        "value" : 180,
        "unit" : "{Each}"
      },
      "adjudication" : [
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "remaining-deductible",
                "display" : "Remaining deductible"
              }
            ]
          },
          "amount" : {
            "value" : 305,
            "currency" : "USD"
          }
        },
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "coinsurance",
                "display" : "Per prescription coinsurance"
              }
            ]
          },
          "amount" : {
            "value" : 30,
            "currency" : "USD"
          }
        },
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "total",
                "display" : "Total patient responsibility"
              }
            ]
          },
          "amount" : {
            "value" : 70,
            "currency" : "USD"
          }
        }
      ]
    }
  ]
}

```
