# rtpbc-claim-response-03-price-source - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example ClaimResponse: rtpbc-claim-response-03-price-source

### RTPBC ClaimResponse returned by a pricing source

In this example:

* the requested medication is Prozac 10mg capsule, 60 capsules, and the requested pharmacy is Hometown Drug. Adjudication is returned in the ClaimResponse.item composite
* the .item contains patient costs for the requested drug and pharmacy combination
* the .addItem composite holds an alternative fulfillment (the requested drug at a different pharmacy). Adjudication is returned in the ClaimResponse.addItem composite
* a referenced pharmacy Organization resource describes the alternative pharmacy option identified by the pricing source

Language: en

Profile: [RTPBC Response Using ClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md)

**identifier**: rtpbc-03-response-price-source

**status**: Active

**type**: Pharmacy

**use**: Predetermination

**patient**: [Jane Doe Female, DoB: 1975-12-05 ( Patient internal identifier: 30455)](Patient-rtpbc-patient-03ps.md)

**created**: 2019-11-01 11:20:59-0500

**insurer**: Identifier: GoodPricing

**request**: Identifier: rtpbc-03

**outcome**: Processing Complete

**disposition**: Processed successfully

> **item****itemSequence**: 1**noteNumber**: 1
> **adjudication****category**:Full product cash price

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 105 | United States dollar |


> **adjudication****category**:Coupon discount amount

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | -20 | United States dollar |


> **adjudication****category**:Total patient responsibility

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 85 | United States dollar |



> **addItem****RTPBC isAlternative Extension**: true**itemSequence**: 1**provider**:[Organization Home Drugs](Organization-rtpbc-organization-03ps.md)**productOrService**:fluoxetine 10 MG Oral Capsule [Prozac]**quantity**: 60 {Each}
> **adjudication****category**:Full product cash price

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 50 | United States dollar |


> **adjudication****category**:Coupon discount amount

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | -10 | United States dollar |


> **adjudication****category**:Total patient responsibility

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 40 | United States dollar |





## Resource Content

```json
{
  "resourceType" : "ClaimResponse",
  "id" : "rtpbc-claim-response-03-price-source",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-response-claimresponse"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "value" : "rtpbc-03-response-price-source"
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "code" : "pharmacy",
        "display" : "Pharmacy"
      }
    ]
  },
  "use" : "predetermination",
  "patient" : {
    "reference" : "Patient/rtpbc-patient-03ps"
  },
  "created" : "2019-11-01T11:20:59-05:00",
  "insurer" : {
    "identifier" : {
      "value" : "GoodPricing"
    }
  },
  "request" : {
    "identifier" : {
      "value" : "rtpbc-03"
    }
  },
  "outcome" : "complete",
  "disposition" : "Processed successfully",
  "item" : [
    {
      "itemSequence" : 1,
      "noteNumber" : [1],
      "adjudication" : [
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "cash-price",
                "display" : "Full product cash price"
              }
            ]
          },
          "amount" : {
            "value" : 105,
            "currency" : "USD"
          }
        },
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "coupon-discount",
                "display" : "Coupon discount amount"
              }
            ]
          },
          "amount" : {
            "value" : -20,
            "currency" : "USD"
          }
        },
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "total",
                "display" : "Total patient responsibility"
              }
            ]
          },
          "amount" : {
            "value" : 85,
            "currency" : "USD"
          }
        }
      ]
    }
  ],
  "addItem" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-isAlternative",
          "valueBoolean" : true
        }
      ],
      "itemSequence" : [1],
      "provider" : [
        {
          "reference" : "Organization/rtpbc-organization-03ps"
        }
      ],
      "productOrService" : {
        "coding" : [
          {
            "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
            "code" : "205535",
            "display" : "fluoxetine 10 MG Oral Capsule [Prozac]"
          }
        ]
      },
      "quantity" : {
        "value" : 60,
        "unit" : "{Each}"
      },
      "adjudication" : [
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "cash-price",
                "display" : "Full product cash price"
              }
            ]
          },
          "amount" : {
            "value" : 50,
            "currency" : "USD"
          }
        },
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "coupon-discount",
                "display" : "Coupon discount amount"
              }
            ]
          },
          "amount" : {
            "value" : -10,
            "currency" : "USD"
          }
        },
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                "code" : "total",
                "display" : "Total patient responsibility"
              }
            ]
          },
          "amount" : {
            "value" : 40,
            "currency" : "USD"
          }
        }
      ]
    }
  ]
}

```
