# rtpbc-claim-non-phi-2 - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example Claim: rtpbc-claim-non-phi-2

Language: en

Profile: [RTPBC Request Using Claim - Non-PHI](StructureDefinition-rtpbc-request-claim-non-phi.md)

**identifier**: rtpbc-non-phi-2

**status**: Active

**type**: Pharmacy

**use**: Predetermination

**patient**: unspecified

**created**: 2025-11-01 11:20:54-0500

**provider**: [Organization Hometown Drug](Organization-rtpbc-organization-03.md)

**priority**: Normal

**prescription**: [MedicationRequest: status = draft; intent = proposal; reported[x] = true; medication[x] = ; authoredOn = 2025-11-01](MedicationRequest-rtpbc-medicationrequest-non-phi-2.md)

### CareTeams

| | | |
| :--- | :--- | :--- |
| - | **Sequence** | **Provider** |
| * | 1 | unspecified |

### Insurances

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Focal** | **Coverage** |
| * | 1 | true | unspecified |

### Items

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Sequence** | **CareTeamSequence** | **ProductOrService** | **Quantity** |
| * | 1 | 1 | Prozac 10mg Capsule | 60 {Each} |



## Resource Content

```json
{
  "resourceType" : "Claim",
  "id" : "rtpbc-claim-non-phi-2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-request-claim-non-phi"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "value" : "rtpbc-non-phi-2"
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "code" : "pharmacy",
        "display" : "Pharmacy"
      }
    ]
  },
  "use" : "predetermination",
  "patient" : {
    "display" : "unspecified"
  },
  "created" : "2025-11-01T11:20:54-05:00",
  "provider" : {
    "reference" : "Organization/rtpbc-organization-03"
  },
  "priority" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/processpriority",
        "code" : "normal",
        "display" : "Normal"
      }
    ]
  },
  "prescription" : {
    "reference" : "MedicationRequest/rtpbc-medicationrequest-non-phi-2"
  },
  "careTeam" : [
    {
      "sequence" : 1,
      "provider" : {
        "display" : "unspecified"
      }
    }
  ],
  "insurance" : [
    {
      "sequence" : 1,
      "focal" : true,
      "coverage" : {
        "display" : "unspecified"
      }
    }
  ],
  "item" : [
    {
      "sequence" : 1,
      "careTeamSequence" : [1],
      "productOrService" : {
        "text" : "Prozac 10mg Capsule"
      },
      "quantity" : {
        "value" : 60,
        "unit" : "{Each}"
      }
    }
  ]
}

```
