# rtpbc-claim-03 - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example Claim: rtpbc-claim-03

### Example RTPBC Claim resource (the "RTPBC request")

In this example:

* the patient information is referenced to a Patient resource
* the requested medication is Prozac 10mg capsule, 60 capsules (included in the Claim.item composite and referenced to a MedicationRequest resource)
* the prescriber's identifying information is referenced to a Practitioner resource
* the requested pharmacy referenced to an Organization resource
* the patient's coverage identifiers are conveyed in a referenced Coverage resource

 <!–

–>

Language: en

Profile: [RTPBC Request Using Claim](StructureDefinition-rtpbc-request-claim.md)

**identifier**: rtpbc-03

**status**: Active

**type**: Pharmacy

**use**: Predetermination

**patient**: [Jane Doe Female, DoB: 1975-12-05 ( Patient internal identifier: 30455)](Patient-rtpbc-patient-03.md)

**created**: 2019-11-01 11:20:54-0500

**provider**: [Organization Hometown Drug](Organization-rtpbc-organization-03.md)

**priority**: Normal

**prescription**: [MedicationRequest: status = draft; intent = proposal; reported[x] = true; medication[x] = fluoxetine 10 MG Oral Capsule [Prozac]; authoredOn = 2019-11-01](MedicationRequest-rtpbc-medicationrequest-03.md)

### CareTeams

| | | |
| :--- | :--- | :--- |
| - | **Sequence** | **Provider** |
| * | 1 | [Practitioner Johnson](Practitioner-rtpbc-practitioner-03.md) |

### Insurances

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Focal** | **Coverage** |
| * | 1 | true | Identifier: GOODPRICING |

### Items

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Sequence** | **CareTeamSequence** | **ProductOrService** | **Quantity** |
| * | 1 | 1 | fluoxetine 10 MG Oral Capsule [Prozac] | 60 {Each} |



## Resource Content

```json
{
  "resourceType" : "Claim",
  "id" : "rtpbc-claim-03",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-request-claim"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "value" : "rtpbc-03"
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "code" : "pharmacy",
        "display" : "Pharmacy"
      }
    ]
  },
  "use" : "predetermination",
  "patient" : {
    "reference" : "Patient/rtpbc-patient-03"
  },
  "created" : "2019-11-01T11:20:54-05:00",
  "provider" : {
    "reference" : "Organization/rtpbc-organization-03"
  },
  "priority" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/processpriority",
        "code" : "normal",
        "display" : "Normal"
      }
    ]
  },
  "prescription" : {
    "reference" : "MedicationRequest/rtpbc-medicationrequest-03"
  },
  "careTeam" : [
    {
      "sequence" : 1,
      "provider" : {
        "reference" : "Practitioner/rtpbc-practitioner-03"
      }
    }
  ],
  "insurance" : [
    {
      "sequence" : 1,
      "focal" : true,
      "coverage" : {
        "identifier" : {
          "value" : "GOODPRICING"
        }
      }
    }
  ],
  "item" : [
    {
      "sequence" : 1,
      "careTeamSequence" : [1],
      "productOrService" : {
        "coding" : [
          {
            "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
            "code" : "205535",
            "display" : "fluoxetine 10 MG Oral Capsule [Prozac]"
          }
        ]
      },
      "quantity" : {
        "value" : 60,
        "unit" : "{Each}"
      }
    }
  ]
}

```
