# rtpbc-bundle-request-03 - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example Bundle: rtpbc-bundle-request-03

### Example RTPBC request scenario using FHIR messaging

In this example:

* the client is a patient application
* the server is the patient's insurer (specifically, the party that manages the patient's pharmacy benefit)
* the request is submitted as a Bundle containing a Claim and supporting resources, as the single parameter to the processor's $process-message operation

Content:

* the patient's name is Jane Doe, date of birth is 1975-12-05, and address is 100 Oak Court, Madison, WI 53510
* the requested medication is Prozac 10mg capsule, 60 capsules, for a 30 day supply (reflected in the Claim and MedicationRequest resources)
* the prescriber's identifying information is captured in the Practitioner resource
* the requested pharmacy is Hometown Drug (reflected in the Organization resource)
* the patient's coverage identifiers (BIN/PCN, member ID) are conveyed in a Coverage resource

The supporting data (patient, coverage, prescription, etc.) consists of identifying information that the processor will use to locate the patient's insurance record and coverage rules applying to the medication, pharmacy and prescriber.



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "rtpbc-bundle-request-03",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-request-bundle"
    ]
  },
  "language" : "en",
  "type" : "message",
  "timestamp" : "2019-11-15T13:10:13-05:00",
  "entry" : [
    {
      "fullUrl" : "http://example.org/my-app/MessageHeader/rtpbc-messageheader-request-03a",
      "resource" : {
        "resourceType" : "MessageHeader",
        "id" : "rtpbc-messageheader-request-03a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-request-messageheader"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MessageHeader_rtpbc-messageheader-request-03a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MessageHeader rtpbc-messageheader-request-03a</b></p><a name=\"rtpbc-messageheader-request-03a\"> </a><a name=\"hcrtpbc-messageheader-request-03a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-rtpbc-request-messageheader.html\">RTPBC Request MessageHeader</a></p></div><p><b>event</b>: <a href=\"CodeSystem-rtpbc-event-type.html#rtpbc-event-type-rtpbc-request\">RTPBC Event Type Code System: rtpbc-request</a> (RTPBC Request)</p><h3>Sources</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Name</b></td><td><b>Endpoint</b></td></tr><tr><td style=\"display: none\">*</td><td>MyPatientApp</td><td><a href=\"http://example.org/MyPatientApp\">http://example.org/MyPatientApp</a></td></tr></table><p><b>focus</b>: <a href=\"Bundle-rtpbc-bundle-request-03.html#http-//example.org/my-app/Claim/rtpbc-claim-03a\">Claim: identifier = rtpbc-03a; status = active; type = Pharmacy; use = predetermination; created = 2019-11-01 11:20:54-0500; priority = Normal</a></p><p><b>definition</b>: <a href=\"MessageDefinition-rtpbc-request.html\">RTPBC Request Message Definition</a></p></div>"
        },
        "eventCoding" : {
          "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-event-type",
          "code" : "rtpbc-request",
          "display" : "RTPBC Request"
        },
        "source" : {
          "name" : "MyPatientApp",
          "endpoint" : "http://example.org/MyPatientApp"
        },
        "focus" : [
          {
            "reference" : "http://example.org/my-app/Claim/rtpbc-claim-03a"
          }
        ],
        "definition" : "http://hl7.org/fhir/us/carin-rtpbc/MessageDefinition/rtpbc-request"
      }
    },
    {
      "fullUrl" : "http://example.org/my-app/Claim/rtpbc-claim-03a",
      "resource" : {
        "resourceType" : "Claim",
        "id" : "rtpbc-claim-03a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-request-claim"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Claim_rtpbc-claim-03a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Claim rtpbc-claim-03a</b></p><a name=\"rtpbc-claim-03a\"> </a><a name=\"hcrtpbc-claim-03a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-rtpbc-request-claim.html\">RTPBC Request Using Claim</a></p></div><p><b>identifier</b>: rtpbc-03a</p><p><b>status</b>: Active</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/claim-type pharmacy}\">Pharmacy</span></p><p><b>use</b>: Predetermination</p><p><b>patient</b>: <a href=\"Patient-rtpbc-patient-03.html\">Jane Doe  Female, DoB: 1975-12-05 ( Patient internal identifier: 30455)</a></p><p><b>created</b>: 2019-11-01 11:20:54-0500</p><p><b>provider</b>: <a href=\"Organization-rtpbc-organization-03.html\">Organization Hometown Drug</a></p><p><b>priority</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/processpriority normal}\">Normal</span></p><p><b>prescription</b>: <a href=\"MedicationRequest-rtpbc-medicationrequest-03.html\">MedicationRequest: status = draft; intent = proposal; reported[x] = true; medication[x] = fluoxetine 10 MG Oral Capsule [Prozac]; authoredOn = 2019-11-01</a></p><h3>CareTeams</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Sequence</b></td><td><b>Provider</b></td></tr><tr><td style=\"display: none\">*</td><td>1</td><td><a href=\"Practitioner-rtpbc-practitioner-03.html\">Practitioner Johnson </a></td></tr></table><h3>Insurances</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Sequence</b></td><td><b>Focal</b></td><td><b>Coverage</b></td></tr><tr><td style=\"display: none\">*</td><td>1</td><td>true</td><td><a href=\"Coverage-rtpbc-coverage-01.html\">Coverage: status = active; subscriberId = 121212; relationship = Self</a></td></tr></table><h3>Items</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Sequence</b></td><td><b>CareTeamSequence</b></td><td><b>ProductOrService</b></td><td><b>Quantity</b></td></tr><tr><td style=\"display: none\">*</td><td>1</td><td>1</td><td><span title=\"Codes:{http://www.nlm.nih.gov/research/umls/rxnorm 205535}\">fluoxetine 10 MG Oral Capsule [Prozac]</span></td><td>60 {Each}</td></tr></table></div>"
        },
        "identifier" : [
          {
            "value" : "rtpbc-03a"
          }
        ],
        "status" : "active",
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
              "code" : "pharmacy",
              "display" : "Pharmacy"
            }
          ]
        },
        "use" : "predetermination",
        "patient" : {
          "reference" : "Patient/rtpbc-patient-03"
        },
        "created" : "2019-11-01T11:20:54-05:00",
        "provider" : {
          "reference" : "Organization/rtpbc-organization-03"
        },
        "priority" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/processpriority",
              "code" : "normal",
              "display" : "Normal"
            }
          ]
        },
        "prescription" : {
          "reference" : "MedicationRequest/rtpbc-medicationrequest-03"
        },
        "careTeam" : [
          {
            "sequence" : 1,
            "provider" : {
              "reference" : "Practitioner/rtpbc-practitioner-03"
            }
          }
        ],
        "insurance" : [
          {
            "sequence" : 1,
            "focal" : true,
            "coverage" : {
              "reference" : "Coverage/rtpbc-coverage-01"
            }
          }
        ],
        "item" : [
          {
            "sequence" : 1,
            "careTeamSequence" : [1],
            "productOrService" : {
              "coding" : [
                {
                  "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
                  "code" : "205535",
                  "display" : "fluoxetine 10 MG Oral Capsule [Prozac]"
                }
              ]
            },
            "quantity" : {
              "value" : 60,
              "unit" : "{Each}"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/my-app/Patient/rtpbc-patient-03",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "rtpbc-patient-03",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-patient"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_rtpbc-patient-03\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient rtpbc-patient-03</b></p><a name=\"rtpbc-patient-03\"> </a><a name=\"hcrtpbc-patient-03\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-rtpbc-patient.html\">RTPBC Patient</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Jane Doe  Female, DoB: 1975-12-05 ( Patient internal identifier: 30455)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\">100 Oak Court Madison WI 53510 US </td></tr></table></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PI",
                  "display" : "Patient internal identifier"
                }
              ],
              "text" : "Patient internal identifier"
            },
            "system" : "http://example.org/MyPatientApp",
            "value" : "30455"
          }
        ],
        "name" : [
          {
            "family" : "Doe",
            "given" : ["Jane"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1975-12-05",
        "address" : [
          {
            "line" : ["100 Oak Court"],
            "city" : "Madison",
            "state" : "WI",
            "postalCode" : "53510",
            "country" : "US"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/my-app/Coverage/rtpbc-coverage-01",
      "resource" : {
        "resourceType" : "Coverage",
        "id" : "rtpbc-coverage-01",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-coverage"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Coverage_rtpbc-coverage-01\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Coverage rtpbc-coverage-01</b></p><a name=\"rtpbc-coverage-01\"> </a><a name=\"hcrtpbc-coverage-01\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-rtpbc-coverage.html\">RTPBC Coverage</a></p></div><p><b>status</b>: Active</p><p><b>subscriberId</b>: 121212</p><p><b>beneficiary</b>: <a href=\"Patient-rtpbc-patient-03.html\">Jane Doe  Female, DoB: 1975-12-05 ( Patient internal identifier: 30455)</a></p><p><b>relationship</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/subscriber-relationship self}\">Self</span></p><p><b>payor</b>: Identifier: Pharmacy Plans US</p><blockquote><p><b>class</b></p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/coverage-class rxbin}\">RX BIN</span></p><p><b>value</b>: BIN001</p></blockquote><blockquote><p><b>class</b></p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/coverage-class rxpcn}\">RX PCN</span></p><p><b>value</b>: PCN002</p></blockquote><blockquote><p><b>class</b></p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/coverage-class rxgroup}\">RX Group</span></p><p><b>value</b>: GROUP0001</p></blockquote><blockquote><p><b>class</b></p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/coverage-class rxid}\">RX Id</span></p><p><b>value</b>: MEMBER000001</p></blockquote></div>"
        },
        "status" : "active",
        "subscriberId" : "121212",
        "beneficiary" : {
          "reference" : "Patient/rtpbc-patient-03"
        },
        "relationship" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
              "code" : "self"
            }
          ]
        },
        "payor" : [
          {
            "identifier" : {
              "value" : "Pharmacy Plans US"
            }
          }
        ],
        "class" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                  "code" : "rxbin"
                }
              ]
            },
            "value" : "BIN001"
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                  "code" : "rxpcn"
                }
              ]
            },
            "value" : "PCN002"
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                  "code" : "rxgroup"
                }
              ]
            },
            "value" : "GROUP0001"
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
                  "code" : "rxid"
                }
              ]
            },
            "value" : "MEMBER000001"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/my-app/MedicationRequest/rtpbc-medicationrequest-03",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "rtpbc-medicationrequest-03",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-medicationrequest"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_rtpbc-medicationrequest-03\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest rtpbc-medicationrequest-03</b></p><a name=\"rtpbc-medicationrequest-03\"> </a><a name=\"hcrtpbc-medicationrequest-03\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-rtpbc-medicationrequest.html\">RTPBC Medication Request</a></p></div><p><b>status</b>: Draft</p><p><b>intent</b>: Proposal</p><p><b>reported</b>: true</p><p><b>medication</b>: <span title=\"Codes:{http://www.nlm.nih.gov/research/umls/rxnorm 205535}\">fluoxetine 10 MG Oral Capsule [Prozac]</span></p><p><b>subject</b>: <a href=\"Patient-rtpbc-patient-03.html\">Jane Doe  Female, DoB: 1975-12-05 ( Patient internal identifier: 30455)</a></p><p><b>authoredOn</b>: 2019-11-01</p><p><b>requester</b>: <a href=\"Practitioner-rtpbc-practitioner-03.html\">Practitioner Johnson </a></p><h3>DosageInstructions</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>Take 2 capsules once a day</td></tr></table><blockquote><p><b>dispenseRequest</b></p><p><b>quantity</b>: 60 {Each}</p><h3>ExpectedSupplyDurations</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Unit</b></td><td><b>System</b></td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td>30</td><td>days</td><td><a href=\"http://terminology.hl7.org/5.5.0/CodeSystem-v3-ucum.html\">http://unitsofmeasure.org</a></td><td>d</td></tr></table><p><b>performer</b>: <a href=\"Organization-rtpbc-organization-03.html\">Organization Hometown Drug</a></p></blockquote><h3>Substitutions</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Allowed[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>false</td></tr></table></div>"
        },
        "status" : "draft",
        "intent" : "proposal",
        "reportedBoolean" : true,
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
              "code" : "205535",
              "display" : "fluoxetine 10 MG Oral Capsule [Prozac]"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/rtpbc-patient-03"
        },
        "authoredOn" : "2019-11-01",
        "requester" : {
          "reference" : "Practitioner/rtpbc-practitioner-03"
        },
        "dosageInstruction" : [
          {
            "text" : "Take 2 capsules once a day"
          }
        ],
        "dispenseRequest" : {
          "quantity" : {
            "value" : 60,
            "unit" : "{Each}"
          },
          "expectedSupplyDuration" : {
            "value" : 30,
            "unit" : "days",
            "system" : "http://unitsofmeasure.org",
            "code" : "d"
          },
          "performer" : {
            "reference" : "Organization/rtpbc-organization-03"
          }
        },
        "substitution" : {
          "allowedBoolean" : false
        }
      }
    },
    {
      "fullUrl" : "http://example.org/my-app/Practitioner/rtpbc-practitioner-03",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "rtpbc-practitioner-03",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_rtpbc-practitioner-03\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner rtpbc-practitioner-03</b></p><a name=\"rtpbc-practitioner-03\"> </a><a name=\"hcrtpbc-practitioner-03\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU8.0.1/StructureDefinition-us-core-practitioner.html\">US Core Practitioner Profile</a></p></div><p><b>identifier</b>: <a href=\"http://terminology.hl7.org/5.5.0/NamingSystem-npi.html\" title=\"National Provider Identifier\">United States National Provider Identifier</a>/1234567893</p><p><b>name</b>: Johnson </p></div>"
        },
        "identifier" : [
          {
            "system" : "http://hl7.org/fhir/sid/us-npi",
            "value" : "1234567893"
          }
        ],
        "name" : [
          {
            "family" : "Johnson"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/my-app/Organization/rtpbc-organization-03",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "rtpbc-organization-03",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-pharmacy-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_rtpbc-organization-03\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization rtpbc-organization-03</b></p><a name=\"rtpbc-organization-03\"> </a><a name=\"hcrtpbc-organization-03\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-rtpbc-pharmacy-organization.html\">RTPBC Pharmacy Organization</a></p></div><p><b>identifier</b>: <a href=\"http://terminology.hl7.org/5.5.0/NamingSystem-npi.html\" title=\"National Provider Identifier\">United States National Provider Identifier</a>/9876543213</p><p><b>active</b>: true</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/NCPDPPharmacyType R}\">Retail</span></p><p><b>name</b>: Hometown Drug</p><p><b>telecom</b>: ph: 6081234567</p><p><b>address</b>: 900 9th Street Madison WI 53535 US </p></div>"
        },
        "identifier" : [
          {
            "system" : "http://hl7.org/fhir/sid/us-npi",
            "value" : "9876543213"
          }
        ],
        "active" : true,
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/NCPDPPharmacyType",
                "code" : "R",
                "display" : "Retail"
              }
            ]
          }
        ],
        "name" : "Hometown Drug",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "6081234567"
          }
        ],
        "address" : [
          {
            "line" : ["900 9th Street"],
            "city" : "Madison",
            "state" : "WI",
            "postalCode" : "53535",
            "country" : "US"
          }
        ]
      }
    }
  ]
}

```
