# Submission Method - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Submission Method

[Previous Page](business_rules.md)

### Operation: $process-message

The RTPBC request is submitted using the $process-message operation on the processor's claim server…

* URL: [base]/$process-message

#### Process-message parameter and response

Like the option above, the $process-message operation takes a single FHIR® resource input parameter consisting of a Bundle containing the Claim resource and referenced supporting resources, and returns a Bundle containing a ClaimResponse and supporting resources.

In addition, this method includes a MessageHeader resource in both the request and response.

* In the request, the MessageHeader's **focus.reference** points to the Bundle's Claim resource, per the [RtpbcRequestMessageDefinition.](MessageDefinition-rtpbc-request.md)
* In the response, the **focus.reference** points to the Bundle's ClaimResponse, per the [RtpbcResponseMessageDefinition.](MessageDefinition-rtpbc-response.md)

### Synchronous response

The response in the RTPBC exchange is expected to be synchronous, with real-time response times to support use in interactive patient-facing applications.

### Examples

[Example bundled RTPBC request to payer/PBM. Using messaging ($process-message operation, with MessageHeaders)](Bundle-rtpbc-bundle-request-03.md)

[Example bundled RTPBC response from payer/PBM. Using messaging ($process-message operation, with MessageHeaders)](Bundle-rtpbc-bundle-response-03.md)

[Next Page](error_handling.md)

