# hl7.fhir.us.carin-rtpbc#2.0.0: Consumer Real-Time Pharmacy Benefit Check FHIR IG(en)

## Pages

* [Home](index.md)
* [Consumer vs Provider Rtpbc](consumer_vs_provider_rtpbc.md)
* [Information Content and Fhir Resources](information_content_and_fhir_resources.md)
* [Terminology](terminology.md)
* [Business Rules](business_rules.md)
* [Security](security.md)
* [Capstatements](capstatements.md)
* [Profiles](profiles.md)
* [Submission Method](submission_method.md)
* [Use Cases](use_cases.md)
* [Error Handling](error_handling.md)
* [Artifacts Summary](artifacts.md)
* [Downloads](downloads.md)

## Resources

### CodeSystems

* [RTPBC Benefit Restriction Code System](CodeSystem-rtpbc-benefit-restriction.md)
* [RTPBC Event Type Code System](CodeSystem-rtpbc-event-type.md)
* [RTPBC Formulary Status Code System](CodeSystem-rtpbc-formulary-status.md)
* [RTPBC Patient Pay Type Code System](CodeSystem-rtpbc-patient-pay-type.md)

### ValueSets

* [RTPBC Benefit Restriction Value Set](ValueSet-rtpbc-benefit-restriction.md)
* [RTPBC Billing Unit Value Set](ValueSet-rtpbc-billing-unit.md)
* [RTPBC Country Code Value Set](ValueSet-rtpbc-country-code.md)
* [RTPBC Error Code Value Set](ValueSet-rtpbc-error-code.md)
* [RTPBC Event Type Value Set](ValueSet-rtpbc-event-type.md)
* [RTPBC Formulary Status Value Set](ValueSet-rtpbc-formulary-status.md)
* [RTPBC Patient Pay Type Value Set](ValueSet-rtpbc-patient-pay-type.md)
* [RTPBC Pharmacy Type Value Set](ValueSet-rtpbc-pharmacy-type.md)
* [RTPBC Prescribable Product Code Value Set](ValueSet-rtpbc-prescribable-product-code.md)
* [RTPBC Two Letter State and Province Code Value Set](ValueSet-rtpbc-state-and-province-code.md)

### Resource Profiles

* [RTPBC Coverage](StructureDefinition-rtpbc-coverage.md)
* [RTPBC Medication Request - Non-PHI](StructureDefinition-rtpbc-medicationrequest-non-phi.md)
* [RTPBC Medication Request](StructureDefinition-rtpbc-medicationrequest.md)
* [RTPBC Patient - Non-PHI](StructureDefinition-rtpbc-patient-non-phi.md)
* [RTPBC Patient](StructureDefinition-rtpbc-patient.md)
* [RTPBC Pharmacy Organization](StructureDefinition-rtpbc-pharmacy-organization.md)
* [RTPBC Request Bundle - Non-PHI](StructureDefinition-rtpbc-request-bundle-non-phi.md)
* [RTPBC Request Bundle](StructureDefinition-rtpbc-request-bundle.md)
* [RTPBC Request Using Claim - Non-PHI](StructureDefinition-rtpbc-request-claim-non-phi.md)
* [RTPBC Request Using Claim](StructureDefinition-rtpbc-request-claim.md)
* [RTPBC Request MessageHeader](StructureDefinition-rtpbc-request-messageheader.md)
* [RTPBC Response Bundle](StructureDefinition-rtpbc-response-bundle.md)
* [RTPBC Response Using ClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md)
* [RTPBC Response MessageHeader](StructureDefinition-rtpbc-response-messageheader.md)

### Extensions

* [RTPBC benefitRestriction Extension](StructureDefinition-rtpbc-benefitRestriction.md)
* [RTPBC formularyStatus Extension](StructureDefinition-rtpbc-formularyStatus.md)
* [RTPBC isAlternative Extension](StructureDefinition-rtpbc-isAlternative.md)
* [RTPBC nextAvailableFillDate Extension](StructureDefinition-rtpbc-nextAvailableFillDate.md)
* [RTPBC preferenceLevel Extension](StructureDefinition-rtpbc-preferenceLevel.md)

### CapabilityStatements

* [RTPBC Requester Capability Statement](CapabilityStatement-rtpbc-requester.md)
* [RTPBC Responder Capability Statement](CapabilityStatement-rtpbc-responder.md)

### ImplementationGuides

* [Consumer Real-Time Pharmacy Benefit Check FHIR IG](ImplementationGuide-hl7.fhir.us.carin-rtpbc.md)

### MessageDefinitions

* [RTPBC Request Message Definition](MessageDefinition-rtpbc-request.md)
* [RTPBC Response Message Definition](MessageDefinition-rtpbc-response.md)

### Examples

* [rtpbc-bundle-request-03 (Bundle)](Bundle-rtpbc-bundle-request-03.md)
* [rtpbc-bundle-request-non-phi-1 (Bundle)](Bundle-rtpbc-bundle-request-non-phi-1.md)
* [rtpbc-bundle-request-non-phi-2 (Bundle)](Bundle-rtpbc-bundle-request-non-phi-2.md)
* [rtpbc-bundle-request-price-source (Bundle)](Bundle-rtpbc-bundle-request-price-source.md)
* [rtpbc-bundle-response-03 (Bundle)](Bundle-rtpbc-bundle-response-03.md)
* [rtpbc-bundle-response-price-source (Bundle)](Bundle-rtpbc-bundle-response-price-source.md)
* [rtpbc-claim-03 (Claim)](Claim-rtpbc-claim-03.md)
* [rtpbc-claim-non-phi-1 (Claim)](Claim-rtpbc-claim-non-phi-1.md)
* [rtpbc-claim-non-phi-2 (Claim)](Claim-rtpbc-claim-non-phi-2.md)
* [rtpbc-claim-response-03-price-source (ClaimResponse)](ClaimResponse-rtpbc-claim-response-03-price-source.md)
* [rtpbc-claim-response-03 (ClaimResponse)](ClaimResponse-rtpbc-claim-response-03.md)
* [rtpbc-claim-response-not-covered (ClaimResponse)](ClaimResponse-rtpbc-claim-response-not-covered.md)
* [rtpbc-coverage-01 (Coverage)](Coverage-rtpbc-coverage-01.md)
* [rtpbc-medicationrequest-03 (MedicationRequest)](MedicationRequest-rtpbc-medicationrequest-03.md)
* [rtpbc-medicationrequest-non-phi-1 (MedicationRequest)](MedicationRequest-rtpbc-medicationrequest-non-phi-1.md)
* [rtpbc-medicationrequest-non-phi-2 (MedicationRequest)](MedicationRequest-rtpbc-medicationrequest-non-phi-2.md)
* [Hometown Drug (Organization)](Organization-rtpbc-organization-03.md)
* [My Mail Service Pharmacy (Organization)](Organization-rtpbc-organization-03m.md)
* [Home Drugs (Organization)](Organization-rtpbc-organization-03ps.md)
* [rtpbc-patient-03 (Patient)](Patient-rtpbc-patient-03.md)
* [rtpbc-patient-03ps (Patient)](Patient-rtpbc-patient-03ps.md)
* [rtpbc-patient-non-phi-1 (Patient)](Patient-rtpbc-patient-non-phi-1.md)
* [rtpbc-practitioner-03 (Practitioner)](Practitioner-rtpbc-practitioner-03.md)
