# RTPBC Two Letter State and Province Code Value Set - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## ValueSet: RTPBC Two Letter State and Province Code Value Set 

 
This value set contains two letter USPS state codes and Canada Post province codes. 

 **References** 

* [RTPBC Patient](StructureDefinition-rtpbc-patient.md)
* [RTPBC Patient - Non-PHI](StructureDefinition-rtpbc-patient-non-phi.md)
* [RTPBC Pharmacy Organization](StructureDefinition-rtpbc-pharmacy-organization.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "rtpbc-state-and-province-code",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-state-and-province-code",
  "version" : "2.0.0",
  "name" : "RtpbcStateAndProvinceCodeValueSet",
  "title" : "RTPBC Two Letter State and Province Code Value Set",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-05-23T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This value set contains two letter USPS state codes and Canada Post province codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://www.usps.com/",
        "concept" : [
          {
            "code" : "AK",
            "display" : "Alaska"
          },
          {
            "code" : "AL",
            "display" : "Alabama"
          },
          {
            "code" : "AR",
            "display" : "Arkansas"
          },
          {
            "code" : "AZ",
            "display" : "Arizona"
          },
          {
            "code" : "CA",
            "display" : "California"
          },
          {
            "code" : "CO",
            "display" : "Colorado"
          },
          {
            "code" : "CT",
            "display" : "Connecticut"
          },
          {
            "code" : "DC",
            "display" : "District of Columbia"
          },
          {
            "code" : "DE",
            "display" : "Delaware"
          },
          {
            "code" : "FL",
            "display" : "Florida"
          },
          {
            "code" : "GA",
            "display" : "Georgia"
          },
          {
            "code" : "HI",
            "display" : "Hawaii"
          },
          {
            "code" : "IA",
            "display" : "Iowa"
          },
          {
            "code" : "ID",
            "display" : "Idaho"
          },
          {
            "code" : "IL",
            "display" : "Illinois"
          },
          {
            "code" : "IN",
            "display" : "Indiana"
          },
          {
            "code" : "KS",
            "display" : "Kansas"
          },
          {
            "code" : "KY",
            "display" : "Kentucky"
          },
          {
            "code" : "LA",
            "display" : "Louisiana"
          },
          {
            "code" : "MA",
            "display" : "Massachusetts"
          },
          {
            "code" : "MD",
            "display" : "Maryland"
          },
          {
            "code" : "ME",
            "display" : "Maine"
          },
          {
            "code" : "MI",
            "display" : "Michigan"
          },
          {
            "code" : "MN",
            "display" : "Minnesota"
          },
          {
            "code" : "MO",
            "display" : "Missouri"
          },
          {
            "code" : "MS",
            "display" : "Mississippi"
          },
          {
            "code" : "MT",
            "display" : "Montana"
          },
          {
            "code" : "NC",
            "display" : "North Carolina"
          },
          {
            "code" : "ND",
            "display" : "North Dakota"
          },
          {
            "code" : "NE",
            "display" : "Nebraska"
          },
          {
            "code" : "NH",
            "display" : "New Hampshire"
          },
          {
            "code" : "NJ",
            "display" : "New Jersey"
          },
          {
            "code" : "NM",
            "display" : "New Mexico"
          },
          {
            "code" : "NV",
            "display" : "Nevada"
          },
          {
            "code" : "NY",
            "display" : "New York"
          },
          {
            "code" : "OH",
            "display" : "Ohio"
          },
          {
            "code" : "OK",
            "display" : "Oklahoma"
          },
          {
            "code" : "OR",
            "display" : "Oregon"
          },
          {
            "code" : "PA",
            "display" : "Pennsylvania"
          },
          {
            "code" : "RI",
            "display" : "Rhode Island"
          },
          {
            "code" : "SC",
            "display" : "South Carolina"
          },
          {
            "code" : "SD",
            "display" : "South Dakota"
          },
          {
            "code" : "TN",
            "display" : "Tennessee"
          },
          {
            "code" : "TX",
            "display" : "Texas"
          },
          {
            "code" : "UT",
            "display" : "Utah"
          },
          {
            "code" : "VA",
            "display" : "Virginia"
          },
          {
            "code" : "VT",
            "display" : "Vermont"
          },
          {
            "code" : "WA",
            "display" : "Washington"
          },
          {
            "code" : "WI",
            "display" : "Wisconsin"
          },
          {
            "code" : "WV",
            "display" : "West Virginia"
          },
          {
            "code" : "WY",
            "display" : "Wyoming"
          },
          {
            "code" : "AA",
            "display" : "Armed Forces Americas (except Canada)"
          },
          {
            "code" : "AE",
            "display" : "Armed Forces Europe, the Middle East, and Canada"
          },
          {
            "code" : "AP",
            "display" : "Armed Forces Pacific"
          },
          {
            "code" : "AS",
            "display" : "American Samoa"
          },
          {
            "code" : "FM",
            "display" : "Federated States of Micronesia"
          },
          {
            "code" : "GU",
            "display" : "Guam"
          },
          {
            "code" : "MH",
            "display" : "Marshall Islands"
          },
          {
            "code" : "MP",
            "display" : "Northern Mariana Islands"
          },
          {
            "code" : "PR",
            "display" : "Puerto Rico"
          },
          {
            "code" : "PW",
            "display" : "Palau"
          },
          {
            "code" : "VI",
            "display" : "Virgin Islands"
          }
        ]
      },
      {
        "system" : "http://canadapost.ca/CodeSystem/ProvinceCodes",
        "concept" : [
          {
            "code" : "AB",
            "display" : "Alberta"
          },
          {
            "code" : "BC",
            "display" : "British Columbia"
          },
          {
            "code" : "MB",
            "display" : "Manitoba"
          },
          {
            "code" : "NB",
            "display" : "New Brunswick"
          },
          {
            "code" : "NL",
            "display" : "Newfoundland and Labrador"
          },
          {
            "code" : "NS",
            "display" : "Nova Scotia"
          },
          {
            "code" : "NT",
            "display" : "Northwest Territories"
          },
          {
            "code" : "NU",
            "display" : "Nunavut"
          },
          {
            "code" : "ON",
            "display" : "Ontario"
          },
          {
            "code" : "PE",
            "display" : "Prince Edward Island"
          },
          {
            "code" : "QC",
            "display" : "Quebec"
          },
          {
            "code" : "SK",
            "display" : "Saskatchewan"
          },
          {
            "code" : "YT",
            "display" : "Yukon"
          }
        ]
      }
    ]
  }
}

```
