# RTPBC Pharmacy Type Value Set - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## ValueSet: RTPBC Pharmacy Type Value Set 

 
This value set contains pharmacy type categories defined in the NCPDP Pharmacy Type (955-HR) code system. 

 **References** 

* [RTPBC Pharmacy Organization](StructureDefinition-rtpbc-pharmacy-organization.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 

### Notes:

﻿All codes are from the licensed NCPDP Pharmacy Type (955-HR) code set, maintained by the National Council for Prescription Drug Programs. 

### Concept examples

 
The up-to-date content of the NCPDP Pharmacy Type (955-HR) code set is available to NCPDP members. 
However, a past version of the code set is publicly available in the AHRQ United States Health Information Knowledgebase (USHIK). Below is the full set of concepts from that public source. 

* **Code**: R
  * **Display**: Retail
* **Code**: M
  * **Display**: Mail Order
* **Code**: S
  * **Display**: Specialty
* **Code**: L
  * **Display**: Long-Term Care
* **Code**: A
  * **Display**: Any

 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "rtpbc-pharmacy-type",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-pharmacy-type",
  "version" : "2.0.0",
  "name" : "RtpbcPharmacyTypeValueSet",
  "title" : "RTPBC Pharmacy Type Value Set",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-05-23T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This value set contains pharmacy type categories defined in the NCPDP Pharmacy Type (955-HR) code system.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/NCPDPPharmacyType"
      }
    ]
  }
}

```
