# RTPBC Request Using Claim - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Resource Profile: RTPBC Request Using Claim 

 
This profile constrains the Claim resource so that it can serve as the RTPBC Request in the consumer real-time pharmacy benefit check process 

This profile constrains the Claim resource so that it can serve as the request in the consumer Real-time Pharmacy Benefit Check (RTPBC) process. 

 Data population is similar to a typical Claim **predetermination** request (where Claim.use set to "predetermination"), with the following key differences: Certain elements are fixed to values reflecting a medication-related request…

* Claim.type = "pharmacy"
* Claim.provider references an Organization resource that represents the patient's preferred pharmacy
* Claim.prescription is mandatory (referencing a MedicationRequest resource)
* Claim.careTeam.provider is mandatory, referencing a Practitioner resource that identifies the prescriber
* Claim.item elements are constrained to product identifiers and quantity units of measure describing medications

In addition, no pricing / cost information is submitted in the request since the goal of the exchange is learn the expected cost to the patient rather than reimbursement information for a pharmacy. 


In this profile, the Claim references the following supported resources. All are profiled in this guide except Practitioner, which uses the US Core Practitioner profile without further constraints.

* [Patient](StructureDefinition-rtpbc-patient.md) (containing a small amount of identifying information to enable the insurer to locate the patient's records)
* [Coverage](StructureDefinition-rtpbc-coverage.md) (containing identification of the patient's pharmacy benefit coverage)
* [MedicationRequest](StructureDefinition-rtpbc-medicationrequest.md) (containing excerpts from the prescription to be priced)
* Practitioner (identifying the prescriber. Uses US Core Practitioner)
* [Organization](StructureDefinition-rtpbc-pharmacy-organization.md) (identifying the pharmacy) 


### Must Support elements in this profile

**Client systems**

* Elements that are marked Must Support are essential for the responder to identify the applicable plan rules and accurately determine patient costs and coverage. The submitter MUST ensure that content in these elements is accurate and complete in order to receive reliable information in the response.
* A reference to a coverage resource MUST be included when submitting to an insurer. It is not required when submitting to a pricing source.

**Responding systems**

* MUST make use of all pertinent information provided in the Claim request when determining cost and coverage. 


**Usages:**

* Use this Profile: [RTPBC Request Bundle](StructureDefinition-rtpbc-request-bundle.md)
* Examples for this Profile: [Claim/rtpbc-claim-03](Claim-rtpbc-claim-03.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.carin-rtpbc|current/StructureDefinition/rtpbc-request-claim)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-rtpbc-request-claim.csv), [Excel](../StructureDefinition-rtpbc-request-claim.xlsx), [Schematron](../StructureDefinition-rtpbc-request-claim.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rtpbc-request-claim",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-request-claim",
  "version" : "2.0.0",
  "name" : "RtpbcRequestClaim",
  "title" : "RTPBC Request Using Claim",
  "status" : "active",
  "date" : "2020-05-23T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This profile constrains the Claim resource so that it can serve as the RTPBC Request in the consumer real-time pharmacy benefit check process",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Claim",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Claim",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Claim.id",
        "path" : "Claim.id",
        "label" : "Unique Claim Resource Identifier",
        "short" : "Unique Claim Resource Identifier",
        "definition" : "Unique Claim Resource Identifier assigned by the submitting patient application",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.identifier",
        "path" : "Claim.identifier",
        "label" : "RTPBC request identifier",
        "short" : "RTPBC request identifier",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.identifier.value",
        "path" : "Claim.identifier.value",
        "label" : "Unique RTPBC request ID",
        "short" : "Unique RTPBC request ID",
        "definition" : "An identifier for each RTPBC request that is assigned by and unique to the submitter",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.status",
        "path" : "Claim.status",
        "label" : "Request status",
        "short" : "Request status",
        "definition" : "The status of this request (active)",
        "comment" : "Value is always 'active'",
        "fixedCode" : "active",
        "mustSupport" : true
      },
      {
        "id" : "Claim.type",
        "path" : "Claim.type",
        "label" : "Requested Service Type",
        "short" : "Requested Service Type",
        "definition" : "The type of service for which pricing and coverage predetermination is being requested",
        "comment" : "Value is always 'pharmacy'",
        "mustSupport" : true
      },
      {
        "id" : "Claim.type.coding",
        "path" : "Claim.type.coding",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.type.coding.system",
        "path" : "Claim.type.coding.system",
        "min" : 1,
        "fixedUri" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "mustSupport" : true
      },
      {
        "id" : "Claim.type.coding.code",
        "path" : "Claim.type.coding.code",
        "min" : 1,
        "fixedCode" : "pharmacy",
        "mustSupport" : true
      },
      {
        "id" : "Claim.type.coding.display",
        "path" : "Claim.type.coding.display",
        "min" : 1,
        "fixedString" : "Pharmacy",
        "mustSupport" : true
      },
      {
        "id" : "Claim.use",
        "path" : "Claim.use",
        "label" : "Processing Mode",
        "short" : "Processing Mode",
        "definition" : "The mode of processing being requested of the payer/PBM",
        "comment" : "Value is always 'predetermination'",
        "fixedCode" : "predetermination",
        "mustSupport" : true
      },
      {
        "id" : "Claim.patient",
        "path" : "Claim.patient",
        "label" : "Request Patient Information",
        "short" : "Request Patient Information",
        "definition" : "Limited patient information required in the consumer real-time pharmacy benefit check (RTPBC) process",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.patient.reference",
        "path" : "Claim.patient.reference",
        "label" : "Patient Reference",
        "short" : "Patient Reference",
        "definition" : "Reference to a Patient resource",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.created",
        "path" : "Claim.created",
        "label" : "Created DateTime",
        "short" : "Created DateTime",
        "definition" : "The date and time on which this RTBPC request was created",
        "mustSupport" : true
      },
      {
        "id" : "Claim.provider",
        "path" : "Claim.provider",
        "label" : "Preferred Pharmacy",
        "short" : "Preferred Pharmacy",
        "definition" : "The patient's preferred pharmacy to be considered during creation of the response",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-pharmacy-organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.provider.reference",
        "path" : "Claim.provider.reference",
        "label" : "Reference to Pharmacy Organization",
        "short" : "Reference to Pharmacy Organization",
        "definition" : "Reference to an Organization resource representing the patient's preferred pharmacy",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.priority",
        "path" : "Claim.priority",
        "label" : "Processing priority",
        "short" : "Processing priority",
        "definition" : "The processing priority requested of the payer/PBM",
        "comment" : "All requests are responded to in real-time, without differentiated priority levels. Value is always 'normal'",
        "mustSupport" : true
      },
      {
        "id" : "Claim.priority.coding",
        "path" : "Claim.priority.coding",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.priority.coding.system",
        "path" : "Claim.priority.coding.system",
        "min" : 1,
        "fixedUri" : "http://terminology.hl7.org/CodeSystem/processpriority",
        "mustSupport" : true
      },
      {
        "id" : "Claim.priority.coding.code",
        "path" : "Claim.priority.coding.code",
        "min" : 1,
        "fixedCode" : "normal",
        "mustSupport" : true
      },
      {
        "id" : "Claim.priority.coding.display",
        "path" : "Claim.priority.coding.display",
        "min" : 1,
        "fixedString" : "Normal",
        "mustSupport" : true
      },
      {
        "id" : "Claim.prescription",
        "path" : "Claim.prescription",
        "label" : "Prescription Reference",
        "short" : "Prescription Reference",
        "definition" : "Reference to the pertinent prescription information in a MedicationRequest resource.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-medicationrequest"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.prescription.reference",
        "path" : "Claim.prescription.reference",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.careTeam",
        "path" : "Claim.careTeam",
        "label" : "Prescriber",
        "short" : "Prescriber",
        "definition" : "Prescriber reference",
        "comment" : "The careTeam represents the specific practitioner that prescribed the medication. Thus, a single careTeam element is included in the RTPBC request",
        "requirements" : "The specific practitioner that prescribed the medication.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.careTeam.sequence",
        "path" : "Claim.careTeam.sequence",
        "fixedPositiveInt" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.careTeam.provider",
        "path" : "Claim.careTeam.provider",
        "label" : "Prescriber",
        "short" : "Prescriber",
        "definition" : "Prescriber of the item being submitted",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.careTeam.provider.reference",
        "path" : "Claim.careTeam.provider.reference",
        "label" : "Prescriber Reference",
        "short" : "Prescriber Reference",
        "definition" : "Reference to a Practitioner resource that represents the prescriber",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.insurance",
        "path" : "Claim.insurance",
        "label" : "Pharmacy Coverage",
        "short" : "Pharmacy Coverage",
        "definition" : "The patient's pharmacy coverage information",
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.insurance.sequence",
        "path" : "Claim.insurance.sequence",
        "comment" : "Only one set of coverage is submitted in the request. Value is always '1'",
        "fixedPositiveInt" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.insurance.focal",
        "path" : "Claim.insurance.focal",
        "fixedBoolean" : true,
        "mustSupport" : true
      },
      {
        "id" : "Claim.insurance.coverage",
        "path" : "Claim.insurance.coverage",
        "label" : "Pharmacy Coverage Reference",
        "short" : "Pharmacy Coverage Reference",
        "definition" : "Reference to a Coverage resource containing identification of the patient's pharmacy coverage",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-coverage"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Claim.insurance.coverage.reference",
        "path" : "Claim.insurance.coverage.reference",
        "label" : "Pharmacy Coverage Reference",
        "short" : "Pharmacy Coverage Reference",
        "definition" : "Reference to a Coverage resource containing identification of the patient's pharmacy coverage",
        "mustSupport" : true
      },
      {
        "id" : "Claim.item",
        "path" : "Claim.item",
        "label" : "Max 1 item per request",
        "short" : "Max 1 item per request",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.item.sequence",
        "path" : "Claim.item.sequence",
        "comment" : "A maximum of one product is submitted per request. Value is always '1'",
        "fixedPositiveInt" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.item.careTeamSequence",
        "path" : "Claim.item.careTeamSequence",
        "label" : "Care Team Sequence ID Reference",
        "short" : "Care Team Sequence ID Reference",
        "definition" : "A reference to the Care Team composite in this resource that reflects the prescriber",
        "comment" : "Populate with a reference to .careTeam.sequence.@id",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Claim.item.productOrService",
        "path" : "Claim.item.productOrService",
        "label" : "Prescribed Product",
        "short" : "Prescribed Product",
        "definition" : "A product identifier for the prescribed medication. Either an NDC11 or an RxNorm code for a prescribable product (representing drug name, strength and dose form)",
        "comment" : "The NDC11 is an 11-digit normalized format consisting of a 5-digit labeler segment, 4-digit product segment, and 2-digit package segment, with no dashes",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "RTPBC prescribable product codes (NDC11 and RxNorm)",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-prescribable-product-code"
        }
      },
      {
        "id" : "Claim.item.productOrService.coding",
        "path" : "Claim.item.productOrService.coding",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.item.productOrService.coding.system",
        "path" : "Claim.item.productOrService.coding.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.item.productOrService.coding.code",
        "path" : "Claim.item.productOrService.coding.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.item.productOrService.coding.display",
        "path" : "Claim.item.productOrService.coding.display",
        "label" : "Product Description",
        "short" : "Product Description",
        "definition" : "The full prescribable product name, including drug name, strength and dose form. The drug name equals the brand name if the branded product is desired",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.item.quantity",
        "path" : "Claim.item.quantity",
        "label" : "Prescribed Quantity",
        "short" : "Prescribed Quantity",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.item.quantity.value",
        "path" : "Claim.item.quantity.value",
        "label" : "Quantity in Billing Units",
        "short" : "Quantity in Billing Units",
        "definition" : "The prescribed quantity in terms of the applicable billing unit of measure",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Claim.item.quantity.unit",
        "path" : "Claim.item.quantity.unit",
        "label" : "Billing unit of measure",
        "short" : "Billing unit of measure",
        "definition" : "Pharmacy metric billing unit: GM (gram), ML (milliliter) or EA (each)",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Billing quantity unit of measure",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-billing-unit"
        }
      }
    ]
  }
}

```
