# RTPBC Pharmacy Organization - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Resource Profile: RTPBC Pharmacy Organization 

 
This profile builds on the US Core Organization to represent a pharmacy as used in the real-time pharmacy benefit check (RTPBC) process. 

The function of the Pharmacy resource in this exchange is to identify a pharmacy as either…

* the patient's preferred pharmacy, in the RTPBC request
* or an alternative pharmacy for which information is being returned in the RTPBC response

The set of conveyed pharmacy information consists of…

* identification of the pharmacy. The [NCPDP Provider Identification Number](https://terminology.hl7.org/CodeSystem-NCPDPProviderIdentificationNumber.html) is the preferred identifier for this purpose because it specifies the individual pharmacy location. Alternatively, an organizational NPI may be used
* the pharmacy name
* the phone number
* the pharmacy address 


### Must Support elements in this profile

**Client systems**

* The pharmacy identifier and name MUST be populated with correct information in order for the processor to determine reliable cost and coverage information
* Pharmacy phone and address SHOULD be populated to assist in identifying a particular pharmacy location, especially when identifying the pharmacy using an NPI

**Responding systems**

* MUST consider pharmacy type and location when determining pricing, coverage, and alternative pharmacy options 


**Usages:**

* Use this Profile: [RTPBC Request Bundle - Non-PHI](StructureDefinition-rtpbc-request-bundle-non-phi.md), [RTPBC Request Bundle](StructureDefinition-rtpbc-request-bundle.md) and [RTPBC Response Bundle](StructureDefinition-rtpbc-response-bundle.md)
* Refer to this Profile: [RTPBC Request Using Claim - Non-PHI](StructureDefinition-rtpbc-request-claim-non-phi.md), [RTPBC Request Using Claim](StructureDefinition-rtpbc-request-claim.md) and [RTPBC Response Using ClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md)
* Examples for this Profile: [Hometown Drug](Organization-rtpbc-organization-03.md), [My Mail Service Pharmacy](Organization-rtpbc-organization-03m.md) and [Home Drugs](Organization-rtpbc-organization-03ps.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.carin-rtpbc|current/StructureDefinition/rtpbc-pharmacy-organization)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-rtpbc-pharmacy-organization.csv), [Excel](../StructureDefinition-rtpbc-pharmacy-organization.xlsx), [Schematron](../StructureDefinition-rtpbc-pharmacy-organization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rtpbc-pharmacy-organization",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-pharmacy-organization",
  "version" : "2.0.0",
  "name" : "RtpbcPharmacy",
  "title" : "RTPBC Pharmacy Organization",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-05-23T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This profile builds on the US Core Organization to represent a pharmacy as used in the real-time pharmacy benefit check (RTPBC) process.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "label" : "Pharmacy Identifier",
        "short" : "Pharmacy Identifier",
        "definition" : "The pharmacy's identifier (organizational NPI or NCPDP ID)",
        "comment" : "Either an NPI or NCPDP ID must be present",
        "min" : 1
      },
      {
        "id" : "Organization.identifier.system",
        "path" : "Organization.identifier.system",
        "min" : 1
      },
      {
        "id" : "Organization.identifier.value",
        "path" : "Organization.identifier.value",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:NPI",
        "path" : "Organization.identifier",
        "sliceName" : "NPI",
        "label" : "National Provider Identifier (NPI)",
        "definition" : "The pharmacy's organizational NPI",
        "requirements" : "Populate with the organizational NPI that most specifically represents the intended pharmacy location"
      },
      {
        "id" : "Organization.identifier:NPI.system",
        "path" : "Organization.identifier.system",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:NPI.value",
        "path" : "Organization.identifier.value",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:CLIA",
        "path" : "Organization.identifier",
        "sliceName" : "CLIA"
      },
      {
        "id" : "Organization.identifier:CLIA.system",
        "path" : "Organization.identifier.system",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:CLIA.value",
        "path" : "Organization.identifier.value",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:NAIC",
        "path" : "Organization.identifier",
        "sliceName" : "NAIC"
      },
      {
        "id" : "Organization.identifier:NAIC.system",
        "path" : "Organization.identifier.system",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:NAIC.value",
        "path" : "Organization.identifier.value",
        "min" : 1
      },
      {
        "id" : "Organization.identifier:NcpdpProviderId",
        "path" : "Organization.identifier",
        "sliceName" : "NcpdpProviderId",
        "label" : "NCPDP Provider ID",
        "short" : "NCPDP Provider ID",
        "definition" : "The pharmacy's NCPDP Provider ID",
        "min" : 0,
        "max" : "1",
        "patternIdentifier" : {
          "system" : "http://terminology.hl7.org/CodeSystem/NCPDPProviderIdentificationNumber"
        },
        "mustSupport" : true
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "label" : "Pharmacy Type",
        "short" : "Pharmacy Type",
        "definition" : "Pharmacy type: R (Retail), M (Mail order), S (Specialty), L (Long-term care), A (Pharmacy without restriction)",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "RTPBC Pharmacy Type Value Set",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-pharmacy-type"
        }
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "label" : "Pharmacy Name",
        "short" : "Pharmacy Name"
      },
      {
        "id" : "Organization.telecom",
        "path" : "Organization.telecom",
        "label" : "Pharmacy Telephone",
        "short" : "Pharmacy Telephone",
        "definition" : "Pharmacy telephone number for patients, customers",
        "comment" : "Must Support when the pharmacy is included in the RTPBC response (ClaimResponse). \"Must support\" means that (a) the responding payer/PBM can provide a patient-appropriate telephone number for covered pharmacies and (b) the patient application can make the phone number available to the user as it deems appropriate"
      },
      {
        "id" : "Organization.telecom.system",
        "path" : "Organization.telecom.system",
        "min" : 1,
        "fixedCode" : "phone"
      },
      {
        "id" : "Organization.telecom.value",
        "path" : "Organization.telecom.value",
        "min" : 1
      },
      {
        "id" : "Organization.address",
        "path" : "Organization.address",
        "label" : "Pharmacy Address",
        "short" : "Pharmacy Address",
        "definition" : "The pharmacy store address",
        "comment" : "Must Support when the pharmacy is included in the RTPBC response (ClaimResponse). \"Must support\" means that (a) the responding payer/PBM can provide pharmacy address information for covered pharmacies that the patient may have a need to contact or visit (e.g., a retail pharmacy location) and (b) the patient application can make the address available to the user as it deems appropriate"
      },
      {
        "id" : "Organization.address.state",
        "path" : "Organization.address.state",
        "binding" : {
          "strength" : "extensible",
          "description" : "RTPBC Two Letter State and Province Codes",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-state-and-province-code"
        }
      },
      {
        "id" : "Organization.address.postalCode",
        "path" : "Organization.address.postalCode",
        "label" : "Postal code",
        "short" : "Postal code"
      },
      {
        "id" : "Organization.address.country",
        "path" : "Organization.address.country",
        "comment" : "Populate when not a US address",
        "binding" : {
          "strength" : "required",
          "description" : "ISO 3166 2-character country codes",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-country-code"
        }
      }
    ]
  }
}

```
